/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 *
 * @author fireshoes
 */
public class JimDavisCube extends DraftCube {

    public JimDavisCube() {
        super("Jim Davis's Cube (469 cards)"); // https://docs.google.com/spreadsheets/d/1pZ3aQR-Kb5MmMDNh1sOtMt4vSrJEWNixyZDZrQSBJb4/edit#gid=0

        cubeCards.add(new CardIdentity("Abbot of Keral Keep", ""));
        cubeCards.add(new CardIdentity("Abrupt Decay", ""));
        cubeCards.add(new CardIdentity("Absorb", ""));
        cubeCards.add(new CardIdentity("Academy Ruins", ""));
        cubeCards.add(new CardIdentity("Accorder Paladin", ""));
        cubeCards.add(new CardIdentity("Advantageous Proclamation", ""));
        cubeCards.add(new CardIdentity("Aether Vial", ""));
        cubeCards.add(new CardIdentity("Agent of Acquisitions", ""));
        cubeCards.add(new CardIdentity("Ajani Vengeant", ""));
        cubeCards.add(new CardIdentity("Ancient Den", ""));
        cubeCards.add(new CardIdentity("Ancient Tomb", ""));
        cubeCards.add(new CardIdentity("Animate Dead", ""));
        cubeCards.add(new CardIdentity("Ankh of Mishra", ""));
        cubeCards.add(new CardIdentity("Arcbound Ravager", ""));
        cubeCards.add(new CardIdentity("Arid Mesa", ""));
        cubeCards.add(new CardIdentity("Armageddon", ""));
        cubeCards.add(new CardIdentity("Ashen Rider", ""));
        cubeCards.add(new CardIdentity("Avacyn's Pilgrim", ""));
        cubeCards.add(new CardIdentity("Avenger of Zendikar", ""));
        cubeCards.add(new CardIdentity("Azorius Signet", ""));
        cubeCards.add(new CardIdentity("Backup Plan", ""));
        cubeCards.add(new CardIdentity("Badlands", ""));
        cubeCards.add(new CardIdentity("Balance", ""));
        cubeCards.add(new CardIdentity("Baleful Strix", ""));
        cubeCards.add(new CardIdentity("Baneslayer Angel", ""));
        cubeCards.add(new CardIdentity("Batterskull", ""));
        cubeCards.add(new CardIdentity("Battle Screech", ""));
        cubeCards.add(new CardIdentity("Battlefield Forge", ""));
        cubeCards.add(new CardIdentity("Bayou", ""));
        cubeCards.add(new CardIdentity("Bazaar of Baghdad", ""));
        cubeCards.add(new CardIdentity("Birds of Paradise", ""));
        cubeCards.add(new CardIdentity("Birthing Pod", ""));
        cubeCards.add(new CardIdentity("Bitterblossom", ""));
        cubeCards.add(new CardIdentity("Blackcleave Cliffs", ""));
        cubeCards.add(new CardIdentity("Blade Splicer", ""));
        cubeCards.add(new CardIdentity("Blightning", ""));
        cubeCards.add(new CardIdentity("Blinkmoth Nexus", ""));
        cubeCards.add(new CardIdentity("Blood Artist", ""));
        cubeCards.add(new CardIdentity("Blood Crypt", ""));
        cubeCards.add(new CardIdentity("Bloodbraid Elf", ""));
        cubeCards.add(new CardIdentity("Bloodghast", ""));
        cubeCards.add(new CardIdentity("Bloodsoaked Champion", ""));
        cubeCards.add(new CardIdentity("Bloodstained Mire", ""));
        cubeCards.add(new CardIdentity("Bonesplitter", ""));
        cubeCards.add(new CardIdentity("Boros Charm", ""));
        cubeCards.add(new CardIdentity("Boros Reckoner", ""));
        cubeCards.add(new CardIdentity("Bounding Krasis", ""));
        cubeCards.add(new CardIdentity("Braids, Cabal Minion", ""));
        cubeCards.add(new CardIdentity("Brain Freeze", ""));
        cubeCards.add(new CardIdentity("Brainstorm", ""));
        cubeCards.add(new CardIdentity("Breeding Pool", ""));
        cubeCards.add(new CardIdentity("Brimaz, King of Oreskos", ""));
        cubeCards.add(new CardIdentity("Bring to Light", ""));
        cubeCards.add(new CardIdentity("Broodmate Dragon", ""));
        cubeCards.add(new CardIdentity("Cabal Ritual", ""));
        cubeCards.add(new CardIdentity("Careful Study", ""));
        cubeCards.add(new CardIdentity("Carrion Feeder", ""));
        cubeCards.add(new CardIdentity("Catacomb Sifter", ""));
        cubeCards.add(new CardIdentity("Celestial Colonnade", ""));
        cubeCards.add(new CardIdentity("Chained to the Rocks", ""));
        cubeCards.add(new CardIdentity("Chain Lightning", ""));
        cubeCards.add(new CardIdentity("Champion of the Parish", ""));
        cubeCards.add(new CardIdentity("Chandra, Flamecaller", ""));
        cubeCards.add(new CardIdentity("Chandra's Phoenix", ""));
        cubeCards.add(new CardIdentity("Chromatic Sphere", ""));
        cubeCards.add(new CardIdentity("Chromatic Star", ""));
        cubeCards.add(new CardIdentity("Chrome Mox", ""));
        cubeCards.add(new CardIdentity("City of Brass", ""));
        cubeCards.add(new CardIdentity("City of Traitors", ""));
        cubeCards.add(new CardIdentity("Clifftop Retreat", ""));
        cubeCards.add(new CardIdentity("Coalition Relic", ""));
        cubeCards.add(new CardIdentity("Coercive Portal", ""));
        cubeCards.add(new CardIdentity("Cogwork Librarian", ""));
        cubeCards.add(new CardIdentity("Collected Company", ""));
        cubeCards.add(new CardIdentity("Condescend", ""));
        cubeCards.add(new CardIdentity("Copperline Gorge", ""));
        cubeCards.add(new CardIdentity("Council's Judgment", ""));
        cubeCards.add(new CardIdentity("Counterspell", ""));
        cubeCards.add(new CardIdentity("Cranial Plating", ""));
        cubeCards.add(new CardIdentity("Creeping Tar Pit", ""));
        cubeCards.add(new CardIdentity("Crop Rotation", ""));
        cubeCards.add(new CardIdentity("Crucible of Worlds", ""));
        cubeCards.add(new CardIdentity("Cruel Ultimatum", ""));
        cubeCards.add(new CardIdentity("Cryptic Command", ""));
        cubeCards.add(new CardIdentity("Curse of Shallow Graves", ""));
        cubeCards.add(new CardIdentity("Cursed Scroll", ""));
        cubeCards.add(new CardIdentity("Damnation", ""));
        cubeCards.add(new CardIdentity("Dark Confidant", ""));
        cubeCards.add(new CardIdentity("Dark Ritual", ""));
        cubeCards.add(new CardIdentity("Darkslick Shores", ""));
        cubeCards.add(new CardIdentity("Darksteel Citadel", ""));
        cubeCards.add(new CardIdentity("Daze", ""));
        cubeCards.add(new CardIdentity("Deal Broker", ""));
        cubeCards.add(new CardIdentity("Deathrite Shaman", ""));
        cubeCards.add(new CardIdentity("Declaration in Stone", ""));
        cubeCards.add(new CardIdentity("Delver of Secrets", ""));
        cubeCards.add(new CardIdentity("Demonic Tutor", ""));
        cubeCards.add(new CardIdentity("Detention Sphere", ""));
        cubeCards.add(new CardIdentity("Dig Through Time", ""));
        cubeCards.add(new CardIdentity("Dimir Signet", ""));
        cubeCards.add(new CardIdentity("Diregraf Ghoul", ""));
        cubeCards.add(new CardIdentity("Dismember", ""));
        cubeCards.add(new CardIdentity("Dragon Hunter", ""));
        cubeCards.add(new CardIdentity("Dragonlord Atarka", ""));
        cubeCards.add(new CardIdentity("Drana, Liberator of Malakir", ""));
        cubeCards.add(new CardIdentity("Dream Halls", ""));
        cubeCards.add(new CardIdentity("Dryad Militant", ""));
        cubeCards.add(new CardIdentity("Dust Bowl", ""));
        cubeCards.add(new CardIdentity("Dwarven Blastminer", ""));
        cubeCards.add(new CardIdentity("Edric, Spymaster of Trest", ""));
        cubeCards.add(new CardIdentity("Eidolon of the Great Revel", ""));
        cubeCards.add(new CardIdentity("Electrolyze", ""));
        cubeCards.add(new CardIdentity("Emrakul, the Aeons Torn", ""));
        cubeCards.add(new CardIdentity("Engineered Explosives", ""));
        cubeCards.add(new CardIdentity("Enlightened Tutor", ""));
        cubeCards.add(new CardIdentity("Entomb", ""));
        cubeCards.add(new CardIdentity("Etched Champion", ""));
        cubeCards.add(new CardIdentity("Eternal Witness", ""));
        cubeCards.add(new CardIdentity("Etherium Sculptor", ""));
        cubeCards.add(new CardIdentity("Ethersworn Canonist", ""));
        cubeCards.add(new CardIdentity("Eureka", ""));
        cubeCards.add(new CardIdentity("Everflowing Chalice", ""));
        cubeCards.add(new CardIdentity("Expedition Map", ""));
        cubeCards.add(new CardIdentity("Experiment One", ""));
        cubeCards.add(new CardIdentity("Explore", ""));
        cubeCards.add(new CardIdentity("Fact or Fiction", ""));
        cubeCards.add(new CardIdentity("Faithless Looting", ""));
        cubeCards.add(new CardIdentity("Falkenrath Aristocrat", ""));
        cubeCards.add(new CardIdentity("Falkenrath Gorger", ""));
        cubeCards.add(new CardIdentity("Far // Away", ""));
        cubeCards.add(new CardIdentity("Fastbond", ""));
        cubeCards.add(new CardIdentity("Fauna Shaman", ""));
        cubeCards.add(new CardIdentity("Figure of Destiny", ""));
        cubeCards.add(new CardIdentity("Fire // Ice", ""));
        cubeCards.add(new CardIdentity("Fireblast", ""));
        cubeCards.add(new CardIdentity("Firebolt", ""));
        cubeCards.add(new CardIdentity("Firestorm", ""));
        cubeCards.add(new CardIdentity("Flagstones of Trokair", ""));
        cubeCards.add(new CardIdentity("Flametongue Kavu", ""));
        cubeCards.add(new CardIdentity("Flesh Carver", ""));
        cubeCards.add(new CardIdentity("Flickerwisp", ""));
        cubeCards.add(new CardIdentity("Flinthoof Boar", ""));
        cubeCards.add(new CardIdentity("Flooded Strand", ""));
        cubeCards.add(new CardIdentity("Force of Will", ""));
        cubeCards.add(new CardIdentity("Forgotten Cave", ""));
        cubeCards.add(new CardIdentity("Frantic Search", ""));
        cubeCards.add(new CardIdentity("Frogmite", ""));
        cubeCards.add(new CardIdentity("Fulminator Mage", ""));
        cubeCards.add(new CardIdentity("Gaea's Cradle", ""));
        cubeCards.add(new CardIdentity("Galvanic Blast", ""));
        cubeCards.add(new CardIdentity("Gamble", ""));
        cubeCards.add(new CardIdentity("Garruk Wildspeaker", ""));
        cubeCards.add(new CardIdentity("Geist of Saint Traft", ""));
        cubeCards.add(new CardIdentity("Gemstone Mine", ""));
        cubeCards.add(new CardIdentity("Ghitu Encampment", ""));
        cubeCards.add(new CardIdentity("Ghor-Clan Rampager", ""));
        cubeCards.add(new CardIdentity("Gideon, Ally of Zendikar", ""));
        cubeCards.add(new CardIdentity("Gifts Ungiven", ""));
        cubeCards.add(new CardIdentity("Gilded Lotus", ""));
        cubeCards.add(new CardIdentity("Gitaxian Probe", ""));
        cubeCards.add(new CardIdentity("Gnarled Scarhide", ""));
        cubeCards.add(new CardIdentity("Go for the Throat", ""));
        cubeCards.add(new CardIdentity("Goblin Dark-Dwellers", ""));
        cubeCards.add(new CardIdentity("Goblin Guide", ""));
        cubeCards.add(new CardIdentity("Goblin Rabblemaster", ""));
        cubeCards.add(new CardIdentity("Goblin Welder", ""));
        cubeCards.add(new CardIdentity("Godless Shrine", ""));
        cubeCards.add(new CardIdentity("Golgari Rot Farm", ""));
        cubeCards.add(new CardIdentity("Grave Titan", ""));
        cubeCards.add(new CardIdentity("Gravecrawler", ""));
        cubeCards.add(new CardIdentity("Great Furnace", ""));
        cubeCards.add(new CardIdentity("Greater Gargadon", ""));
        cubeCards.add(new CardIdentity("Green Sun's Zenith", ""));
        cubeCards.add(new CardIdentity("Grim Lavamancer", ""));
        cubeCards.add(new CardIdentity("Grim Monolith", ""));
        cubeCards.add(new CardIdentity("Griselbrand", ""));
        cubeCards.add(new CardIdentity("Gush", ""));
        cubeCards.add(new CardIdentity("Hallowed Fountain", ""));
        cubeCards.add(new CardIdentity("Hallowed Spiritkeeper", ""));
        cubeCards.add(new CardIdentity("Hangarback Walker", ""));
        cubeCards.add(new CardIdentity("Harmonize", ""));
        cubeCards.add(new CardIdentity("Heartbeat of Spring", ""));
        cubeCards.add(new CardIdentity("Hellrider", ""));
        cubeCards.add(new CardIdentity("Hellspark Elemental", ""));
        cubeCards.add(new CardIdentity("Helm of Awakening", ""));
        cubeCards.add(new CardIdentity("Hero of Bladehold", ""));
        cubeCards.add(new CardIdentity("Hex Parasite", ""));
        cubeCards.add(new CardIdentity("Hinterland Harbor", ""));
        cubeCards.add(new CardIdentity("Hokori, Dust Drinker", ""));
        cubeCards.add(new CardIdentity("Hooting Mandrills", ""));
        cubeCards.add(new CardIdentity("Horizon Canopy", ""));
        cubeCards.add(new CardIdentity("Hymn to Tourach", ""));
        cubeCards.add(new CardIdentity("Imperial Recruiter", ""));
        cubeCards.add(new CardIdentity("Imperial Seal", ""));
        cubeCards.add(new CardIdentity("Inferno Titan", ""));
        cubeCards.add(new CardIdentity("Inquisition of Kozilek", ""));
        cubeCards.add(new CardIdentity("Isamaru, Hound of Konda", ""));
        cubeCards.add(new CardIdentity("Isochron Scepter", ""));
        cubeCards.add(new CardIdentity("Isolated Chapel", ""));
        cubeCards.add(new CardIdentity("Izzet Signet", ""));
        cubeCards.add(new CardIdentity("Jace, the Mind Sculptor", ""));
        cubeCards.add(new CardIdentity("Jace, Vryn's Prodigy", ""));
        cubeCards.add(new CardIdentity("Jeskai Ascendancy", ""));
        cubeCards.add(new CardIdentity("Joraga Treespeaker", ""));
        cubeCards.add(new CardIdentity("Jori En, Ruin Diver", ""));
        cubeCards.add(new CardIdentity("Karakas", ""));
        cubeCards.add(new CardIdentity("Karn Liberated", ""));
        cubeCards.add(new CardIdentity("Keranos, God of Storms", ""));
        cubeCards.add(new CardIdentity("Kessig Wolf Run", ""));
        cubeCards.add(new CardIdentity("Kiki-Jiki, Mirror Breaker", ""));
        cubeCards.add(new CardIdentity("Kira, Great Glass-Spinner", ""));
        cubeCards.add(new CardIdentity("Kird Ape", ""));
        cubeCards.add(new CardIdentity("Kitchen Finks", ""));
        cubeCards.add(new CardIdentity("Knight of the Reliquary", ""));
        cubeCards.add(new CardIdentity("Kolaghan's Command", ""));
        cubeCards.add(new CardIdentity("Kytheon, Hero of Akros", ""));
        cubeCards.add(new CardIdentity("Land Tax", ""));
        cubeCards.add(new CardIdentity("Life from the Loam", ""));
        cubeCards.add(new CardIdentity("Lightning Bolt", ""));
        cubeCards.add(new CardIdentity("Lightning Helix", ""));
        cubeCards.add(new CardIdentity("Lightning Mauler", ""));
        cubeCards.add(new CardIdentity("Liliana of the Veil", ""));
        cubeCards.add(new CardIdentity("Lim-Dul's Vault", ""));
        cubeCards.add(new CardIdentity("Lingering Souls", ""));
        cubeCards.add(new CardIdentity("Lion's Eye Diamond", ""));
        cubeCards.add(new CardIdentity("Llanowar Elves", ""));
        cubeCards.add(new CardIdentity("Loam Lion", ""));
        cubeCards.add(new CardIdentity("Lodestone Golem", ""));
        cubeCards.add(new CardIdentity("Lore Seeker", ""));
        cubeCards.add(new CardIdentity("Lotus Cobra", ""));
        cubeCards.add(new CardIdentity("Lotus Petal", ""));
        cubeCards.add(new CardIdentity("Maelstrom Pulse", ""));
        cubeCards.add(new CardIdentity("Magma Jet", ""));
        cubeCards.add(new CardIdentity("Makindi Sliderunner", ""));
        cubeCards.add(new CardIdentity("Mana Confluence", ""));
        cubeCards.add(new CardIdentity("Mana Leak", ""));
        cubeCards.add(new CardIdentity("Mardu Woe-Reaper", ""));
        cubeCards.add(new CardIdentity("Marsh Flats", ""));
        cubeCards.add(new CardIdentity("Martial Coup", ""));
        cubeCards.add(new CardIdentity("Master of Etherium", ""));
        cubeCards.add(new CardIdentity("Maze of Ith", ""));
        cubeCards.add(new CardIdentity("Meloku the Clouded Mirror", ""));
        cubeCards.add(new CardIdentity("Memnite", ""));
        cubeCards.add(new CardIdentity("Memory Jar", ""));
        cubeCards.add(new CardIdentity("Memory Lapse", ""));
        cubeCards.add(new CardIdentity("Mentor of the Meek", ""));
        cubeCards.add(new CardIdentity("Metalworker", ""));
        cubeCards.add(new CardIdentity("Mind Stone", ""));
        cubeCards.add(new CardIdentity("Mindslaver", ""));
        cubeCards.add(new CardIdentity("Mirari's Wake", ""));
        cubeCards.add(new CardIdentity("Mishra's Factory", ""));
        cubeCards.add(new CardIdentity("Misty Rainforest", ""));
        cubeCards.add(new CardIdentity("Molten Rain", ""));
        cubeCards.add(new CardIdentity("Moment's Peace", ""));
        cubeCards.add(new CardIdentity("Monastery Mentor", ""));
        cubeCards.add(new CardIdentity("Monastery Swiftspear", ""));
        cubeCards.add(new CardIdentity("Mother of Runes", ""));
        cubeCards.add(new CardIdentity("Mox Diamond", ""));
        cubeCards.add(new CardIdentity("Mox Opal", ""));
        cubeCards.add(new CardIdentity("Mulldrifter", ""));
        cubeCards.add(new CardIdentity("Murderous Cut", ""));
        cubeCards.add(new CardIdentity("Mutavault", ""));
        cubeCards.add(new CardIdentity("Myr Battlesphere", ""));
        cubeCards.add(new CardIdentity("Myrsmith", ""));
        cubeCards.add(new CardIdentity("Mystical Tutor", ""));
        cubeCards.add(new CardIdentity("Necropotence", ""));
        cubeCards.add(new CardIdentity("Nether Void", ""));
        cubeCards.add(new CardIdentity("Noble Hierarch", ""));
        cubeCards.add(new CardIdentity("Oath of Druids", ""));
        cubeCards.add(new CardIdentity("Oblivion Ring", ""));
        cubeCards.add(new CardIdentity("Ohran Viper", ""));
        cubeCards.add(new CardIdentity("Oona's Prowler", ""));
        cubeCards.add(new CardIdentity("Ophiomancer", ""));
        cubeCards.add(new CardIdentity("Opposition", ""));
        cubeCards.add(new CardIdentity("Oracle of Mul Daya", ""));
        cubeCards.add(new CardIdentity("Orzhov Signet", ""));
        cubeCards.add(new CardIdentity("Outpost Siege", ""));
        cubeCards.add(new CardIdentity("Overgrown Tomb", ""));
        cubeCards.add(new CardIdentity("Pack Rat", ""));
        cubeCards.add(new CardIdentity("Painful Truths", ""));
        cubeCards.add(new CardIdentity("Path to Exile", ""));
        cubeCards.add(new CardIdentity("Pernicious Deed", ""));
        cubeCards.add(new CardIdentity("Phantasmal Image", ""));
        cubeCards.add(new CardIdentity("Phyrexian Arena", ""));
        cubeCards.add(new CardIdentity("Phyrexian Metamorph", ""));
        cubeCards.add(new CardIdentity("Phyrexian Revoker", ""));
        cubeCards.add(new CardIdentity("Phyrexian Tower", ""));
        cubeCards.add(new CardIdentity("Pia and Kiran Nalaar", ""));
        cubeCards.add(new CardIdentity("Plateau", ""));
        cubeCards.add(new CardIdentity("Plow Under", ""));
        cubeCards.add(new CardIdentity("Polluted Delta", ""));
        cubeCards.add(new CardIdentity("Ponder", ""));
        cubeCards.add(new CardIdentity("Porcelain Legionnaire", ""));
        cubeCards.add(new CardIdentity("Power Play", ""));
        cubeCards.add(new CardIdentity("Precinct Captain", ""));
        cubeCards.add(new CardIdentity("Precursor Golem", ""));
        cubeCards.add(new CardIdentity("Preordain", ""));
        cubeCards.add(new CardIdentity("Primeval Titan", ""));
        cubeCards.add(new CardIdentity("Prismatic Lens", ""));
        cubeCards.add(new CardIdentity("Putrid Imp", ""));
        cubeCards.add(new CardIdentity("Qasali Pridemage", ""));
        cubeCards.add(new CardIdentity("Rakdos Cackler", ""));
        cubeCards.add(new CardIdentity("Rancor", ""));
        cubeCards.add(new CardIdentity("Ranger of Eos", ""));
        cubeCards.add(new CardIdentity("Ratchet Bomb", ""));
        cubeCards.add(new CardIdentity("Ravenous Baboons", ""));
        cubeCards.add(new CardIdentity("Razorverge Thicket", ""));
        cubeCards.add(new CardIdentity("Reanimate", ""));
        cubeCards.add(new CardIdentity("Reckless Charge", ""));
        cubeCards.add(new CardIdentity("Reclamation Sage", ""));
        cubeCards.add(new CardIdentity("Recurring Nightmare", ""));
        cubeCards.add(new CardIdentity("Reflector Mage", ""));
        cubeCards.add(new CardIdentity("Regrowth", ""));
        cubeCards.add(new CardIdentity("Relic Seeker", ""));
        cubeCards.add(new CardIdentity("Remand", ""));
        cubeCards.add(new CardIdentity("Restoration Angel", ""));
        cubeCards.add(new CardIdentity("Reveillark", ""));
        cubeCards.add(new CardIdentity("Rishadan Port", ""));
        cubeCards.add(new CardIdentity("Rofellos, Llanowar Emissary", ""));
        cubeCards.add(new CardIdentity("Rude Awakening", ""));
        cubeCards.add(new CardIdentity("Sacred Foundry", ""));
        cubeCards.add(new CardIdentity("Sakura-Tribe Elder", ""));
        cubeCards.add(new CardIdentity("Savannah", ""));
        cubeCards.add(new CardIdentity("Scalding Tarn", ""));
        cubeCards.add(new CardIdentity("Scavenging Ooze", ""));
        cubeCards.add(new CardIdentity("Scroll Rack", ""));
        cubeCards.add(new CardIdentity("Scrubland", ""));
        cubeCards.add(new CardIdentity("Scythe Leopard", ""));
        cubeCards.add(new CardIdentity("Seachrome Coast", ""));
        cubeCards.add(new CardIdentity("Searing Blaze", ""));
        cubeCards.add(new CardIdentity("Seat of the Synod", ""));
        cubeCards.add(new CardIdentity("Seeker of the Way", ""));
        cubeCards.add(new CardIdentity("Sensei's Divining Top", ""));
        cubeCards.add(new CardIdentity("Shadowmage Infiltrator", ""));
        cubeCards.add(new CardIdentity("Shambling Vent", ""));
        cubeCards.add(new CardIdentity("Shardless Agent", ""));
        cubeCards.add(new CardIdentity("Shelldock Isle", ""));
        cubeCards.add(new CardIdentity("Show and Tell", ""));
        cubeCards.add(new CardIdentity("Shrapnel Blast", ""));
        cubeCards.add(new CardIdentity("Siege Rhino", ""));
        cubeCards.add(new CardIdentity("Signal Pest", ""));
        cubeCards.add(new CardIdentity("Simic Growth Chamber", ""));
        cubeCards.add(new CardIdentity("Simic Signet", ""));
        cubeCards.add(new CardIdentity("Sinkhole", ""));
        cubeCards.add(new CardIdentity("Skullclamp", ""));
        cubeCards.add(new CardIdentity("Skyshroud Elite", ""));
        cubeCards.add(new CardIdentity("Smallpox", ""));
        cubeCards.add(new CardIdentity("Smokestack", ""));
        cubeCards.add(new CardIdentity("Snapcaster Mage", ""));
        cubeCards.add(new CardIdentity("Sneak Attack", ""));
        cubeCards.add(new CardIdentity("Soldier of the Pantheon", ""));
        cubeCards.add(new CardIdentity("Solemn Simulacrum", ""));
        cubeCards.add(new CardIdentity("Sorin, Lord of Innistrad", ""));
        cubeCards.add(new CardIdentity("Spear of Heliod", ""));
        cubeCards.add(new CardIdentity("Spectral Procession", ""));
        cubeCards.add(new CardIdentity("Spellskite", ""));
        cubeCards.add(new CardIdentity("Sphere of Resistance", ""));
        cubeCards.add(new CardIdentity("Sphinx's Revelation", ""));
        cubeCards.add(new CardIdentity("Squee, Goblin Nabob", ""));
        cubeCards.add(new CardIdentity("Standstill", ""));
        cubeCards.add(new CardIdentity("Steam Vents", ""));
        cubeCards.add(new CardIdentity("Steel Overseer", ""));
        cubeCards.add(new CardIdentity("Steppe Lynx", ""));
        cubeCards.add(new CardIdentity("Stoke the Flames", ""));
        cubeCards.add(new CardIdentity("Stomping Ground", ""));
        cubeCards.add(new CardIdentity("Stoneforge Mystic", ""));
        cubeCards.add(new CardIdentity("Stormchaser Mage", ""));
        cubeCards.add(new CardIdentity("Strangleroot Geist", ""));
        cubeCards.add(new CardIdentity("Strip Mine", ""));
        cubeCards.add(new CardIdentity("Stromkirk Noble", ""));
        cubeCards.add(new CardIdentity("Sudden Demise", ""));
        cubeCards.add(new CardIdentity("Sudden Shock", ""));
        cubeCards.add(new CardIdentity("Sulfur Falls", ""));
        cubeCards.add(new CardIdentity("Sulfuric Vortex", ""));
        cubeCards.add(new CardIdentity("Sun Titan", ""));
        cubeCards.add(new CardIdentity("Sundering Titan", ""));
        cubeCards.add(new CardIdentity("Survival of the Fittest", ""));
        cubeCards.add(new CardIdentity("Sword of Feast and Famine", ""));
        cubeCards.add(new CardIdentity("Sword of Fire and Ice", ""));
        cubeCards.add(new CardIdentity("Swords to Plowshares", ""));
        cubeCards.add(new CardIdentity("Sylvan Library", ""));
        cubeCards.add(new CardIdentity("Taiga", ""));
        cubeCards.add(new CardIdentity("Tangle Wire", ""));
        cubeCards.add(new CardIdentity("Tarmogoyf", ""));
        cubeCards.add(new CardIdentity("Tasigur, the Golden Fang", ""));
        cubeCards.add(new CardIdentity("Teetering Peaks", ""));
        cubeCards.add(new CardIdentity("Temple Garden", ""));
        cubeCards.add(new CardIdentity("Temple of Epiphany", ""));
        cubeCards.add(new CardIdentity("Temple of Malice", ""));
        cubeCards.add(new CardIdentity("Tendrils of Agony", ""));
        cubeCards.add(new CardIdentity("Terastodon", ""));
        cubeCards.add(new CardIdentity("Terminate", ""));
        cubeCards.add(new CardIdentity("Tezzeret, Agent of Bolas", ""));
        cubeCards.add(new CardIdentity("Thalia, Guardian of Thraben", ""));
        cubeCards.add(new CardIdentity("Thalia's Lieutenant", ""));
        cubeCards.add(new CardIdentity("The Abyss", ""));
        cubeCards.add(new CardIdentity("The Tabernacle at Pendrell Vale", ""));
        cubeCards.add(new CardIdentity("Thing in the Ice", ""));
        cubeCards.add(new CardIdentity("Thirst for Knowledge", ""));
        cubeCards.add(new CardIdentity("Thopter Engineer", ""));
        cubeCards.add(new CardIdentity("Thopter Spy Network", ""));
        cubeCards.add(new CardIdentity("Thoughtseize", ""));
        cubeCards.add(new CardIdentity("Thraben Inspector", ""));
        cubeCards.add(new CardIdentity("Thragtusk", ""));
        cubeCards.add(new CardIdentity("Thran Dynamo", ""));
        cubeCards.add(new CardIdentity("Tidehollow Sculler", ""));
        cubeCards.add(new CardIdentity("Time Spiral", ""));
        cubeCards.add(new CardIdentity("Timetwister", ""));
        cubeCards.add(new CardIdentity("Tin Street Hooligan", ""));
        cubeCards.add(new CardIdentity("Tinker", ""));
        cubeCards.add(new CardIdentity("Tireless Tracker", ""));
        cubeCards.add(new CardIdentity("Tolarian Academy", ""));
        cubeCards.add(new CardIdentity("Tooth and Nail", ""));
        cubeCards.add(new CardIdentity("Topplegeist", ""));
        cubeCards.add(new CardIdentity("Tormented Hero", ""));
        cubeCards.add(new CardIdentity("Tranquil Thicket", ""));
        cubeCards.add(new CardIdentity("Traverse the Ulvenwald", ""));
        cubeCards.add(new CardIdentity("Treachery", ""));
        cubeCards.add(new CardIdentity("Treasure Cruise", ""));
        cubeCards.add(new CardIdentity("Tree of Tales", ""));
        cubeCards.add(new CardIdentity("Treetop Village", ""));
        cubeCards.add(new CardIdentity("Trinket Mage", ""));
        cubeCards.add(new CardIdentity("Tropical Island", ""));
        cubeCards.add(new CardIdentity("Trygon Predator", ""));
        cubeCards.add(new CardIdentity("Tundra", ""));
        cubeCards.add(new CardIdentity("Turnabout", ""));
        cubeCards.add(new CardIdentity("Ugin, the Spirit Dragon", ""));
        cubeCards.add(new CardIdentity("Umezawa's Jitte", ""));
        cubeCards.add(new CardIdentity("Underground Sea", ""));
        cubeCards.add(new CardIdentity("Unexpectedly Absent", ""));
        cubeCards.add(new CardIdentity("Upheaval", ""));
        cubeCards.add(new CardIdentity("Urborg, Tomb of Yawgmoth", ""));
        cubeCards.add(new CardIdentity("Vampire Lacerator", ""));
        cubeCards.add(new CardIdentity("Vampiric Tutor", ""));
        cubeCards.add(new CardIdentity("Vault of Whispers", ""));
        cubeCards.add(new CardIdentity("Vault Skirge", ""));
        cubeCards.add(new CardIdentity("Vedalken Shackles", ""));
        cubeCards.add(new CardIdentity("Vendilion Clique", ""));
        cubeCards.add(new CardIdentity("Vengevine", ""));
        cubeCards.add(new CardIdentity("Venser, Shaper Savant", ""));
        cubeCards.add(new CardIdentity("Verdant Catacombs", ""));
        cubeCards.add(new CardIdentity("Village Messenger", ""));
        cubeCards.add(new CardIdentity("Vindicate", ""));
        cubeCards.add(new CardIdentity("Volcanic Island", ""));
        cubeCards.add(new CardIdentity("Volrath's Stronghold", ""));
        cubeCards.add(new CardIdentity("Voltaic Key", ""));
        cubeCards.add(new CardIdentity("Wall of Blossoms", ""));
        cubeCards.add(new CardIdentity("Wall of Omens", ""));
        cubeCards.add(new CardIdentity("Wall of Roots", ""));
        cubeCards.add(new CardIdentity("Wasteland", ""));
        cubeCards.add(new CardIdentity("Waterfront Bouncer", ""));
        cubeCards.add(new CardIdentity("Watery Grave", ""));
        cubeCards.add(new CardIdentity("Wheel of Fortune", ""));
        cubeCards.add(new CardIdentity("Whisperwood Elemental", ""));
        cubeCards.add(new CardIdentity("Wild Nacatl", ""));
        cubeCards.add(new CardIdentity("Wildfire", ""));
        cubeCards.add(new CardIdentity("Windbrisk Heights", ""));
        cubeCards.add(new CardIdentity("Windswept Heath", ""));
        cubeCards.add(new CardIdentity("Winter Orb", ""));
        cubeCards.add(new CardIdentity("Wooded Foothills", ""));
        cubeCards.add(new CardIdentity("Woodland Cemetery", ""));
        cubeCards.add(new CardIdentity("Worm Harvest", ""));
        cubeCards.add(new CardIdentity("Wrath of God", ""));
        cubeCards.add(new CardIdentity("Wurmcoil Engine", ""));
        cubeCards.add(new CardIdentity("Xathrid Necromancer", ""));
        cubeCards.add(new CardIdentity("Yawgmoth's Will", ""));
        cubeCards.add(new CardIdentity("Young Pyromancer", ""));
        cubeCards.add(new CardIdentity("Zurgo Bellstriker", ""));
    }
}
