/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 *
 * @author fireshoes
 */
public class SamBlacksCube extends DraftCube {

public SamBlacksCube() {
        super("Sam Black's No Search Cube"); // http://www.cubetutor.com/viewcube/69564

        cubeCards.add(new DraftCube.CardIdentity("Abbot of Keral Keep", ""));
        cubeCards.add(new DraftCube.CardIdentity("Abrupt Decay", ""));
        cubeCards.add(new DraftCube.CardIdentity("Acidic Slime", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aether Vial", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aetherling", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani Vengeant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani, Caller of the Pride", ""));
        cubeCards.add(new DraftCube.CardIdentity("Always Watching", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anafenza, Kin-Tree Spirit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancestral Recall", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancestral Vision", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancient Grudge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancient Tomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Angel of Serenity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anger of the Gods", ""));
        cubeCards.add(new DraftCube.CardIdentity("Animate Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arbor Elf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arcane Sanctum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Archangel Avacyn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Armageddon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Artisan of Kozilek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ashiok, Nightmare Weaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Atarka's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avenger of Zendikar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ayli, Eternal Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Chancery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Badlands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Balance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Baleful Strix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Baneslayer Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Banisher Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Banishing Light", ""));
        cubeCards.add(new DraftCube.CardIdentity("Barbarian Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Basalt Monolith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Batterskull", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bayou", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bazaar of Baghdad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Beast Within", ""));
        cubeCards.add(new DraftCube.CardIdentity("Become Immense", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bedlam Reveler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Benevolent Bodyguard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Birds of Paradise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bitterblossom", ""));
        cubeCards.add(new DraftCube.CardIdentity("Black Lotus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Black Sun's Zenith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blackcleave Cliffs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blade Splicer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Artist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodbraid Elf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodghast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodthrone Vampire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blossoming Defense", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bomat Courier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bone Shredder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bonfire of the Damned", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boros Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boros Garrison", ""));
        cubeCards.add(new DraftCube.CardIdentity("Braids, Cabal Minion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brimaz, King of Oreskos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brimstone Volley", ""));
        cubeCards.add(new DraftCube.CardIdentity("Broodmate Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burst Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Capsize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carrion Feeder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cartel Aristocrat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Catastrophe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Colonnade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chain Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Champion of the Parish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra's Phoenix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Flamecaller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Pyromaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Torch of Defiance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Channel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chaos Orb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chromatic Star", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chrome Mox", ""));
        cubeCards.add(new DraftCube.CardIdentity("City of Traitors", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coalition Relic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coercive Portal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coldsteel Heart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Compulsive Research", ""));
        cubeCards.add(new DraftCube.CardIdentity("Condemn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Condescend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Consecrated Sphinx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Contraband Kingpin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Control Magic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Corpse Dance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Council's Judgment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Counterspell", ""));
        cubeCards.add(new DraftCube.CardIdentity("Courser of Kruphix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crackling Doom", ""));
        cubeCards.add(new DraftCube.CardIdentity("Craterhoof Behemoth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Creeping Tar Pit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crumbling Necropolis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cryptbreaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cryptic Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crystal Shard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cultivator's Caravan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dack Fayden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dack's Duplicate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Damnation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Confidant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Ritual", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deceiver Exarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Delver of Secrets", ""));
        cubeCards.add(new DraftCube.CardIdentity("Den Protector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Desecration Demon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Desolate Lighthouse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dig Through Time", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dimir Aqueduct", ""));
        cubeCards.add(new DraftCube.CardIdentity("Disciple of Bolas", ""));
        cubeCards.add(new DraftCube.CardIdentity("Disenchant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismember", ""));
        cubeCards.add(new DraftCube.CardIdentity("Distended Mindbender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Domri Rade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doom Blade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Atarka", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Dromoka", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Ojutai", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Silumgar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dread Return", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dromoka's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Druidic Satchel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duplicant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duskwatch Recruiter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Edric, Spymaster of Trest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eidolon of the Great Revel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elder Deep-Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eldrazi Displacer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eldrazi Skyspawner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eldrazi Temple", ""));
        cubeCards.add(new DraftCube.CardIdentity("Electrolyze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elesh Norn, Grand Cenobite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elixir of Immortality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elspeth, Sun's Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elvish Visionary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Emrakul, the Aeons Torn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Emrakul, the Promised End", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enclave Cryptologist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Engineered Explosives", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ensnaring Bridge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomber Exarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eternal Witness", ""));
        cubeCards.add(new DraftCube.CardIdentity("Everflowing Chalice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evolutionary Leap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Exhume", ""));
        cubeCards.add(new DraftCube.CardIdentity("Explore", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fact or Fiction", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faith's Fetters", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faithless Looting", ""));
        cubeCards.add(new DraftCube.CardIdentity("Falkenrath Aristocrat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fastbond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feldon of the Third Path", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fellwar Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fiend Hunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fiery Justice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Figure of Destiny", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire // Ice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fireblast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firebolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firedrinker Satyr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flame Slash", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flametongue Kavu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fleecemane Lion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fleetwheel Cruiser", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flickerwisp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flooded Grove", ""));
        cubeCards.add(new DraftCube.CardIdentity("Force of Will", ""));
        cubeCards.add(new DraftCube.CardIdentity("Forked Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frantic Search", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frontier Bivouac", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frost Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gaea's Cradle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Garruk Wildspeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Garza's Assassin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gavony Township", ""));
        cubeCards.add(new DraftCube.CardIdentity("Geist of Saint Traft", ""));
        cubeCards.add(new DraftCube.CardIdentity("Genesis Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Genesis Wave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghor-Clan Rampager", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gideon Jura", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gideon, Ally of Zendikar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gilded Lotus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gitaxian Probe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Glen Elendra Archmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Glint-Nest Crane", ""));
        cubeCards.add(new DraftCube.CardIdentity("Go for the Throat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Bombardment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Bushwhacker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Dark-Dwellers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Rabblemaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Welder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Golgari Rot Farm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gonti, Lord of Luxury", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grave Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gray Merchant of Asphodel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Greater Gargadon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grenzo, Dungeon Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Lavamancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Monolith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Griselbrand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gruul Turf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hangarback Walker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hanweir Militia Captain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harbinger of the Tides", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harmonize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hedron Archive", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hellrider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hermit Druid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hero of Bladehold", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hero's Downfall", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hissing Quagmire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Honor of the Pure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hooting Mandrills", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hordeling Outburst", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hornet Queen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Huntmaster of the Fells", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hymn to Tourach", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incinerate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inferno Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inquisition of Kozilek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Insolent Neonate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ishkanah, Grafwidow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ivory Tower", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Boilerworks", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Signet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jace Beleren", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jace, Vryn's Prodigy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jace, the Mind Sculptor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Joraga Treespeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Journey to Nowhere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jungle Shrine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kalitas, Traitor of Ghet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Karakas", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kargan Dragonlord", ""));
        cubeCards.add(new DraftCube.CardIdentity("Karn Liberated", ""));
        cubeCards.add(new DraftCube.CardIdentity("Keranos, God of Storms", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kessig Wolf Run", ""));
        cubeCards.add(new DraftCube.CardIdentity("Key to the City", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kher Keep", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kiki-Jiki, Mirror Breaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kiora's Follower", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kiora, the Crashing Wave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kira, Great Glass-Spinner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kitchen Finks", ""));
        cubeCards.add(new DraftCube.CardIdentity("Knight of Glory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kokusho, the Evening Star", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kolaghan's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek's Return", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek, Butcher of Truth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krosan Grip", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kytheon, Hero of Akros", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lavaclaw Reaches", ""));
        cubeCards.add(new DraftCube.CardIdentity("Legacy's Allure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Legion Loyalist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leovold, Emissary of Trest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Library of Alexandria", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lifebane Zombie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Berserker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Helix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Mauler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana of the Veil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, Heretical Healer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, the Last Hope", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lingering Souls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Linvala, the Preserver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Living Death", ""));
        cubeCards.add(new DraftCube.CardIdentity("Llanowar Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lodestone Golem", ""));
        cubeCards.add(new DraftCube.CardIdentity("Looter il-Kor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lotleth Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lotus Bloom", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lumbering Falls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maelstrom Pulse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maelstrom Wanderer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magma Jet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Malicious Affliction", ""));
        cubeCards.add(new DraftCube.CardIdentity("Man-o'-War", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Crypt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Drain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Leak", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Tithe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Vault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Managorger Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mantis Rider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Marsh Flitter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Martial Coup", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master of Waves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master of the Wild Hunt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mastery of the Unseen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Masticore", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maze of Ith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Memory Jar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Metalworker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mind Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mind Twist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mindslaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mindwrack Demon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirari's Wake", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirran Crusader", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirror Entity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mishra's Factory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mishra's Workshop", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogg War Marshal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Molten Rain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monastery Mentor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monastery Swiftspear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moorland Haunt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mother of Runes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Diamond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Emerald", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Jet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Pearl", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Ruby", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Sapphire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mulldrifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Redcap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mutavault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Myr Battlesphere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mystic Monastery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nahiri, the Harbinger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nature's Claim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necromancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necropotence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Needle Spires", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nephalia Drownyard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nest Invader", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nicol Bolas, Planeswalker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Night's Whisper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nightveil Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nissa, Vital Force", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nissa, Voice of Zendikar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noble Hierarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nomad Outpost", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noose Constrictor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noxious Gearhulk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx-Fleece Ram", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oath of Druids", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oath of Nissa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Sower", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obstinate Baloth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obzedat, Ghost Council", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ohran Viper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ophiomancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opposition", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opulent Palace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oracle of Mul Daya", ""));
        cubeCards.add(new DraftCube.CardIdentity("Orzhov Basilica", ""));
        cubeCards.add(new DraftCube.CardIdentity("Outpost Siege", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pack Rat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pact of Negation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Painful Truths", ""));
        cubeCards.add(new DraftCube.CardIdentity("Paliano, the High City", ""));
        cubeCards.add(new DraftCube.CardIdentity("Palinchron", ""));
        cubeCards.add(new DraftCube.CardIdentity("Palladium Myr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pelakka Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pentavus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pernicious Deed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pestermite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phantasmal Image", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Metamorph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Revoker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Tower", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pia Nalaar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pia and Kiran Nalaar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plateau", ""));
        cubeCards.add(new DraftCube.CardIdentity("Polukranos, World Eater", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ponder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Porcelain Legionnaire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Precinct Captain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Preordain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Price of Progress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prime Speaker Zegana", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pristine Talisman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophet of Kruphix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Puppeteer Clique", ""));
        cubeCards.add(new DraftCube.CardIdentity("Quarantine Field", ""));
        cubeCards.add(new DraftCube.CardIdentity("Radiant Flames", ""));
        cubeCards.add(new DraftCube.CardIdentity("Raging Ravine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos Carnarium", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos's Return", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rancor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ratchet Bomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reality Smasher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reanimate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reassembling Skeleton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reclamation Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Recurring Nightmare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reflector Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Regrowth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Relic of Progenitus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Remand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Restoration Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reveillark", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ribbons of Night", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rift Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riftwing Cloudskate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rishadan Port", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rofellos, Llanowar Emissary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sandsteppe Citadel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Satyr Wayfinder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Lands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savannah", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scavenging Ooze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrapheap Scrounger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrubland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sea Gate Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sea Gate Wreckage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seal of Primordium", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Blaze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Blood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seaside Citadel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seasons Past", ""));
        cubeCards.add(new DraftCube.CardIdentity("Secure the Wastes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seeker of the Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Selesnya Sanctuary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Selfless Spirit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Setessan Tactics", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shambling Vent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shardless Agent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shelldock Isle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Show and Tell", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shriekmaw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shrine of Burning Rage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Siege Rhino", ""));
        cubeCards.add(new DraftCube.CardIdentity("Siege-Gang Commander", ""));
        cubeCards.add(new DraftCube.CardIdentity("Simic Growth Chamber", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sinkhole", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skirsdag High Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skullclamp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skysovereign, Consul Flagship", ""));
        cubeCards.add(new DraftCube.CardIdentity("Slaughter Pact", ""));
        cubeCards.add(new DraftCube.CardIdentity("Slayers' Stronghold", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smash to Smithereens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smokestack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smuggler's Copter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snapcaster Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sneak Attack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sol Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soldier of the Pantheon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sorin, Grim Nemesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sorin, Solemn Visitor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soulfire Grand Master", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sower of Temptation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spear of Heliod", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spectral Procession", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spell Pierce", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spell Queller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spellskite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphere of the Suns", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphinx of the Steel Wind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphinx's Revelation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Splinter Twin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stirring Wildwood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stoke the Flames", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormbreath Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stratus Dancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Strip Mine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Student of Warfare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sublime Archangel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sulfuric Vortex", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sun Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sundering Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Supreme Verdict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sword of Feast and Famine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sword of Fire and Ice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Swords to Plowshares", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvan Advocate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvan Caryatid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Taiga", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tamiyo, Field Researcher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tamiyo, the Moon Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tarmogoyf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tasigur, the Golden Fang", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Abandon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Deceit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Epiphany", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Malady", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Malice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Mystery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Mystery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Plenty", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Silence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Triumph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tendrils of Corruption", ""));
        cubeCards.add(new DraftCube.CardIdentity("Terastodon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Terminus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tezzeret, Agent of Bolas", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thalia's Lieutenant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thalia, Guardian of Thraben", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thalia, Heretic Cathar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thassa, God of the Sea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thing in the Ice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thirst for Knowledge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thopter Engineer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thought-Knot Seer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thoughtseize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thraben Inspector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thragtusk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thran Dynamo", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thrun, the Last Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thunderbreak Regent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thundermaw Hellkite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tidebinder Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Time Spiral", ""));
        cubeCards.add(new DraftCube.CardIdentity("Time Walk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Timely Reinforcements", ""));
        cubeCards.add(new DraftCube.CardIdentity("Timetwister", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tin Street Hooligan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tireless Tracker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tolarian Academy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tormenting Voice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Torrential Gearhulk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Toxic Deluge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tradewind Rider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trading Post", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treachery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treasure Cruise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treetop Village", ""));
        cubeCards.add(new DraftCube.CardIdentity("Triskelion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tropical Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("True-Name Nemesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tundra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Twilight Mire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ugin, the Spirit Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulamog, the Ceaseless Hunger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Umezawa's Jitte", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unburial Rites", ""));
        cubeCards.add(new DraftCube.CardIdentity("Underground Sea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unexpectedly Absent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unlicensed Disintegration", ""));
        cubeCards.add(new DraftCube.CardIdentity("Upheaval", ""));
        cubeCards.add(new DraftCube.CardIdentity("Utopia Sprawl", ""));
        cubeCards.add(new DraftCube.CardIdentity("Valorous Stance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampire Nighthawk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Varolz, the Scar-Striped", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vault of the Archangel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vedalken Shackles", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vendilion Clique", ""));
        cubeCards.add(new DraftCube.CardIdentity("Venser, Shaper Savant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Verdurous Gearhulk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vesuvan Shapeshifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Veteran Motorist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vindicate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viscera Seer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voice of Resurgence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volcanic Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volrath's Stronghold", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vraska the Unseen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Blossoms", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Omens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Roots", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wandering Fumarole", ""));
        cubeCards.add(new DraftCube.CardIdentity("Warden of the First Tree", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wasteland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Westvale Abbey", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wheel of Fortune", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whip of Erebos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whirler Rogue", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whisperwood Elemental", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wickerbough Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wild Growth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wildest Dreams", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wildfire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Windbrisk Heights", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wingmate Roc", ""));
        cubeCards.add(new DraftCube.CardIdentity("Winter Orb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wolfir Silverheart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Woodland Wanderer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Worn Powerstone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wrath of God", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wurmcoil Engine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Xathrid Necromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yawgmoth's Bargain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yawgmoth's Will", ""));
        cubeCards.add(new DraftCube.CardIdentity("Young Pyromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zealous Conscripts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zulaport Cutthroat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zurgo Bellstriker", ""));
    }
}