/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.cards.a;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.BeginningOfUpkeepTriggeredAbility;
import mage.abilities.effects.OneShotEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetPlayer;

/**
 *
 * @author TheElk801
 */
public class AxisOfMortality extends CardImpl {

    public AxisOfMortality(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ENCHANTMENT}, "{4}{W}{W}");

        // At the beginning of your upkeep, you may have two target players exchange life totals.
        Ability ability = new BeginningOfUpkeepTriggeredAbility(new AxisOfMortalityEffect(), TargetController.YOU, true);
        ability.addTarget(new TargetPlayer());
        ability.addTarget(new TargetPlayer());
        this.addAbility(ability);
    }

    public AxisOfMortality(final AxisOfMortality card) {
        super(card);
    }

    @Override
    public AxisOfMortality copy() {
        return new AxisOfMortality(this);
    }
}

class AxisOfMortalityEffect extends OneShotEffect {

    public AxisOfMortalityEffect() {
        super(Outcome.Neutral);
        this.staticText = "two target players exchange life totals";
    }

    public AxisOfMortalityEffect(final AxisOfMortalityEffect effect) {
        super(effect);
    }

    @Override
    public AxisOfMortalityEffect copy() {
        return new AxisOfMortalityEffect(this);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        Player player1 = game.getPlayer(source.getFirstTarget());
        Player player2 = game.getPlayer(source.getTargets().get(1).getFirstTarget());
        if (player1 != null && player2 != null) {
            int lifePlayer1 = player1.getLife();
            int lifePlayer2 = player2.getLife();

            if (lifePlayer1 == lifePlayer2) {
                return false;
            }

            if (!player1.isLifeTotalCanChange() || !player2.isLifeTotalCanChange()) {
                return false;
            }

            // 20110930 - 118.7, 118.8
            if (lifePlayer1 < lifePlayer2 && (!player1.isCanGainLife() || !player2.isCanLoseLife())) {
                return false;
            }

            if (lifePlayer1 > lifePlayer2 && (!player1.isCanLoseLife() || !player2.isCanGainLife())) {
                return false;
            }

            player1.setLife(lifePlayer2, game, source);
            player2.setLife(lifePlayer1, game, source);
            return true;
        }
        return false;
    }
}
