package mage.sets;

import mage.cards.ExpansionSet;
import mage.cards.b.BrassclawOrcs;
import mage.cards.d.DwarvenSoldier;
import mage.cards.g.GoblinWarDrums;
import mage.cards.h.HomaridWarrior;
import mage.cards.i.IcatianScout;
import mage.cards.i.InitiatesOfTheEbonHand;
import mage.cards.m.MesaFalcon;
import mage.cards.m.MindstabThrull;
import mage.cards.n.Necrite;
import mage.cards.r.ReefPirates;
import mage.cards.t.Torture;
import mage.cards.v.VodalianSoldiers;
import mage.constants.Rarity;
import mage.constants.SetType;

public class FifthEdition extends ExpansionSet {

    private static final FifthEdition instance = new FifthEdition();

    public static FifthEdition getInstance() {
        return instance;
    }

    private FifthEdition() {
        super("Fifth Edition", "5ED", ExpansionSet.buildDate(1997, 3, 1), SetType.CORE);
        this.hasBoosters = true;
        this.numBoosterLands = 0;
        this.numBoosterCommon = 11;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 0;
        cards.add(new SetCardInfo("Abbey Gargoyles", 1, Rarity.UNCOMMON, mage.cards.a.AbbeyGargoyles.class));
        cards.add(new SetCardInfo("Abyssal Specter", 139, Rarity.UNCOMMON, mage.cards.a.AbyssalSpecter.class));
        cards.add(new SetCardInfo("Adarkar Wastes", 410, Rarity.RARE, mage.cards.a.AdarkarWastes.class));
        cards.add(new SetCardInfo("Aether Storm", 70, Rarity.UNCOMMON, mage.cards.a.AetherStorm.class));
        cards.add(new SetCardInfo("Air Elemental", 71, Rarity.UNCOMMON, mage.cards.a.AirElemental.class));
        cards.add(new SetCardInfo("Akron Legionnaire", 2, Rarity.RARE, mage.cards.a.AkronLegionnaire.class));
        cards.add(new SetCardInfo("Alabaster Potion", 3, Rarity.COMMON, mage.cards.a.AlabasterPotion.class));
        cards.add(new SetCardInfo("Aladdin's Ring", 346, Rarity.RARE, mage.cards.a.AladdinsRing.class));
        cards.add(new SetCardInfo("Ambush Party", 208, Rarity.COMMON, mage.cards.a.AmbushParty.class));
        cards.add(new SetCardInfo("Amulet of Kroog", 347, Rarity.COMMON, mage.cards.a.AmuletOfKroog.class));
        cards.add(new SetCardInfo("An-Havva Constable", 277, Rarity.RARE, mage.cards.a.AnHavvaConstable.class));
        cards.add(new SetCardInfo("Angry Mob", 4, Rarity.UNCOMMON, mage.cards.a.AngryMob.class));
        cards.add(new SetCardInfo("Animate Dead", 140, Rarity.UNCOMMON, mage.cards.a.AnimateDead.class));
        cards.add(new SetCardInfo("Animate Wall", 5, Rarity.RARE, mage.cards.a.AnimateWall.class));
        cards.add(new SetCardInfo("Ankh of Mishra", 348, Rarity.RARE, mage.cards.a.AnkhOfMishra.class));
        cards.add(new SetCardInfo("Anti-Magic Aura", 72, Rarity.UNCOMMON, mage.cards.a.AntiMagicAura.class));
        cards.add(new SetCardInfo("Arenson's Aura", 6, Rarity.UNCOMMON, mage.cards.a.ArensonsAura.class));
        cards.add(new SetCardInfo("Armageddon", 7, Rarity.RARE, mage.cards.a.Armageddon.class));
        cards.add(new SetCardInfo("Armor of Faith", 8, Rarity.COMMON, mage.cards.a.ArmorOfFaith.class));
        cards.add(new SetCardInfo("Ashes to Ashes", 141, Rarity.UNCOMMON, mage.cards.a.AshesToAshes.class));
        cards.add(new SetCardInfo("Ashnod's Altar", 349, Rarity.UNCOMMON, mage.cards.a.AshnodsAltar.class));
        cards.add(new SetCardInfo("Ashnod's Transmogrant", 350, Rarity.COMMON, mage.cards.a.AshnodsTransmogrant.class));
        cards.add(new SetCardInfo("Aspect of Wolf", 278, Rarity.RARE, mage.cards.a.AspectOfWolf.class));
        cards.add(new SetCardInfo("Atog", 209, Rarity.UNCOMMON, mage.cards.a.Atog.class));
        cards.add(new SetCardInfo("Aurochs", 279, Rarity.COMMON, mage.cards.a.Aurochs.class));
        cards.add(new SetCardInfo("Aysen Bureaucrats", 9, Rarity.COMMON, mage.cards.a.AysenBureaucrats.class));
        cards.add(new SetCardInfo("Azure Drake", 73, Rarity.UNCOMMON, mage.cards.a.AzureDrake.class));
        cards.add(new SetCardInfo("Bad Moon", 142, Rarity.RARE, mage.cards.b.BadMoon.class));
        cards.add(new SetCardInfo("Ball Lightning", 210, Rarity.RARE, mage.cards.b.BallLightning.class));
        cards.add(new SetCardInfo("Barbed Sextant", 351, Rarity.COMMON, mage.cards.b.BarbedSextant.class));
        cards.add(new SetCardInfo("Barl's Cage", 352, Rarity.RARE, mage.cards.b.BarlsCage.class));
        cards.add(new SetCardInfo("Battering Ram", 353, Rarity.COMMON, mage.cards.b.BatteringRam.class));
        cards.add(new SetCardInfo("Benalish Hero", 10, Rarity.COMMON, mage.cards.b.BenalishHero.class));
        cards.add(new SetCardInfo("Binding Grasp", 74, Rarity.UNCOMMON, mage.cards.b.BindingGrasp.class));
        cards.add(new SetCardInfo("Bird Maiden", 211, Rarity.COMMON, mage.cards.b.BirdMaiden.class));
        cards.add(new SetCardInfo("Birds of Paradise", 280, Rarity.RARE, mage.cards.b.BirdsOfParadise.class));
        cards.add(new SetCardInfo("Black Knight", 143, Rarity.UNCOMMON, mage.cards.b.BlackKnight.class));
        cards.add(new SetCardInfo("Blessed Wine", 11, Rarity.COMMON, mage.cards.b.BlessedWine.class));
        cards.add(new SetCardInfo("Blight", 144, Rarity.UNCOMMON, mage.cards.b.Blight.class));
        cards.add(new SetCardInfo("Blinking Spirit", 12, Rarity.RARE, mage.cards.b.BlinkingSpirit.class));
        cards.add(new SetCardInfo("Blood Lust", 212, Rarity.COMMON, mage.cards.b.BloodLust.class));
        cards.add(new SetCardInfo("Bog Imp", 145, Rarity.COMMON, mage.cards.b.BogImp.class));
        cards.add(new SetCardInfo("Bog Rats", 146, Rarity.COMMON, mage.cards.b.BogRats.class));
        cards.add(new SetCardInfo("Bog Wraith", 147, Rarity.UNCOMMON, mage.cards.b.BogWraith.class));
        cards.add(new SetCardInfo("Boomerang", 75, Rarity.COMMON, mage.cards.b.Boomerang.class));
        cards.add(new SetCardInfo("Bottle of Suleiman", 354, Rarity.RARE, mage.cards.b.BottleOfSuleiman.class));
        cards.add(new SetCardInfo("Bottomless Vault", 411, Rarity.RARE, mage.cards.b.BottomlessVault.class));
        cards.add(new SetCardInfo("Brainstorm", 76, Rarity.COMMON, mage.cards.b.Brainstorm.class));
        cards.add(new SetCardInfo("Brainwash", 13, Rarity.COMMON, mage.cards.b.Brainwash.class));
        cards.add(new SetCardInfo("Brassclaw Orcs", 213, Rarity.COMMON, BrassclawOrcs.class));
        cards.add(new SetCardInfo("Breeding Pit", 148, Rarity.UNCOMMON, mage.cards.b.BreedingPit.class));
        cards.add(new SetCardInfo("Broken Visage", 149, Rarity.RARE, mage.cards.b.BrokenVisage.class));
        cards.add(new SetCardInfo("Brothers of Fire", 214, Rarity.COMMON, mage.cards.b.BrothersOfFire.class));
        cards.add(new SetCardInfo("Brushland", 412, Rarity.RARE, mage.cards.b.Brushland.class));
        cards.add(new SetCardInfo("Carapace", 281, Rarity.COMMON, mage.cards.c.Carapace.class));
        cards.add(new SetCardInfo("Caribou Range", 14, Rarity.RARE, mage.cards.c.CaribouRange.class));
        cards.add(new SetCardInfo("Carrion Ants", 150, Rarity.UNCOMMON, mage.cards.c.CarrionAnts.class));
        cards.add(new SetCardInfo("Castle", 15, Rarity.UNCOMMON, mage.cards.c.Castle.class));
        cards.add(new SetCardInfo("Cat Warriors", 282, Rarity.COMMON, mage.cards.c.CatWarriors.class));
        cards.add(new SetCardInfo("Cave People", 215, Rarity.UNCOMMON, mage.cards.c.CavePeople.class));
        cards.add(new SetCardInfo("Chub Toad", 283, Rarity.COMMON, mage.cards.c.ChubToad.class));
        cards.add(new SetCardInfo("Circle of Protection: Artifacts", 16, Rarity.COMMON, mage.cards.c.CircleOfProtectionArtifacts.class));
        cards.add(new SetCardInfo("Circle of Protection: Black", 17, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlack.class));
        cards.add(new SetCardInfo("Circle of Protection: Blue", 18, Rarity.COMMON, mage.cards.c.CircleOfProtectionBlue.class));
        cards.add(new SetCardInfo("Circle of Protection: Green", 19, Rarity.COMMON, mage.cards.c.CircleOfProtectionGreen.class));
        cards.add(new SetCardInfo("Circle of Protection: Red", 20, Rarity.COMMON, mage.cards.c.CircleOfProtectionRed.class));
        cards.add(new SetCardInfo("Circle of Protection: White", 21, Rarity.COMMON, mage.cards.c.CircleOfProtectionWhite.class));
        cards.add(new SetCardInfo("City of Brass", 413, Rarity.RARE, mage.cards.c.CityOfBrass.class));
        cards.add(new SetCardInfo("Clay Statue", 355, Rarity.COMMON, mage.cards.c.ClayStatue.class));
        cards.add(new SetCardInfo("Clockwork Beast", 356, Rarity.RARE, mage.cards.c.ClockworkBeast.class));
        cards.add(new SetCardInfo("Clockwork Steed", 357, Rarity.UNCOMMON, mage.cards.c.ClockworkSteed.class));
        cards.add(new SetCardInfo("Cockatrice", 284, Rarity.RARE, mage.cards.c.Cockatrice.class));
        cards.add(new SetCardInfo("Colossus of Sardia", 358, Rarity.RARE, mage.cards.c.ColossusOfSardia.class));
        cards.add(new SetCardInfo("Conquer", 216, Rarity.UNCOMMON, mage.cards.c.Conquer.class));
        cards.add(new SetCardInfo("Coral Helm", 359, Rarity.RARE, mage.cards.c.CoralHelm.class));
        cards.add(new SetCardInfo("Counterspell", 77, Rarity.COMMON, mage.cards.c.Counterspell.class));
        cards.add(new SetCardInfo("Craw Giant", 285, Rarity.UNCOMMON, mage.cards.c.CrawGiant.class));
        cards.add(new SetCardInfo("Craw Wurm", 286, Rarity.COMMON, mage.cards.c.CrawWurm.class));
        cards.add(new SetCardInfo("Crimson Manticore", 217, Rarity.RARE, mage.cards.c.CrimsonManticore.class));
        cards.add(new SetCardInfo("Crown of the Ages", 360, Rarity.RARE, mage.cards.c.CrownOfTheAges.class));
        cards.add(new SetCardInfo("Crumble", 287, Rarity.UNCOMMON, mage.cards.c.Crumble.class));
        cards.add(new SetCardInfo("Crusade", 22, Rarity.RARE, mage.cards.c.Crusade.class));
        cards.add(new SetCardInfo("Crystal Rod", 361, Rarity.UNCOMMON, mage.cards.c.CrystalRod.class));
        cards.add(new SetCardInfo("Cursed Land", 152, Rarity.UNCOMMON, mage.cards.c.CursedLand.class));
        cards.add(new SetCardInfo("D'Avenant Archer", 23, Rarity.COMMON, mage.cards.d.DAvenantArcher.class));
        cards.add(new SetCardInfo("Dance of Many", 78, Rarity.RARE, mage.cards.d.DanceOfMany.class));
        cards.add(new SetCardInfo("Dancing Scimitar", 362, Rarity.RARE, mage.cards.d.DancingScimitar.class));
        cards.add(new SetCardInfo("Dandan", 79, Rarity.COMMON, mage.cards.d.Dandan.class));
        cards.add(new SetCardInfo("Dark Maze", 80, Rarity.COMMON, mage.cards.d.DarkMaze.class));
        cards.add(new SetCardInfo("Dark Ritual", 153, Rarity.COMMON, mage.cards.d.DarkRitual.class));
        cards.add(new SetCardInfo("Death Speakers", 24, Rarity.COMMON, mage.cards.d.DeathSpeakers.class));
        cards.add(new SetCardInfo("Death Ward", 25, Rarity.COMMON, mage.cards.d.DeathWard.class));
        cards.add(new SetCardInfo("Deathgrip", 154, Rarity.UNCOMMON, mage.cards.d.Deathgrip.class));
        cards.add(new SetCardInfo("Deflection", 81, Rarity.RARE, mage.cards.d.Deflection.class));
        cards.add(new SetCardInfo("Derelor", 155, Rarity.RARE, mage.cards.d.Derelor.class));
        cards.add(new SetCardInfo("Desert Twister", 288, Rarity.UNCOMMON, mage.cards.d.DesertTwister.class));
        cards.add(new SetCardInfo("Detonate", 218, Rarity.UNCOMMON, mage.cards.d.Detonate.class));
        cards.add(new SetCardInfo("Diabolic Machine", 363, Rarity.UNCOMMON, mage.cards.d.DiabolicMachine.class));
        cards.add(new SetCardInfo("Dingus Egg", 364, Rarity.RARE, mage.cards.d.DingusEgg.class));
        cards.add(new SetCardInfo("Disenchant", 26, Rarity.COMMON, mage.cards.d.Disenchant.class));
        cards.add(new SetCardInfo("Disintegrate", 219, Rarity.COMMON, mage.cards.d.Disintegrate.class));
        cards.add(new SetCardInfo("Disrupting Scepter", 365, Rarity.RARE, mage.cards.d.DisruptingScepter.class));
        cards.add(new SetCardInfo("Divine Offering", 27, Rarity.COMMON, mage.cards.d.DivineOffering.class));
        cards.add(new SetCardInfo("Divine Transformation", 28, Rarity.UNCOMMON, mage.cards.d.DivineTransformation.class));
        cards.add(new SetCardInfo("Dragon Engine", 366, Rarity.RARE, mage.cards.d.DragonEngine.class));
        cards.add(new SetCardInfo("Drain Life", 156, Rarity.COMMON, mage.cards.d.DrainLife.class));
        cards.add(new SetCardInfo("Drain Power", 82, Rarity.RARE, mage.cards.d.DrainPower.class));
        cards.add(new SetCardInfo("Drudge Skeletons", 157, Rarity.COMMON, mage.cards.d.DrudgeSkeletons.class));
        cards.add(new SetCardInfo("Durkwood Boars", 289, Rarity.COMMON, mage.cards.d.DurkwoodBoars.class));
        cards.add(new SetCardInfo("Dust to Dust", 29, Rarity.UNCOMMON, mage.cards.d.DustToDust.class));
        cards.add(new SetCardInfo("Dwarven Catapult", 220, Rarity.UNCOMMON, mage.cards.d.DwarvenCatapult.class));
        cards.add(new SetCardInfo("Dwarven Hold", 414, Rarity.RARE, mage.cards.d.DwarvenHold.class));
        cards.add(new SetCardInfo("Dwarven Ruins", 415, Rarity.UNCOMMON, mage.cards.d.DwarvenRuins.class));
        cards.add(new SetCardInfo("Dwarven Soldier", 221, Rarity.COMMON, DwarvenSoldier.class));
        cards.add(new SetCardInfo("Dwarven Warriors", 222, Rarity.COMMON, mage.cards.d.DwarvenWarriors.class));
        cards.add(new SetCardInfo("Earthquake", 223, Rarity.RARE, mage.cards.e.Earthquake.class));
        cards.add(new SetCardInfo("Ebon Stronghold", 416, Rarity.UNCOMMON, mage.cards.e.EbonStronghold.class));
        cards.add(new SetCardInfo("Elder Druid", 290, Rarity.RARE, mage.cards.e.ElderDruid.class));
        cards.add(new SetCardInfo("Elkin Bottle", 367, Rarity.RARE, mage.cards.e.ElkinBottle.class));
        cards.add(new SetCardInfo("Elven Riders", 291, Rarity.UNCOMMON, mage.cards.e.ElvenRiders.class));
        cards.add(new SetCardInfo("Elvish Archers", 292, Rarity.RARE, mage.cards.e.ElvishArchers.class));
        cards.add(new SetCardInfo("Energy Flux", 83, Rarity.UNCOMMON, mage.cards.e.EnergyFlux.class));
        cards.add(new SetCardInfo("Enervate", 84, Rarity.COMMON, mage.cards.e.Enervate.class));
        cards.add(new SetCardInfo("Erg Raiders", 158, Rarity.COMMON, mage.cards.e.ErgRaiders.class));
        cards.add(new SetCardInfo("Errantry", 224, Rarity.COMMON, mage.cards.e.Errantry.class));
        cards.add(new SetCardInfo("Eternal Warrior", 225, Rarity.COMMON, mage.cards.e.EternalWarrior.class));
        cards.add(new SetCardInfo("Evil Eye of Orms-by-Gore", 159, Rarity.UNCOMMON, mage.cards.e.EvilEyeOfOrmsByGore.class));
        cards.add(new SetCardInfo("Evil Presence", 160, Rarity.UNCOMMON, mage.cards.e.EvilPresence.class));
        cards.add(new SetCardInfo("Eye for an Eye", 30, Rarity.RARE, mage.cards.e.EyeForAnEye.class));
        cards.add(new SetCardInfo("Fallen Angel", 161, Rarity.UNCOMMON, mage.cards.f.FallenAngel.class));
        cards.add(new SetCardInfo("Fear", 162, Rarity.COMMON, mage.cards.f.Fear.class));
        cards.add(new SetCardInfo("Feedback", 85, Rarity.UNCOMMON, mage.cards.f.Feedback.class));
        cards.add(new SetCardInfo("Feldon's Cane", 368, Rarity.UNCOMMON, mage.cards.f.FeldonsCane.class));
        cards.add(new SetCardInfo("Fellwar Stone", 369, Rarity.UNCOMMON, mage.cards.f.FellwarStone.class));
        cards.add(new SetCardInfo("Feroz's Ban", 370, Rarity.RARE, mage.cards.f.FerozsBan.class));
        cards.add(new SetCardInfo("Fire Drake", 226, Rarity.UNCOMMON, mage.cards.f.FireDrake.class));
        cards.add(new SetCardInfo("Fireball", 227, Rarity.COMMON, mage.cards.f.Fireball.class));
        cards.add(new SetCardInfo("Firebreathing", 228, Rarity.COMMON, mage.cards.f.Firebreathing.class));
        cards.add(new SetCardInfo("Flame Spirit", 229, Rarity.UNCOMMON, mage.cards.f.FlameSpirit.class));
        cards.add(new SetCardInfo("Flare", 230, Rarity.COMMON, mage.cards.f.Flare.class));
        cards.add(new SetCardInfo("Flashfires", 231, Rarity.UNCOMMON, mage.cards.f.Flashfires.class));
        cards.add(new SetCardInfo("Flight", 86, Rarity.COMMON, mage.cards.f.Flight.class));
        cards.add(new SetCardInfo("Flood", 87, Rarity.COMMON, mage.cards.f.Flood.class));
        cards.add(new SetCardInfo("Flying Carpet", 371, Rarity.RARE, mage.cards.f.FlyingCarpet.class));
        cards.add(new SetCardInfo("Fog", 293, Rarity.COMMON, mage.cards.f.Fog.class));
        cards.add(new SetCardInfo("Force of Nature", 294, Rarity.RARE, mage.cards.f.ForceOfNature.class));
        cards.add(new SetCardInfo("Force Spike", 88, Rarity.COMMON, mage.cards.f.ForceSpike.class));
        cards.add(new SetCardInfo("Forest", 446, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 447, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 448, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forest", 449, Rarity.LAND, mage.cards.basiclands.Forest.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Forget", 89, Rarity.RARE, mage.cards.f.Forget.class));
        cards.add(new SetCardInfo("Fountain of Youth", 372, Rarity.UNCOMMON, mage.cards.f.FountainOfYouth.class));
        cards.add(new SetCardInfo("Foxfire", 295, Rarity.COMMON, mage.cards.f.Foxfire.class));
        cards.add(new SetCardInfo("Frozen Shade", 163, Rarity.COMMON, mage.cards.f.FrozenShade.class));
        cards.add(new SetCardInfo("Funeral March", 164, Rarity.COMMON, mage.cards.f.FuneralMarch.class));
        cards.add(new SetCardInfo("Fungusaur", 296, Rarity.RARE, mage.cards.f.Fungusaur.class));
        cards.add(new SetCardInfo("Fyndhorn Elder", 297, Rarity.UNCOMMON, mage.cards.f.FyndhornElder.class));
        cards.add(new SetCardInfo("Game of Chaos", 232, Rarity.RARE, mage.cards.g.GameOfChaos.class));
        cards.add(new SetCardInfo("Gaseous Form", 90, Rarity.COMMON, mage.cards.g.GaseousForm.class));
        cards.add(new SetCardInfo("Gauntlets of Chaos", 373, Rarity.RARE, mage.cards.g.GauntletsOfChaos.class));
        cards.add(new SetCardInfo("Ghazban Ogre", 298, Rarity.COMMON, mage.cards.g.GhazbanOgre.class));
        cards.add(new SetCardInfo("Giant Growth", 299, Rarity.COMMON, mage.cards.g.GiantGrowth.class));
        cards.add(new SetCardInfo("Giant Spider", 300, Rarity.COMMON, mage.cards.g.GiantSpider.class));
        cards.add(new SetCardInfo("Giant Strength", 233, Rarity.COMMON, mage.cards.g.GiantStrength.class));
        cards.add(new SetCardInfo("Glacial Wall", 91, Rarity.UNCOMMON, mage.cards.g.GlacialWall.class));
        cards.add(new SetCardInfo("Glasses of Urza", 374, Rarity.UNCOMMON, mage.cards.g.GlassesOfUrza.class));
        cards.add(new SetCardInfo("Gloom", 165, Rarity.UNCOMMON, mage.cards.g.Gloom.class));
        cards.add(new SetCardInfo("Goblin Digging Team", 234, Rarity.COMMON, mage.cards.g.GoblinDiggingTeam.class));
        cards.add(new SetCardInfo("Goblin Hero", 235, Rarity.COMMON, mage.cards.g.GoblinHero.class));
        cards.add(new SetCardInfo("Goblin King", 236, Rarity.RARE, mage.cards.g.GoblinKing.class));
        cards.add(new SetCardInfo("Goblin War Drums", 237, Rarity.COMMON, GoblinWarDrums.class));
        cards.add(new SetCardInfo("Goblin Warrens", 238, Rarity.RARE, mage.cards.g.GoblinWarrens.class));
        cards.add(new SetCardInfo("Grapeshot Catapult", 375, Rarity.COMMON, mage.cards.g.GrapeshotCatapult.class));
        cards.add(new SetCardInfo("Greater Realm of Preservation", 31, Rarity.UNCOMMON, mage.cards.g.GreaterRealmOfPreservation.class));
        cards.add(new SetCardInfo("Greater Werewolf", 166, Rarity.UNCOMMON, mage.cards.g.GreaterWerewolf.class));
        cards.add(new SetCardInfo("Grizzly Bears", 301, Rarity.COMMON, mage.cards.g.GrizzlyBears.class));
        cards.add(new SetCardInfo("Havenwood Battleground", 417, Rarity.UNCOMMON, mage.cards.h.HavenwoodBattleground.class));
        cards.add(new SetCardInfo("Heal", 32, Rarity.COMMON, mage.cards.h.Heal.class));
        cards.add(new SetCardInfo("Healing Salve", 33, Rarity.COMMON, mage.cards.h.HealingSalve.class));
        cards.add(new SetCardInfo("Hecatomb", 167, Rarity.RARE, mage.cards.h.Hecatomb.class));
        cards.add(new SetCardInfo("Helm of Chatzuk", 376, Rarity.RARE, mage.cards.h.HelmOfChatzuk.class));
        cards.add(new SetCardInfo("Hill Giant", 239, Rarity.COMMON, mage.cards.h.HillGiant.class));
        cards.add(new SetCardInfo("Hollow Trees", 418, Rarity.RARE, mage.cards.h.HollowTrees.class));
        cards.add(new SetCardInfo("Holy Strength", 35, Rarity.COMMON, mage.cards.h.HolyStrength.class));
        cards.add(new SetCardInfo("Homarid Warrior", 92, Rarity.COMMON, HomaridWarrior.class));
        cards.add(new SetCardInfo("Howl from Beyond", 168, Rarity.COMMON, mage.cards.h.HowlFromBeyond.class));
        cards.add(new SetCardInfo("Howling Mine", 377, Rarity.RARE, mage.cards.h.HowlingMine.class));
        cards.add(new SetCardInfo("Hungry Mist", 302, Rarity.COMMON, mage.cards.h.HungryMist.class));
        cards.add(new SetCardInfo("Hurkyl's Recall", 93, Rarity.RARE, mage.cards.h.HurkylsRecall.class));
        cards.add(new SetCardInfo("Hurloon Minotaur", 240, Rarity.COMMON, mage.cards.h.HurloonMinotaur.class));
        cards.add(new SetCardInfo("Hurricane", 303, Rarity.UNCOMMON, mage.cards.h.Hurricane.class));
        cards.add(new SetCardInfo("Hydroblast", 94, Rarity.UNCOMMON, mage.cards.h.Hydroblast.class));
        cards.add(new SetCardInfo("Icatian Phalanx", 36, Rarity.UNCOMMON, mage.cards.i.IcatianPhalanx.class));
        cards.add(new SetCardInfo("Icatian Scout", 37, Rarity.COMMON, IcatianScout.class));
        cards.add(new SetCardInfo("Icatian Store", 419, Rarity.RARE, mage.cards.i.IcatianStore.class));
        cards.add(new SetCardInfo("Icatian Town", 38, Rarity.RARE, mage.cards.i.IcatianTown.class));
        cards.add(new SetCardInfo("Ice Floe", 420, Rarity.UNCOMMON, mage.cards.i.IceFloe.class));
        cards.add(new SetCardInfo("Imposing Visage", 241, Rarity.COMMON, mage.cards.i.ImposingVisage.class));
        cards.add(new SetCardInfo("Incinerate", 242, Rarity.COMMON, mage.cards.i.Incinerate.class));
        cards.add(new SetCardInfo("Inferno", 243, Rarity.RARE, mage.cards.i.Inferno.class));
        cards.add(new SetCardInfo("Infinite Hourglass", 378, Rarity.RARE, mage.cards.i.InfiniteHourglass.class));
        cards.add(new SetCardInfo("Initiates of the Ebon Hand", 169, Rarity.COMMON, InitiatesOfTheEbonHand.class));
        cards.add(new SetCardInfo("Instill Energy", 304, Rarity.UNCOMMON, mage.cards.i.InstillEnergy.class));
        cards.add(new SetCardInfo("Iron Star", 379, Rarity.UNCOMMON, mage.cards.i.IronStar.class));
        cards.add(new SetCardInfo("Ironclaw Curse", 244, Rarity.RARE, mage.cards.i.IronclawCurse.class));
        cards.add(new SetCardInfo("Ironclaw Orcs", 245, Rarity.COMMON, mage.cards.i.IronclawOrcs.class));
        cards.add(new SetCardInfo("Ironroot Treefolk", 305, Rarity.COMMON, mage.cards.i.IronrootTreefolk.class));
        cards.add(new SetCardInfo("Island Sanctuary", 39, Rarity.RARE, mage.cards.i.IslandSanctuary.class));
        cards.add(new SetCardInfo("Island", 434, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 435, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 436, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Island", 437, Rarity.LAND, mage.cards.basiclands.Island.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Ivory Cup", 380, Rarity.UNCOMMON, mage.cards.i.IvoryCup.class));
        cards.add(new SetCardInfo("Ivory Guardians", 40, Rarity.UNCOMMON, mage.cards.i.IvoryGuardians.class));
        cards.add(new SetCardInfo("Jade Monolith", 381, Rarity.RARE, mage.cards.j.JadeMonolith.class));
        cards.add(new SetCardInfo("Jalum Tome", 382, Rarity.RARE, mage.cards.j.JalumTome.class));
        cards.add(new SetCardInfo("Jandor's Saddlebags", 383, Rarity.RARE, mage.cards.j.JandorsSaddlebags.class));
        cards.add(new SetCardInfo("Jayemdae Tome", 384, Rarity.RARE, mage.cards.j.JayemdaeTome.class));
        cards.add(new SetCardInfo("Jester's Cap", 385, Rarity.RARE, mage.cards.j.JestersCap.class));
        cards.add(new SetCardInfo("Johtull Wurm", 306, Rarity.UNCOMMON, mage.cards.j.JohtullWurm.class));
        cards.add(new SetCardInfo("Jokulhaups", 246, Rarity.RARE, mage.cards.j.Jokulhaups.class));
        cards.add(new SetCardInfo("Joven's Tools", 386, Rarity.UNCOMMON, mage.cards.j.JovensTools.class));
        cards.add(new SetCardInfo("Justice", 41, Rarity.UNCOMMON, mage.cards.j.Justice.class));
        cards.add(new SetCardInfo("Juxtapose", 95, Rarity.RARE, mage.cards.j.Juxtapose.class));
        cards.add(new SetCardInfo("Karma", 42, Rarity.UNCOMMON, mage.cards.k.Karma.class));
        cards.add(new SetCardInfo("Karplusan Forest", 421, Rarity.RARE, mage.cards.k.KarplusanForest.class));
        cards.add(new SetCardInfo("Keldon Warlord", 247, Rarity.UNCOMMON, mage.cards.k.KeldonWarlord.class));
        cards.add(new SetCardInfo("Killer Bees", 307, Rarity.UNCOMMON, mage.cards.k.KillerBees.class));
        cards.add(new SetCardInfo("Kismet", 43, Rarity.UNCOMMON, mage.cards.k.Kismet.class));
        cards.add(new SetCardInfo("Kjeldoran Dead", 170, Rarity.COMMON, mage.cards.k.KjeldoranDead.class));
        cards.add(new SetCardInfo("Kjeldoran Royal Guard", 44, Rarity.RARE, mage.cards.k.KjeldoranRoyalGuard.class));
        cards.add(new SetCardInfo("Kjeldoran Skycaptain", 45, Rarity.UNCOMMON, mage.cards.k.KjeldoranSkycaptain.class));
        cards.add(new SetCardInfo("Knight of Stromgald", 171, Rarity.UNCOMMON, mage.cards.k.KnightOfStromgald.class));
        cards.add(new SetCardInfo("Krovikan Fetish", 172, Rarity.COMMON, mage.cards.k.KrovikanFetish.class));
        cards.add(new SetCardInfo("Krovikan Sorcerer", 96, Rarity.COMMON, mage.cards.k.KrovikanSorcerer.class));
        cards.add(new SetCardInfo("Labyrinth Minotaur", 97, Rarity.COMMON, mage.cards.l.LabyrinthMinotaur.class));
        cards.add(new SetCardInfo("Leshrac's Rite", 173, Rarity.UNCOMMON, mage.cards.l.LeshracsRite.class));
        cards.add(new SetCardInfo("Leviathan", 98, Rarity.RARE, mage.cards.l.Leviathan.class));
        cards.add(new SetCardInfo("Ley Druid", 308, Rarity.COMMON, mage.cards.l.LeyDruid.class));
        cards.add(new SetCardInfo("Lhurgoyf", 309, Rarity.RARE, mage.cards.l.Lhurgoyf.class));
        cards.add(new SetCardInfo("Library of Leng", 387, Rarity.UNCOMMON, mage.cards.l.LibraryOfLeng.class));
        cards.add(new SetCardInfo("Lifeforce", 310, Rarity.UNCOMMON, mage.cards.l.Lifeforce.class));
        cards.add(new SetCardInfo("Lifetap", 99, Rarity.UNCOMMON, mage.cards.l.Lifetap.class));
        cards.add(new SetCardInfo("Living Artifact", 311, Rarity.RARE, mage.cards.l.LivingArtifact.class));
        cards.add(new SetCardInfo("Living Lands", 312, Rarity.RARE, mage.cards.l.LivingLands.class));
        cards.add(new SetCardInfo("Llanowar Elves", 313, Rarity.COMMON, mage.cards.l.LlanowarElves.class));
        cards.add(new SetCardInfo("Lord of Atlantis", 100, Rarity.RARE, mage.cards.l.LordOfAtlantis.class));
        cards.add(new SetCardInfo("Lord of the Pit", 174, Rarity.RARE, mage.cards.l.LordOfThePit.class));
        cards.add(new SetCardInfo("Lost Soul", 175, Rarity.COMMON, mage.cards.l.LostSoul.class));
        cards.add(new SetCardInfo("Lure", 314, Rarity.UNCOMMON, mage.cards.l.Lure.class));
        cards.add(new SetCardInfo("Magus of the Unseen", 102, Rarity.RARE, mage.cards.m.MagusOfTheUnseen.class));
        cards.add(new SetCardInfo("Mana Clash", 248, Rarity.RARE, mage.cards.m.ManaClash.class));
        cards.add(new SetCardInfo("Mana Flare", 249, Rarity.RARE, mage.cards.m.ManaFlare.class));
        cards.add(new SetCardInfo("Mana Vault", 388, Rarity.RARE, mage.cards.m.ManaVault.class));
        cards.add(new SetCardInfo("Manabarbs", 250, Rarity.RARE, mage.cards.m.Manabarbs.class));
        cards.add(new SetCardInfo("Marsh Viper", 315, Rarity.COMMON, mage.cards.m.MarshViper.class));
        cards.add(new SetCardInfo("Meekstone", 389, Rarity.RARE, mage.cards.m.Meekstone.class));
        cards.add(new SetCardInfo("Memory Lapse", 103, Rarity.COMMON, mage.cards.m.MemoryLapse.class));
        cards.add(new SetCardInfo("Merfolk of the Pearl Trident", 104, Rarity.COMMON, mage.cards.m.MerfolkOfThePearlTrident.class));
        cards.add(new SetCardInfo("Mesa Falcon", 46, Rarity.COMMON, MesaFalcon.class));
        cards.add(new SetCardInfo("Mesa Pegasus", 47, Rarity.COMMON, mage.cards.m.MesaPegasus.class));
        cards.add(new SetCardInfo("Millstone", 390, Rarity.RARE, mage.cards.m.Millstone.class));
        cards.add(new SetCardInfo("Mind Bomb", 105, Rarity.UNCOMMON, mage.cards.m.MindBomb.class));
        cards.add(new SetCardInfo("Mind Ravel", 176, Rarity.COMMON, mage.cards.m.MindRavel.class));
        cards.add(new SetCardInfo("Mind Warp", 177, Rarity.UNCOMMON, mage.cards.m.MindWarp.class));
        cards.add(new SetCardInfo("Mindstab Thrull", 178, Rarity.COMMON, MindstabThrull.class));
        cards.add(new SetCardInfo("Mole Worms", 179, Rarity.UNCOMMON, mage.cards.m.MoleWorms.class));
        cards.add(new SetCardInfo("Mons's Goblin Raiders", 251, Rarity.COMMON, mage.cards.m.MonssGoblinRaiders.class));
        cards.add(new SetCardInfo("Mountain Goat", 252, Rarity.COMMON, mage.cards.m.MountainGoat.class));
        cards.add(new SetCardInfo("Mountain", 442, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 443, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 444, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Mountain", 445, Rarity.LAND, mage.cards.basiclands.Mountain.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Murk Dwellers", 180, Rarity.COMMON, mage.cards.m.MurkDwellers.class));
        cards.add(new SetCardInfo("Nature's Lore", 316, Rarity.COMMON, mage.cards.n.NaturesLore.class));
        cards.add(new SetCardInfo("Necrite", 181, Rarity.COMMON, Necrite.class));
        cards.add(new SetCardInfo("Necropotence", 182, Rarity.RARE, mage.cards.n.Necropotence.class));
        cards.add(new SetCardInfo("Nether Shadow", 183, Rarity.RARE, mage.cards.n.NetherShadow.class));
        cards.add(new SetCardInfo("Nevinyrral's Disk", 391, Rarity.RARE, mage.cards.n.NevinyrralsDisk.class));
        cards.add(new SetCardInfo("Nightmare", 184, Rarity.RARE, mage.cards.n.Nightmare.class));
        cards.add(new SetCardInfo("Obelisk of Undoing", 392, Rarity.RARE, mage.cards.o.ObeliskOfUndoing.class));
        cards.add(new SetCardInfo("Orcish Artillery", 253, Rarity.UNCOMMON, mage.cards.o.OrcishArtillery.class));
        cards.add(new SetCardInfo("Orcish Captain", 254, Rarity.UNCOMMON, mage.cards.o.OrcishCaptain.class));
        cards.add(new SetCardInfo("Orcish Oriflamme", 257, Rarity.UNCOMMON, mage.cards.o.OrcishOriflamme.class));
        cards.add(new SetCardInfo("Orcish Squatters", 258, Rarity.RARE, mage.cards.o.OrcishSquatters.class));
        cards.add(new SetCardInfo("Order of the Sacred Torch", 48, Rarity.RARE, mage.cards.o.OrderOfTheSacredTorch.class));
        cards.add(new SetCardInfo("Order of the White Shield", 49, Rarity.UNCOMMON, mage.cards.o.OrderOfTheWhiteShield.class));
        cards.add(new SetCardInfo("Orgg", 259, Rarity.RARE, mage.cards.o.Orgg.class));
        cards.add(new SetCardInfo("Ornithopter", 393, Rarity.UNCOMMON, mage.cards.o.Ornithopter.class));
        cards.add(new SetCardInfo("Panic", 260, Rarity.COMMON, mage.cards.p.Panic.class));
        cards.add(new SetCardInfo("Paralyze", 185, Rarity.COMMON, mage.cards.p.Paralyze.class));
        cards.add(new SetCardInfo("Pearled Unicorn", 50, Rarity.COMMON, mage.cards.p.PearledUnicorn.class));
        cards.add(new SetCardInfo("Pentagram of the Ages", 394, Rarity.RARE, mage.cards.p.PentagramOfTheAges.class));
        cards.add(new SetCardInfo("Personal Incarnation", 51, Rarity.RARE, mage.cards.p.PersonalIncarnation.class));
        cards.add(new SetCardInfo("Pestilence", 186, Rarity.COMMON, mage.cards.p.Pestilence.class));
        cards.add(new SetCardInfo("Phantasmal Forces", 106, Rarity.UNCOMMON, mage.cards.p.PhantasmalForces.class));
        cards.add(new SetCardInfo("Phantasmal Terrain", 107, Rarity.COMMON, mage.cards.p.PhantasmalTerrain.class));
        cards.add(new SetCardInfo("Phantom Monster", 108, Rarity.UNCOMMON, mage.cards.p.PhantomMonster.class));
        cards.add(new SetCardInfo("Pikemen", 52, Rarity.COMMON, mage.cards.p.Pikemen.class));
        cards.add(new SetCardInfo("Pirate Ship", 109, Rarity.RARE, mage.cards.p.PirateShip.class));
        cards.add(new SetCardInfo("Pit Scorpion", 187, Rarity.COMMON, mage.cards.p.PitScorpion.class));
        cards.add(new SetCardInfo("Plague Rats", 188, Rarity.COMMON, mage.cards.p.PlagueRats.class));
        cards.add(new SetCardInfo("Plains", 430, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 431, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 432, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Plains", 433, Rarity.LAND, mage.cards.basiclands.Plains.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Portent", 110, Rarity.COMMON, mage.cards.p.Portent.class));
        cards.add(new SetCardInfo("Power Sink", 111, Rarity.UNCOMMON, mage.cards.p.PowerSink.class));
        cards.add(new SetCardInfo("Pox", 189, Rarity.RARE, mage.cards.p.Pox.class));
        cards.add(new SetCardInfo("Pradesh Gypsies", 317, Rarity.COMMON, mage.cards.p.PradeshGypsies.class));
        cards.add(new SetCardInfo("Primal Clay", 395, Rarity.RARE, mage.cards.p.PrimalClay.class));
        cards.add(new SetCardInfo("Primal Order", 318, Rarity.RARE, mage.cards.p.PrimalOrder.class));
        cards.add(new SetCardInfo("Primordial Ooze", 261, Rarity.UNCOMMON, mage.cards.p.PrimordialOoze.class));
        cards.add(new SetCardInfo("Prismatic Ward", 53, Rarity.COMMON, mage.cards.p.PrismaticWard.class));
        cards.add(new SetCardInfo("Prodigal Sorcerer", 112, Rarity.COMMON, mage.cards.p.ProdigalSorcerer.class));
        cards.add(new SetCardInfo("Psychic Venom", 113, Rarity.COMMON, mage.cards.p.PsychicVenom.class));
        cards.add(new SetCardInfo("Pyroblast", 262, Rarity.UNCOMMON, mage.cards.p.Pyroblast.class));
        cards.add(new SetCardInfo("Pyrotechnics", 263, Rarity.UNCOMMON, mage.cards.p.Pyrotechnics.class));
        cards.add(new SetCardInfo("Rabid Wombat", 319, Rarity.UNCOMMON, mage.cards.r.RabidWombat.class));
        cards.add(new SetCardInfo("Radjan Spirit", 320, Rarity.UNCOMMON, mage.cards.r.RadjanSpirit.class));
        cards.add(new SetCardInfo("Rag Man", 190, Rarity.RARE, mage.cards.r.RagMan.class));
        cards.add(new SetCardInfo("Raise Dead", 191, Rarity.COMMON, mage.cards.r.RaiseDead.class));
        cards.add(new SetCardInfo("Ray of Command", 114, Rarity.COMMON, mage.cards.r.RayOfCommand.class));
        cards.add(new SetCardInfo("Recall", 115, Rarity.RARE, mage.cards.r.Recall.class));
        cards.add(new SetCardInfo("Reef Pirates", 116, Rarity.COMMON, ReefPirates.class));
        cards.add(new SetCardInfo("Regeneration", 321, Rarity.COMMON, mage.cards.r.Regeneration.class));
        cards.add(new SetCardInfo("Remove Soul", 117, Rarity.COMMON, mage.cards.r.RemoveSoul.class));
        cards.add(new SetCardInfo("Repentant Blacksmith", 54, Rarity.COMMON, mage.cards.r.RepentantBlacksmith.class));
        cards.add(new SetCardInfo("Reverse Damage", 55, Rarity.RARE, mage.cards.r.ReverseDamage.class));
        cards.add(new SetCardInfo("Righteousness", 56, Rarity.RARE, mage.cards.r.Righteousness.class));
        cards.add(new SetCardInfo("Rod of Ruin", 396, Rarity.UNCOMMON, mage.cards.r.RodOfRuin.class));
        cards.add(new SetCardInfo("Ruins of Trokair", 422, Rarity.UNCOMMON, mage.cards.r.RuinsOfTrokair.class));
        cards.add(new SetCardInfo("Sabretooth Tiger", 264, Rarity.COMMON, mage.cards.s.SabretoothTiger.class));
        cards.add(new SetCardInfo("Samite Healer", 58, Rarity.COMMON, mage.cards.s.SamiteHealer.class));
        cards.add(new SetCardInfo("Sand Silos", 423, Rarity.RARE, mage.cards.s.SandSilos.class));
        cards.add(new SetCardInfo("Scaled Wurm", 322, Rarity.COMMON, mage.cards.s.ScaledWurm.class));
        cards.add(new SetCardInfo("Scathe Zombies", 192, Rarity.COMMON, mage.cards.s.ScatheZombies.class));
        cards.add(new SetCardInfo("Scavenger Folk", 323, Rarity.COMMON, mage.cards.s.ScavengerFolk.class));
        cards.add(new SetCardInfo("Scryb Sprites", 324, Rarity.COMMON, mage.cards.s.ScrybSprites.class));
        cards.add(new SetCardInfo("Sea Serpent", 118, Rarity.COMMON, mage.cards.s.SeaSerpent.class));
        cards.add(new SetCardInfo("Sea Spirit", 119, Rarity.UNCOMMON, mage.cards.s.SeaSpirit.class));
        cards.add(new SetCardInfo("Sea Sprite", 120, Rarity.UNCOMMON, mage.cards.s.SeaSprite.class));
        cards.add(new SetCardInfo("Seasinger", 121, Rarity.UNCOMMON, mage.cards.s.Seasinger.class));
        cards.add(new SetCardInfo("Segovian Leviathan", 122, Rarity.UNCOMMON, mage.cards.s.SegovianLeviathan.class));
        cards.add(new SetCardInfo("Sengir Autocrat", 193, Rarity.RARE, mage.cards.s.SengirAutocrat.class));
        cards.add(new SetCardInfo("Serpent Generator", 397, Rarity.RARE, mage.cards.s.SerpentGenerator.class));
        cards.add(new SetCardInfo("Serra Bestiary", 60, Rarity.UNCOMMON, mage.cards.s.SerraBestiary.class));
        cards.add(new SetCardInfo("Serra Paladin", 61, Rarity.UNCOMMON, mage.cards.s.SerraPaladin.class));
        cards.add(new SetCardInfo("Shanodin Dryads", 325, Rarity.COMMON, mage.cards.s.ShanodinDryads.class));
        cards.add(new SetCardInfo("Shapeshifter", 398, Rarity.UNCOMMON, mage.cards.s.Shapeshifter.class));
        cards.add(new SetCardInfo("Shatter", 265, Rarity.COMMON, mage.cards.s.Shatter.class));
        cards.add(new SetCardInfo("Shatterstorm", 266, Rarity.UNCOMMON, mage.cards.s.Shatterstorm.class));
        cards.add(new SetCardInfo("Shield Bearer", 62, Rarity.COMMON, mage.cards.s.ShieldBearer.class));
        cards.add(new SetCardInfo("Shield Wall", 63, Rarity.COMMON, mage.cards.s.ShieldWall.class));
        cards.add(new SetCardInfo("Shivan Dragon", 267, Rarity.RARE, mage.cards.s.ShivanDragon.class));
        cards.add(new SetCardInfo("Shrink", 326, Rarity.COMMON, mage.cards.s.Shrink.class));
        cards.add(new SetCardInfo("Sibilant Spirit", 123, Rarity.RARE, mage.cards.s.SibilantSpirit.class));
        cards.add(new SetCardInfo("Skull Catapult", 399, Rarity.UNCOMMON, mage.cards.s.SkullCatapult.class));
        cards.add(new SetCardInfo("Smoke", 268, Rarity.RARE, mage.cards.s.Smoke.class));
        cards.add(new SetCardInfo("Sorceress Queen", 194, Rarity.RARE, mage.cards.s.SorceressQueen.class));
        cards.add(new SetCardInfo("Soul Barrier", 125, Rarity.COMMON, mage.cards.s.SoulBarrier.class));
        cards.add(new SetCardInfo("Soul Net", 400, Rarity.UNCOMMON, mage.cards.s.SoulNet.class));
        cards.add(new SetCardInfo("Spell Blast", 126, Rarity.COMMON, mage.cards.s.SpellBlast.class));
        cards.add(new SetCardInfo("Spirit Link", 64, Rarity.UNCOMMON, mage.cards.s.SpiritLink.class));
        cards.add(new SetCardInfo("Stampede", 327, Rarity.RARE, mage.cards.s.Stampede.class));
        cards.add(new SetCardInfo("Stasis", 127, Rarity.RARE, mage.cards.s.Stasis.class));
        cards.add(new SetCardInfo("Steal Artifact", 128, Rarity.UNCOMMON, mage.cards.s.StealArtifact.class));
        cards.add(new SetCardInfo("Stone Giant", 269, Rarity.UNCOMMON, mage.cards.s.StoneGiant.class));
        cards.add(new SetCardInfo("Stone Rain", 270, Rarity.COMMON, mage.cards.s.StoneRain.class));
        cards.add(new SetCardInfo("Stone Spirit", 271, Rarity.UNCOMMON, mage.cards.s.StoneSpirit.class));
        cards.add(new SetCardInfo("Stream of Life", 328, Rarity.COMMON, mage.cards.s.StreamOfLife.class));
        cards.add(new SetCardInfo("Stromgald Cabal", 195, Rarity.RARE, mage.cards.s.StromgaldCabal.class));
        cards.add(new SetCardInfo("Sulfurous Springs", 424, Rarity.RARE, mage.cards.s.SulfurousSprings.class));
        cards.add(new SetCardInfo("Svyelunite Temple", 425, Rarity.UNCOMMON, mage.cards.s.SvyeluniteTemple.class));
        cards.add(new SetCardInfo("Swamp", 438, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 439, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 440, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Swamp", 441, Rarity.LAND, mage.cards.basiclands.Swamp.class, NON_FULL_USE_VARIOUS));
        cards.add(new SetCardInfo("Sylvan Library", 329, Rarity.RARE, mage.cards.s.SylvanLibrary.class));
        cards.add(new SetCardInfo("Tarpan", 330, Rarity.COMMON, mage.cards.t.Tarpan.class));
        cards.add(new SetCardInfo("Tawnos's Weaponry", 401, Rarity.UNCOMMON, mage.cards.t.TawnossWeaponry.class));
        cards.add(new SetCardInfo("Terror", 196, Rarity.COMMON, mage.cards.t.Terror.class));
        cards.add(new SetCardInfo("The Brute", 272, Rarity.COMMON, mage.cards.t.TheBrute.class));
        cards.add(new SetCardInfo("The Hive", 402, Rarity.RARE, mage.cards.t.TheHive.class));
        cards.add(new SetCardInfo("The Wretched", 197, Rarity.RARE, mage.cards.t.TheWretched.class));
        cards.add(new SetCardInfo("Thicket Basilisk", 331, Rarity.UNCOMMON, mage.cards.t.ThicketBasilisk.class));
        cards.add(new SetCardInfo("Throne of Bone", 403, Rarity.UNCOMMON, mage.cards.t.ThroneOfBone.class));
        cards.add(new SetCardInfo("Thrull Retainer", 198, Rarity.UNCOMMON, mage.cards.t.ThrullRetainer.class));
        cards.add(new SetCardInfo("Time Bomb", 404, Rarity.RARE, mage.cards.t.TimeBomb.class));
        cards.add(new SetCardInfo("Time Elemental", 129, Rarity.RARE, mage.cards.t.TimeElemental.class));
        cards.add(new SetCardInfo("Titania's Song", 332, Rarity.RARE, mage.cards.t.TitaniasSong.class));
        cards.add(new SetCardInfo("Torture", 199, Rarity.COMMON, Torture.class));
        cards.add(new SetCardInfo("Touch of Death", 200, Rarity.COMMON, mage.cards.t.TouchOfDeath.class));
        cards.add(new SetCardInfo("Tranquility", 333, Rarity.COMMON, mage.cards.t.Tranquility.class));
        cards.add(new SetCardInfo("Truce", 65, Rarity.RARE, mage.cards.t.Truce.class));
        cards.add(new SetCardInfo("Tsunami", 334, Rarity.UNCOMMON, mage.cards.t.Tsunami.class));
        cards.add(new SetCardInfo("Tundra Wolves", 66, Rarity.COMMON, mage.cards.t.TundraWolves.class));
        cards.add(new SetCardInfo("Twiddle", 130, Rarity.COMMON, mage.cards.t.Twiddle.class));
        cards.add(new SetCardInfo("Underground River", 426, Rarity.RARE, mage.cards.u.UndergroundRiver.class));
        cards.add(new SetCardInfo("Unholy Strength", 201, Rarity.COMMON, mage.cards.u.UnholyStrength.class));
        cards.add(new SetCardInfo("Unstable Mutation", 131, Rarity.COMMON, mage.cards.u.UnstableMutation.class));
        cards.add(new SetCardInfo("Unsummon", 132, Rarity.COMMON, mage.cards.u.Unsummon.class));
        cards.add(new SetCardInfo("Untamed Wilds", 335, Rarity.UNCOMMON, mage.cards.u.UntamedWilds.class));
        cards.add(new SetCardInfo("Updraft", 133, Rarity.COMMON, mage.cards.u.Updraft.class));
        cards.add(new SetCardInfo("Urza's Avenger", 405, Rarity.RARE, mage.cards.u.UrzasAvenger.class));
        cards.add(new SetCardInfo("Urza's Bauble", 406, Rarity.UNCOMMON, mage.cards.u.UrzasBauble.class));
        cards.add(new SetCardInfo("Urza's Mine", 427, Rarity.COMMON, mage.cards.u.UrzasMine.class));
        cards.add(new SetCardInfo("Urza's Power Plant", 428, Rarity.COMMON, mage.cards.u.UrzasPowerPlant.class));
        cards.add(new SetCardInfo("Urza's Tower", 429, Rarity.COMMON, mage.cards.u.UrzasTower.class));
        cards.add(new SetCardInfo("Vampire Bats", 202, Rarity.COMMON, mage.cards.v.VampireBats.class));
        cards.add(new SetCardInfo("Venom", 336, Rarity.COMMON, mage.cards.v.Venom.class));
        cards.add(new SetCardInfo("Verduran Enchantress", 337, Rarity.RARE, mage.cards.v.VerduranEnchantress.class));
        cards.add(new SetCardInfo("Vodalian Soldiers", 134, Rarity.COMMON, VodalianSoldiers.class));
        cards.add(new SetCardInfo("Wall of Air", 135, Rarity.UNCOMMON, mage.cards.w.WallOfAir.class));
        cards.add(new SetCardInfo("Wall of Bone", 203, Rarity.UNCOMMON, mage.cards.w.WallOfBone.class));
        cards.add(new SetCardInfo("Wall of Brambles", 338, Rarity.UNCOMMON, mage.cards.w.WallOfBrambles.class));
        cards.add(new SetCardInfo("Wall of Fire", 273, Rarity.UNCOMMON, mage.cards.w.WallOfFire.class));
        cards.add(new SetCardInfo("Wall of Spears", 407, Rarity.COMMON, mage.cards.w.WallOfSpears.class));
        cards.add(new SetCardInfo("Wall of Stone", 274, Rarity.UNCOMMON, mage.cards.w.WallOfStone.class));
        cards.add(new SetCardInfo("Wall of Swords", 67, Rarity.UNCOMMON, mage.cards.w.WallOfSwords.class));
        cards.add(new SetCardInfo("Wanderlust", 339, Rarity.UNCOMMON, mage.cards.w.Wanderlust.class));
        cards.add(new SetCardInfo("War Mammoth", 340, Rarity.COMMON, mage.cards.w.WarMammoth.class));
        cards.add(new SetCardInfo("Warp Artifact", 204, Rarity.RARE, mage.cards.w.WarpArtifact.class));
        cards.add(new SetCardInfo("Weakness", 205, Rarity.COMMON, mage.cards.w.Weakness.class));
        cards.add(new SetCardInfo("Whirling Dervish", 341, Rarity.UNCOMMON, mage.cards.w.WhirlingDervish.class));
        cards.add(new SetCardInfo("White Knight", 68, Rarity.UNCOMMON, mage.cards.w.WhiteKnight.class));
        cards.add(new SetCardInfo("Wild Growth", 342, Rarity.COMMON, mage.cards.w.WildGrowth.class));
        cards.add(new SetCardInfo("Wind Spirit", 136, Rarity.UNCOMMON, mage.cards.w.WindSpirit.class));
        cards.add(new SetCardInfo("Winds of Change", 275, Rarity.RARE, mage.cards.w.WindsOfChange.class));
        cards.add(new SetCardInfo("Winter Blast", 343, Rarity.UNCOMMON, mage.cards.w.WinterBlast.class));
        cards.add(new SetCardInfo("Winter Orb", 408, Rarity.RARE, mage.cards.w.WinterOrb.class));
        cards.add(new SetCardInfo("Wolverine Pack", 344, Rarity.UNCOMMON, mage.cards.w.WolverinePack.class));
        cards.add(new SetCardInfo("Wooden Sphere", 409, Rarity.UNCOMMON, mage.cards.w.WoodenSphere.class));
        cards.add(new SetCardInfo("Word of Blasting", 276, Rarity.UNCOMMON, mage.cards.w.WordOfBlasting.class));
        cards.add(new SetCardInfo("Wrath of God", 69, Rarity.RARE, mage.cards.w.WrathOfGod.class));
        cards.add(new SetCardInfo("Wyluli Wolf", 345, Rarity.RARE, mage.cards.w.WyluliWolf.class));
        cards.add(new SetCardInfo("Xenic Poltergeist", 206, Rarity.RARE, mage.cards.x.XenicPoltergeist.class));
        cards.add(new SetCardInfo("Zephyr Falcon", 137, Rarity.COMMON, mage.cards.z.ZephyrFalcon.class));
        cards.add(new SetCardInfo("Zombie Master", 207, Rarity.RARE, mage.cards.z.ZombieMaster.class));
        cards.add(new SetCardInfo("Zur's Weirding", 138, Rarity.RARE, mage.cards.z.ZursWeirding.class));
    }
}
