/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package org.mage.test.cards.abilities.keywords;

import mage.constants.PhaseStep;
import mage.constants.Zone;
import org.junit.Test;
import org.mage.test.serverside.base.CardTestPlayerBase;

/**
 *
 * @author LevelX2
 */

public class ExploitTest extends CardTestPlayerBase {

    /**
     * 702.109. Exploit
     *
     * 702.109a Exploit is a triggered ability. “Exploit” means “When this creature enters the battlefield, you may sacrifice a creature.”
     *
     * 702.109b A creature with exploit “exploits a creature” when the controller of the exploit ability sacrifices a creature as that ability resolves.
     *
     * You choose whether to sacrifice a creature and which creature to sacrifice as the exploit ability resolves.
     * You can sacrifice the creature with exploit if it’s still on the battlefield. This will cause its other ability to trigger.
     * You can’t sacrifice more than one creature to any one exploit ability.
     *
     */

    @Test
    public void testNormalUse() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Silumgar Butcher exploits a creature, target creature gets -3/-3 until end of turn.
        addCard(Zone.HAND, playerA, "Silumgar Butcher");
        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion");

        addCard(Zone.BATTLEFIELD, playerB, "Thundering Giant"); // 4/3

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Silumgar Butcher");
        setChoice(playerA, "Yes");
        addTarget(playerA, "Silvercoat Lion"); // sacrifice to Exploit
        addTarget(playerA, "Thundering Giant"); // Target for the -3/-3

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertPermanentCount(playerA, "Silumgar Butcher", 1);
        assertGraveyardCount(playerA, "Silvercoat Lion", 1);
        assertGraveyardCount(playerB, "Thundering Giant", 1);
        
    }
    /**
     * Test that the Exploit ability won't trigger if the creature with
     * exploit left the battlefiled before the Enters the battlefield
     * triggered ability resolves.
     *
     */
    @Test
    public void testExploitTriggerWontGo() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Silumgar Butcher exploits a creature, target creature gets -3/-3 until end of turn.
        addCard(Zone.HAND, playerA, "Silumgar Butcher");
        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion");

        addCard(Zone.BATTLEFIELD, playerB, "Mountain", 1);
        addCard(Zone.HAND, playerB, "Lightning Bolt", 1);
        addCard(Zone.BATTLEFIELD, playerB, "Thundering Giant"); // 4/3

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Silumgar Butcher");
        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerB, "Lightning Bolt", "Silumgar Butcher");
        setChoice(playerA, "Yes");
        addTarget(playerA, "Silvercoat Lion"); // sacrifice to Exploit
        addTarget(playerA, "Thundering Giant"); // Target for the -3/-3

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertGraveyardCount(playerB, "Lightning Bolt", 1);
        assertGraveyardCount(playerA, "Silumgar Butcher", 1);
        assertGraveyardCount(playerA, "Silvercoat Lion", 1);
        assertPermanentCount(playerB, "Thundering Giant", 1);

    }

    /**
     * Test that the Exploit ability won't trigger if the creature with
     * exploit left the battlefiled before the Enters the battlefield
     * triggered ability resolves.
     *
     */
    @Test
    public void testSacrificeCreatureWithExploit() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 2);
        // Exploit (When this creature enters the battlefield, you may sacrifice a creature.)
        // When Qarsi Sadist exploits a creature, target opponent loses 2 life and you gain 2 life.
        addCard(Zone.HAND, playerA, "Qarsi Sadist");

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Qarsi Sadist");
        setChoice(playerA, "Yes");
        addTarget(playerA, "Qarsi Sadist"); // sacrifice to Exploit
        addTarget(playerA, playerB); // Target for lose life

        setStopAt(1, PhaseStep.BEGIN_COMBAT);
        execute();

        assertGraveyardCount(playerA, "Qarsi Sadist", 1);

        assertLife(playerA, 22);
        assertLife(playerB, 18);

    }

}