/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package org.mage.test.rollback;

import mage.constants.PhaseStep;
import mage.constants.Zone;
import org.junit.Test;
import org.mage.test.serverside.base.CardTestPlayerBase;

/**
 *
 * @author LevelX2
 */
public class NewCreaturesAreRemovedTest extends CardTestPlayerBase {

    /**
     * I was playing with a Tamiyo's Journal in the battlefield.
     *
     * During my turn I rollbacked. The clue generated by Tamiyo's Journal
     * stayed on battlefield and when my turn started again, it re-investigated
     * for another one.
     *
     */
    @Test
    public void testTamiyosJournal() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // At the beginning of your upkeep, investigate (Create a colorless Clue artifact token onto the battlefield with \"{2}, Sacrifice this artifact: Draw a card.\").
        // {T}, Sacrifice three Clues: Search your library for a card and put that card into your hand. Then shuffle your library.
        addCard(Zone.HAND, playerA, "Tamiyo's Journal"); // Artifact {5}
        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion", 3);
        addCard(Zone.BATTLEFIELD, playerB, "Pillarfield Ox", 3);

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Tamiyo's Journal");

        // As Port Town enters the battlefield, you may reveal a Plains or Island card from your hand. If you don't, Port Town enters the battlefield tapped.
        // {T}: Add {W} or {U}.
        addCard(Zone.HAND, playerA, "Port Town"); // Land
        addCard(Zone.HAND, playerA, "Island"); // Land

        attack(2, playerB, "Pillarfield Ox");

        attack(3, playerA, "Silvercoat Lion");

        attack(4, playerB, "Pillarfield Ox");

        attack(5, playerA, "Silvercoat Lion");

        attack(6, playerB, "Pillarfield Ox");

        playLand(7, PhaseStep.PRECOMBAT_MAIN, playerA, "Port Town");
        attack(7, playerA, "Silvercoat Lion");

        setStopAt(7, PhaseStep.POSTCOMBAT_MAIN);
        execute();

        assertLife(playerA, 14);
        assertLife(playerB, 14);
        assertPermanentCount(playerA, "Port Town", 1);
        assertTapped("Port Town", false);
        assertPermanentCount(playerA, "Clue", 3);

    }

    @Test
    public void testTamiyosJournalAndRollback() {
        addCard(Zone.BATTLEFIELD, playerA, "Swamp", 5);
        // At the beginning of your upkeep, investigate (Create a colorless Clue artifact token onto the battlefield with \"{2}, Sacrifice this artifact: Draw a card.\").
        // {T}, Sacrifice three Clues: Search your library for a card and put that card into your hand. Then shuffle your library.
        addCard(Zone.HAND, playerA, "Tamiyo's Journal"); // Artifact {5}

        // As Port Town enters the battlefield, you may reveal a Plains or Island card from your hand. If you don't, Port Town enters the battlefield tapped.
        // {T}: Add {W} or {U}.
        addCard(Zone.HAND, playerA, "Port Town"); // Land
        addCard(Zone.HAND, playerA, "Island"); // Land

        addCard(Zone.BATTLEFIELD, playerA, "Silvercoat Lion", 3);
        addCard(Zone.BATTLEFIELD, playerB, "Pillarfield Ox", 3);

        castSpell(1, PhaseStep.PRECOMBAT_MAIN, playerA, "Tamiyo's Journal");

        attack(2, playerB, "Pillarfield Ox");

        attack(3, playerA, "Silvercoat Lion");
        rollbackTurns(3, PhaseStep.END_TURN, playerA, 0);

        attack(4, playerB, "Pillarfield Ox");

        attack(5, playerA, "Silvercoat Lion");

        rollbackTurns(5, PhaseStep.END_TURN, playerA, 0);

        attack(6, playerB, "Pillarfield Ox");

        playLand(7, PhaseStep.PRECOMBAT_MAIN, playerA, "Port Town");
        attack(7, playerA, "Silvercoat Lion");

        rollbackTurns(7, PhaseStep.END_TURN, playerA, 0);

        setStopAt(7, PhaseStep.POSTCOMBAT_MAIN);
        execute();

        assertPermanentCount(playerA, "Port Town", 1);
        assertTapped("Port Town", false);
        assertPermanentCount(playerA, "Clue", 3);

        assertLife(playerA, 14);
        assertLife(playerB, 14);

    }

}
