/*
 * Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of BetaSteward_at_googlemail.com.
 */
package mage.abilities.effects;

import mage.abilities.Ability;
import mage.constants.Duration;
import mage.constants.EffectType;
import mage.constants.Outcome;
import mage.game.Game;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public abstract class ReplacementEffectImpl extends ContinuousEffectImpl implements ReplacementEffect {

    // 614.12
    // Some replacement effects modify how a permanent enters the battlefield. (See rules 614.1c-d.)
    // Such effects may come from the permanent itself if they affect only that permanent (as opposed
    // to a general subset of permanents that includes it). They may also come from other sources. To
    // determine which replacement effects apply and how they apply, check the characteristics of the
    // permanent as it would exist on the battlefield, taking into account replacement effects that have
    // already modified how it enters the battlefield (see rule 616.1), continuous effects generated by
    // the resolution of spells or abilities that changed the permanent's characteristics on the stack
    // (see rule 400.7a), and continuous effects from the permanent's own static abilities, but ignoring
    // continuous effects from any other source that would affect it.
    protected boolean selfScope;

    public ReplacementEffectImpl(Duration duration, Outcome outcome) {
        this(duration, outcome, true);
    }

    /**
     *
     * @param duration
     * @param outcome
     * @param selfScope - is only relevant while permanents entering the
     * battlefield events
     */
    public ReplacementEffectImpl(Duration duration, Outcome outcome, boolean selfScope) {
        super(duration, outcome);
        this.effectType = EffectType.REPLACEMENT;
        this.selfScope = selfScope;
    }

    public ReplacementEffectImpl(final ReplacementEffectImpl effect) {
        super(effect);
        this.selfScope = effect.selfScope;
    }

    @Override
    public boolean hasSelfScope() {
        return selfScope;
    }

    @Override
    public boolean apply(Game game, Ability source) {
        throw new UnsupportedOperationException("Not used for replacemnt effect.");
    }

}
