/*
 *  Copyright 2011 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.view;

import java.io.Serializable;
import mage.game.tournament.TournamentType;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public class TournamentTypeView implements Serializable {

    private static final long serialVersionUID = 2L;

    private final String name;
    private final int minPlayers;
    private final int maxPlayers;
    private final int numBoosters;
    private final boolean draft;
    private final boolean limited;
    private final boolean cubeBooster;
    private final boolean elimination;
    private final boolean random;
    private final boolean richMan;

    public TournamentTypeView(TournamentType tournamentType) {
        this.name = tournamentType.getName();
        this.minPlayers = tournamentType.getMinPlayers();
        this.maxPlayers = tournamentType.getMaxPlayers();
        this.numBoosters = tournamentType.getNumBoosters();
        this.draft = tournamentType.isDraft();
        this.limited = tournamentType.isLimited();
        this.cubeBooster = tournamentType.isCubeBooster();
        this.elimination = tournamentType.isElimination();
        this.random = tournamentType.isRandom();
        this.richMan = tournamentType.isRichMan();
    }

    @Override
    public String toString() {
        return name;
    }

    public String getName() {
        return name;
    }

    public int getMinPlayers() {
        return minPlayers;
    }

    public int getMaxPlayers() {
        return maxPlayers;
    }

    public int getNumBoosters() {
        return numBoosters;
    }

    public boolean isDraft() {
        return draft;
    }

    public boolean isLimited() {
        return limited;
    }

    public boolean isCubeBooster() {
        return cubeBooster;
    }

    public boolean isElimination() {
        return elimination;
    }

    public boolean isRandom() {
        return random;
    }

    public boolean isRichMan() {
        return richMan;
    }
} 
