/*
* Copyright 2011 BetaSteward_at_googlemail.com. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are
* permitted provided that the following conditions are met:
*
*    1. Redistributions of source code must retain the above copyright notice, this list of
*       conditions and the following disclaimer.
*
*    2. Redistributions in binary form must reproduce the above copyright notice, this list
*       of conditions and the following disclaimer in the documentation and/or other materials
*       provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
* FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
* CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* The views and conclusions contained in the software and documentation are those of the
* authors and should not be interpreted as representing official policies, either expressed
* or implied, of BetaSteward_at_googlemail.com.
 */
package mage.deck;

import mage.cards.ExpansionSet;
import mage.cards.Sets;
import mage.cards.decks.Constructed;
import mage.constants.SetType;

/**
 *
 * LevelX2
 */
public class Legacy extends Constructed {

    public Legacy() {
        super("Constructed - Legacy");
        for (ExpansionSet set : Sets.getInstance().values()) {
            if (set.getSetType() != SetType.CUSTOM_SET) {
                setCodes.add(set.getCode());
            }
        }
        banned.add("Advantageous Proclamation");
        banned.add("Amulet of Quoz");
        banned.add("Ancestral Recall");
        banned.add("Backup Plan");
        banned.add("Balance");
        banned.add("Bazaar of Baghdad");
        banned.add("Black Lotus");
        banned.add("Brago's Favor");
        banned.add("Bronze Tablet");
        banned.add("Channel");
        banned.add("Chaos Orb");
        banned.add("Contract from Below");
        banned.add("Darkpact");
        banned.add("Demonic Attorney");
        banned.add("Demonic Consultation");
        banned.add("Demonic Tutor");
        banned.add("Dig Through Time");
        banned.add("Double Stroke");
        banned.add("Earthcraft");
        banned.add("Falling Star");
        banned.add("Fastbond");
        banned.add("Flash");
        banned.add("Frantic Search");
        banned.add("Goblin Recruiter");
        banned.add("Gush");
        banned.add("Hermit Druid");
        banned.add("Immediate Action");
        banned.add("Imperial Seal");
        banned.add("Iterative Analysis");
        banned.add("Jeweled Bird");
        banned.add("Library of Alexandria");
        banned.add("Mana Crypt");
        banned.add("Mana Drain");
        banned.add("Mana Vault");
        banned.add("Memory Jar");
        banned.add("Mental Misstep");
        banned.add("Mind Twist");
        banned.add("Mind's Desire");
        banned.add("Mishra's Workshop");
        banned.add("Mox Emerald");
        banned.add("Mox Jet");
        banned.add("Mox Pearl");
        banned.add("Mox Ruby");
        banned.add("Mox Sapphire");
        banned.add("Muzzio's Preparations");
        banned.add("Mystical Tutor");
        banned.add("Necropotence");
        banned.add("Oath of Druids");
        banned.add("Power Play");
        banned.add("Rebirth");
        banned.add("Secret Summoning");
        banned.add("Secrets of Paradise");
        banned.add("Sensei's Divining Top");
        banned.add("Sentinel Dispatch");
        banned.add("Shahrazad");
        banned.add("Skullclamp");
        banned.add("Sol Ring");
        banned.add("Strip Mine");
        banned.add("Survival of the Fittest");
        banned.add("Tempest Efreet");
        banned.add("Time Vault");
        banned.add("Time Walk");
        banned.add("Timetwister");
        banned.add("Timmerian Fiends");
        banned.add("Tinker");
        banned.add("Tolarian Academy");
        banned.add("Treasure Cruise");
        banned.add("Unexpected Potential");
        banned.add("Vampiric Tutor");
        banned.add("Wheel of Fortune");
        banned.add("Windfall");
        banned.add("Worldknit");
        banned.add("Yawgmoth's Bargain");
        banned.add("Yawgmoth's Will");

    }
}
