/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 *
 * @author fireshoes
 */
public class GuillaumeMatignonsJennysJohnnysCube extends DraftCube {

public GuillaumeMatignonsJennysJohnnysCube() {
        super("Guillaume Matignon's Jenny's/Johnny's Cube"); // http://magic.wizards.com/en/MTGO/articles/archive/magic-online/you-make-cube-voting-2016-10-17

        cubeCards.add(new DraftCube.CardIdentity("Abundant Growth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Academy Rector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Academy Ruins", ""));
        cubeCards.add(new DraftCube.CardIdentity("Acidic Slime", ""));
        cubeCards.add(new DraftCube.CardIdentity("Adaptive Automaton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Adarkar Wastes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aether Adept", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani Goldmane", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani's Chosen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani's Pridemate", ""));
        cubeCards.add(new DraftCube.CardIdentity("All Is Dust", ""));
        cubeCards.add(new DraftCube.CardIdentity("Always Watching", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ambassador Laquatus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancestor's Prophet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Angel of Glory's Rise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Angelic Destiny", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anguished Unmaking", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aphetto Grifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arbor Elf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arcanis the Omnipotent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Archangel of Thune", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arid Mesa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Armadillo Cloak", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ashiok, Nightmare Weaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Assemble the Legion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Atarka's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Attunement", ""));
        cubeCards.add(new DraftCube.CardIdentity("Augur of Bolas", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aura Gnarlid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Auriok Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Austere Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avatar of Woe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ayli, Eternal Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azami, Lady of Scrolls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bad River", ""));
        cubeCards.add(new DraftCube.CardIdentity("Badlands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Battlefield Forge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bayou", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bedlam Reveler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Beetleback Chief", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blasting Station", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blind Obedience", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Artist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Crypt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Scrivener", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodghast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodline Shaman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodstained Mire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boon Satyr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bosh, Iron Golem", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brain Maggot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Braingeyser", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brainstorm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Breeding Pool", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brion Stoutarm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brushland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burning Vengeance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burst Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bygone Bishop", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cabal Interrogator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Call to the Grave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carnophage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carrion Feeder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cavern of Souls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Caves of Koilos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Ancient", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Archon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cemetery Reaper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Centaur Vinecrasher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chainer's Edict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Champion of the Parish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Flamecaller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Circular Logic", ""));
        cubeCards.add(new DraftCube.CardIdentity("City of Brass", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cliffhaven Vampire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Clifftop Retreat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coiling Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coldsteel Heart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collected Company", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collective Brutality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collective Defiance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Commune with the Gods", ""));
        cubeCards.add(new DraftCube.CardIdentity("Complicate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Compulsion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Compulsive Research", ""));
        cubeCards.add(new DraftCube.CardIdentity("Condescend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Courser of Kruphix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cradle of Vitality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crippling Fatigue", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crucible of Worlds", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cryptbreaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curious Homunculus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Predation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dakra Mystic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daretti, Scrap Savant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Salvation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Darksteel Mutation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daxos's Torment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dead Weight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deathrite Shaman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Declaration in Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deep Analysis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Desperate Ravings", ""));
        cubeCards.add(new DraftCube.CardIdentity("Destructive Revelry", ""));
        cubeCards.add(new DraftCube.CardIdentity("Detention Sphere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Devil's Play", ""));
        cubeCards.add(new DraftCube.CardIdentity("Devout Chaplain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diabolic Servitude", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dictate of Erebos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diregraf Colossus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diregraf Ghoul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismember", ""));
        cubeCards.add(new DraftCube.CardIdentity("Distended Mindbender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Docent of Perfection", ""));
        cubeCards.add(new DraftCube.CardIdentity("Domri Rade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doom Blade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doomed Necromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doomwake Giant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Door of Destinies", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonlord Atarka", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dreadbore", ""));
        cubeCards.add(new DraftCube.CardIdentity("Drogskol Reaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dromoka's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duplicant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dwynen, Gilt-Leaf Daen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Edge of Autumn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Edric, Spymaster of Trest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eidolon of Blossoms", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eidolon of Countless Battles", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elder Deep-Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Electrolyze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elixir of Immortality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elspeth Tirel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elvish Vanguard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elvish Visionary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ember Hauler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Emrakul, the Promised End", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enchantress's Presence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enclave Cryptologist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Engineered Explosives", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enlightened Tutor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomber Exarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Essence Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ethereal Armor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Everflowing Chalice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evolutionary Leap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Exploration", ""));
        cubeCards.add(new DraftCube.CardIdentity("Extinguish All Hope", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ezuri, Renegade Leader", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faith's Fetters", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faithless Looting", ""));
        cubeCards.add(new DraftCube.CardIdentity("Falkenrath Aristocrat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fatestitcher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fauna Shaman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feldon of the Third Path", ""));
        cubeCards.add(new DraftCube.CardIdentity("Felidar Umbra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fertile Ground", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fiend Hunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fiery Confluence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire // Ice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firebolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flame Jab", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flash of Insight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fleshbag Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flood Plain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flooded Strand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flux", ""));
        cubeCards.add(new DraftCube.CardIdentity("Foundry Street Denizen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frantic Search", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frenzied Goblin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Freyalise, Llanowar's Fury", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fyndhorn Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gamble", ""));
        cubeCards.add(new DraftCube.CardIdentity("Garruk Wildspeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gauntlet of Might", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gavony Township", ""));
        cubeCards.add(new DraftCube.CardIdentity("Geier Reach Sanitarium", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gelectrode", ""));
        cubeCards.add(new DraftCube.CardIdentity("Genesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Geralf's Masterpiece", ""));
        cubeCards.add(new DraftCube.CardIdentity("Geth, Lord of the Vault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gisa and Geralf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gitaxian Probe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Glare of Subdual", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gloomdrifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnarlwood Dryad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnaw to the Bone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnawing Zombie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Bombardment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Bushwhacker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Chieftain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Dark-Dwellers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Diplomats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Matron", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Rabblemaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Sharpshooter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Wardriver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Welder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Godless Shrine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Golgari Grave-Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grafted Wargear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grand Architect", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grand Coliseum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grapple with the Past", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grasslands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gravecrawler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gray Merchant of Asphodel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Greater Gargadon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Green Sun's Zenith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grenzo, Dungeon Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Flayer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Guardian", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Lavamancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grisly Salvage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grove of the Burnwillows", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gurmag Angler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Guttersnipe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hallowed Fountain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hammer of Purphoros", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hangarback Walker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harbinger of the Tides", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harm's Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Haunted Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Havengul Lich", ""));
        cubeCards.add(new DraftCube.CardIdentity("Healer of the Pride", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hedron Archive", ""));
        cubeCards.add(new DraftCube.CardIdentity("Heliod's Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Heliod, God of the Sun", ""));
        cubeCards.add(new DraftCube.CardIdentity("Herald of the Pantheon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hero's Downfall", ""));
        cubeCards.add(new DraftCube.CardIdentity("High Market", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hinterland Harbor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hopeful Eidolon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hordeling Outburst", ""));
        cubeCards.add(new DraftCube.CardIdentity("Idyllic Tutor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Immaculate Magistrate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Imperious Perfect", ""));
        cubeCards.add(new DraftCube.CardIdentity("Imprisoned in the Moon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inexorable Blob", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inquisition of Kozilek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Intuition", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ishkanah, Grafwidow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Isolated Chapel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jace, Vryn's Prodigy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Ascendancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jokulhaups", ""));
        cubeCards.add(new DraftCube.CardIdentity("Joraga Treespeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Karlov of the Ghost Council", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kessig Wolf Run", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kiora, the Crashing Wave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Knight of the Reliquary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kolaghan's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kor Sanctifiers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kor Spiritdancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek's Return", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek, Butcher of Truth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krenko's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krenko, Mob Boss", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kytheon, Hero of Akros", ""));
        cubeCards.add(new DraftCube.CardIdentity("Laboratory Maniac", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lava Dart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Legacy's Allure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leonin Relic-Warder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Life from the Loam", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Greaves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Helix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Surge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lignify", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, Heretical Healer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, the Last Hope", ""));
        cubeCards.add(new DraftCube.CardIdentity("Llanowar Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Llanowar Wastes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lone Rider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maelstrom Nexus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maelstrom Pulse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magma Jet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magmatic Force", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magmatic Insight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Manic Vandal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Woe-Reaper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Marsh Flats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Martyr of Sands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master Apothecary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master of Waves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maze of Ith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Memory Lapse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mesa Enchantress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mikaeus, the Lunarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mind Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mindslaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mindwrack Demon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirror Entity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Miscalculation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Misty Rainforest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mizzium Mortars", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogg Fanatic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogg War Marshal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moggcatcher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moldervine Cloak", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moment's Peace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mortarpod", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mother of Runes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mountain Valley", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mox Diamond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mulldrifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Cut", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mutavault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nahiri, the Harbinger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nameless Inversion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nantuko Husk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nearheath Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necromancer's Stockpile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necromancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Negate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nephalia Drownyard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nighthowler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nissa, Vastwood Seer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noose Constrictor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Norin the Wary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nullmage Shepherd", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx-Fleece Ram", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obelisk of Urd", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obliterate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ojutai's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ongoing Investigation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oona's Grace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opalescence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Open the Vaults", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oracle of Mul Daya", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oracle of Nectars", ""));
        cubeCards.add(new DraftCube.CardIdentity("Outpost Siege", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overgrown Tomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Palace Siege", ""));
        cubeCards.add(new DraftCube.CardIdentity("Parallax Wave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Path of Bravery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Path to Exile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Patriarch's Bidding", ""));
        cubeCards.add(new DraftCube.CardIdentity("Patron Wizard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pentavus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Metamorph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pia and Kiran Nalaar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pilgrim's Eye", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pillage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pious Evangel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plateau", ""));
        cubeCards.add(new DraftCube.CardIdentity("Polluted Delta", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ponder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Porphyry Nodes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Portent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Priest of Titania", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prismatic Lens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pristine Talisman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prized Amalgam", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophetic Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophetic Prism", ""));
        cubeCards.add(new DraftCube.CardIdentity("Psychic Spiral", ""));
        cubeCards.add(new DraftCube.CardIdentity("Punishing Fire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Purphoros, God of the Forge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Quiet Speculation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rancor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ranger of Eos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Raven's Crime", ""));
        cubeCards.add(new DraftCube.CardIdentity("Read the Bones", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reassembling Skeleton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reclamation Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Recoup", ""));
        cubeCards.add(new DraftCube.CardIdentity("Regal Force", ""));
        cubeCards.add(new DraftCube.CardIdentity("Relentless Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Repeal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Replenish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reveillark", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riptide Laboratory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rise from the Tides", ""));
        cubeCards.add(new DraftCube.CardIdentity("River Kelpie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rocky Tar Pit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rotlung Reanimator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Runechanter's Pike", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sacred Foundry", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sage of Fables", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sage's Dousing", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sanguine Bond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sarcomancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Satyr Wayfinder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savannah", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scalding Tarn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scavenging Ooze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrap Mastery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrubland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sea Gate Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seal of Cleansing", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seal of Fire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seal of Primordium", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Meditation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Secrets of the Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seismic Assault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sensei's Divining Top", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serene Steward", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serra Ascendant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serra's Sanctum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serrated Arrows", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serum Visions", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sever the Bloodline", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sewer Nemesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shaman of the Pack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shepherd of Rot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shivan Reef", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shriekmaw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Siege-Gang Commander", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sigil of the Empty Throne", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silent Departure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silhana Ledgewalker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sinister Concoction", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skinrender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skirsdag High Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skywise Teachings", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smokestack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snapcaster Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soldier of the Pantheon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Solemn Simulacrum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Song of the Dryads", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sorin Markov", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soul Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soulmender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sower of Temptation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sparksmith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphinx's Revelation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphinx's Tutelage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spikeshot Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spine of Ish Sah", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spiteful Returned", ""));
        cubeCards.add(new DraftCube.CardIdentity("Splinterfright", ""));
        cubeCards.add(new DraftCube.CardIdentity("Staff of Nin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Starfield of Nyx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Starstorm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stasis Snare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steam Vents", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steel Hellkite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stitcher Geralf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stomping Ground", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormbind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stromkirk Noble", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stronghold Assassin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sulfur Falls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sulfurous Springs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sunlance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sword of Light and Shadow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sword of War and Peace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvan Library", ""));
        cubeCards.add(new DraftCube.CardIdentity("Syndic of Tithes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Taiga", ""));
        cubeCards.add(new DraftCube.CardIdentity("Talrand, Sky Summoner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tarfire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tarmogoyf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Taurean Mauler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Teferi, Temporal Archmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple Garden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temporal Isolation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Terminate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tezzeret the Seeker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thalia's Lieutenant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thermo-Alchemist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thing in the Ice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Think Twice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thopter Spy Network", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thought Courier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thought Scour", ""));
        cubeCards.add(new DraftCube.CardIdentity("Time Warp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tireless Tracker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Titania, Protector of Argoth", ""));
        cubeCards.add(new DraftCube.CardIdentity("To the Slaughter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tormenting Voice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tracker's Instincts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trade Routes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trading Post", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tranquil Thicket", ""));
        cubeCards.add(new DraftCube.CardIdentity("Traverse the Ulvenwald", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tropical Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tundra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Twisted Abomination", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulamog, the Infinite Gyre", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulvenwald Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undead Alchemist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undercity Informer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Underground River", ""));
        cubeCards.add(new DraftCube.CardIdentity("Underground Sea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Underworld Coinsmith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unstable Obelisk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Utopia Sprawl", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vapor Snag", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vendilion Clique", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vengevine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Venser, Shaper Savant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Verdant Catacombs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vessel of Nascency", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vindicate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Violent Eruption", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viridian Zealot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voidmage Prodigy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volcanic Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volrath's Stronghold", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Limbs", ""));
        cubeCards.add(new DraftCube.CardIdentity("War Priest of Thune", ""));
        cubeCards.add(new DraftCube.CardIdentity("Warren Instigator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wasteland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Watery Grave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wayfarer's Bauble", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weathered Wayfarer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weaver of Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Well of Lost Dreams", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wellwisher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Werebear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Westvale Abbey", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whip of Erebos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wickerbough Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wild Research", ""));
        cubeCards.add(new DraftCube.CardIdentity("Winds of Rath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Windswept Heath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wirewood Symbiote", ""));
        cubeCards.add(new DraftCube.CardIdentity("Withered Wretch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wood Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wood Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wooded Foothills", ""));
        cubeCards.add(new DraftCube.CardIdentity("Woodland Cemetery", ""));
        cubeCards.add(new DraftCube.CardIdentity("World Breaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Worm Harvest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Worn Powerstone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wort, Boggart Auntie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya Coast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya Enchantress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Young Pyromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zealous Conscripts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zur the Enchanter", ""));
    }
}
