/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 *
 * @author fireshoes
 */
public class JosephVasolisPeasantCube extends DraftCube {

public JosephVasolisPeasantCube() {
        super("Jospeh Vasoli's Peasant Cube"); // http://magic.wizards.com/en/MTGO/articles/archive/magic-online/you-make-cube-voting-2016-10-17

        cubeCards.add(new DraftCube.CardIdentity("Abzan Beastmaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Abzan Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Accorder Paladin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Acidic Slime", ""));
        cubeCards.add(new DraftCube.CardIdentity("Acolyte of the Inferno", ""));
        cubeCards.add(new DraftCube.CardIdentity("Adventuring Gear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aether Adept", ""));
        cubeCards.add(new DraftCube.CardIdentity("Akoum Refuge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ambush Viper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ana Battlemage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ancient Ziggurat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Anticipate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arachnogenesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arbor Elf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arc Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arc Trail", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arcane Sanctum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Archetype of Courage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arrest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Artisan of Kozilek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Augur of Bolas", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avacyn's Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avalanche Riders", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Chancery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Signet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azure Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Baleful Strix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Baloth Null", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bane of Bala Ged", ""));
        cubeCards.add(new DraftCube.CardIdentity("Banisher Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Banishing Light", ""));
        cubeCards.add(new DraftCube.CardIdentity("Barter in Blood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Basilica Screecher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Battle Screech", ""));
        cubeCards.add(new DraftCube.CardIdentity("Beetleback Chief", ""));
        cubeCards.add(new DraftCube.CardIdentity("Behemoth Sledge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bestial Menace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bituminous Blast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blastoderm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blind with Anger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blinding Beam", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Artist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodbraid Elf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodfray Giant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodthrone Vampire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boggart Ram-Gang", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bone Shredder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bonesplitter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Borderland Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Borderland Ranger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boros Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boros Guildgate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Branching Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Briarhorn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Briarpack Alpha", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brimstone Volley", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brood Monitor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burning-Tree Emissary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burst Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Butcher Ghoul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Calciderm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Calcite Snapper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carnophage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carrier Thrall", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carrion Feeder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Catacomb Sifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Crusader", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cenn's Tactician", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chain Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chainer's Edict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chittering Rats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chronomaton", ""));
        cubeCards.add(new DraftCube.CardIdentity("City of Brass", ""));
        cubeCards.add(new DraftCube.CardIdentity("Civic Wayfinder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Claustrophobia", ""));
        cubeCards.add(new DraftCube.CardIdentity("Clear Shot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cloistered Youth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Clone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cloudgoat Ranger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coalition Honor Guard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coiling Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coldsteel Heart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Complicate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Compulsive Research", ""));
        cubeCards.add(new DraftCube.CardIdentity("Conclave Naturalists", ""));
        cubeCards.add(new DraftCube.CardIdentity("Condescend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Consul's Lieutenant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Control Magic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Corpse Augur", ""));
        cubeCards.add(new DraftCube.CardIdentity("Counterspell", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crossway Vampire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crumbling Necropolis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crystal Shard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cudgel Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cultivate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Chains", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Predation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Shallow Graves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daring Skyjek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Hatchling", ""));
        cubeCards.add(new DraftCube.CardIdentity("Darksteel Sentinel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deadly Recluse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deadwood Treefolk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Death Frenzy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diabolic Edict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diabolic Servitude", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dimir Aqueduct", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dimir Signet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Diregraf Ghoul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Disfigure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismember", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismiss", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doom Blade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doomed Traveler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragon Hunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Drana's Emissary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dreg Mangler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Driver of the Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dromoka Warrior", ""));
        cubeCards.add(new DraftCube.CardIdentity("Drown in Sorrow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dryad Militant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duskwatch Recruiter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eldrazi Skyspawner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Electrolyze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elite Vanguard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elixir of Immortality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elusive Spellfist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elves of Deep Shadow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elvish Mystic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elvish Visionary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ember Hauler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Embodiment of Fury", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enclave Cryptologist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enlisted Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enslave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomber Exarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Epic Confrontation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Epochrasite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Errant Ephemeron", ""));
        cubeCards.add(new DraftCube.CardIdentity("Esper Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Essence Scatter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eternal Witness", ""));
        cubeCards.add(new DraftCube.CardIdentity("Everflowing Chalice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evolving Wilds", ""));
        cubeCards.add(new DraftCube.CardIdentity("Exclude", ""));
        cubeCards.add(new DraftCube.CardIdentity("Expedition Envoy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Explore", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fact or Fiction", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faith's Fetters", ""));
        cubeCards.add(new DraftCube.CardIdentity("Falkenrath Noble", ""));
        cubeCards.add(new DraftCube.CardIdentity("False Summoning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fanatic of Xenagos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Farseek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fencer Clique", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fervent Cathar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feudkiller's Verdict", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fiend Hunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire Covenant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire Imp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fireblast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firebolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firefist Striker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Firemaw Kavu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flame Slash", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flames of the Firebrand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flametongue Kavu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flaying Tendrils", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fleshbag Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flickerwisp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Force Spike", ""));
        cubeCards.add(new DraftCube.CardIdentity("Forked Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Foundry Street Denizen", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frenzied Goblin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frontier Bivouac", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frost Lynx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fyndhorn Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Galvanic Juggernaut", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gemstone Mine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Genju of the Spires", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghor-Clan Rampager", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gideon's Lawkeeper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnarled Scarhide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gnawing Zombie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Go for the Throat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Glory Chaser", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Heelcutter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Shortcutter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goldmeadow Harrier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goldnight Commander", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gore-House Chainwalker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grafted Wargear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grasp of Fate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gravedigger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gray Merchant of Asphodel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Graypelt Refuge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Great Oak Guardian", ""));
        cubeCards.add(new DraftCube.CardIdentity("Griffin Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grizzly Fate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gryff Vanguard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Guardian of the Guildpact", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gurmag Angler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Guttersnipe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Halimar Wavewatch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harm's Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harmonize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Harrow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Havoc Demon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hedron Archive", ""));
        cubeCards.add(new DraftCube.CardIdentity("Herald of the Host", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hermit of the Natterknolls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hit // Run", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hordeling Outburst", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hymn to Tourach", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hypnotic Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Icy Manipulator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incendiary Flow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incinerate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incremental Blight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Inquisition of Kozilek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Intimidator Initiate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Into the Roil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Boilerworks", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Signet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jackal Pup", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jade Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jeskai Windscout", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jetting Glasskite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jhessian Thief", ""));
        cubeCards.add(new DraftCube.CardIdentity("Joraga Treespeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Journey to Nowhere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Juggernaut", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jungle Hollow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jungle Shrine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jwar Isle Refuge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kazandu Refuge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Keldon Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kiln Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kitchen Finks", ""));
        cubeCards.add(new DraftCube.CardIdentity("Knight of Glory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kodama's Reach", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kor Castigator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kor Hookmaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek's Predator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krosan Tusker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krosan Verge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lashknife Barrier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leafcrown Dryad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Greaves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Helix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Strike", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana's Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lingering Souls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Llanowar Elves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Looter il-Kor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Loxodon Warhammer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lu Xun, Scholar General", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lust for War", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magma Jet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Makindi Sliderunner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Man-o'-War", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Leak", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Tithe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Roughrider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Scout", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Skullhunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mardu Woe-Reaper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Marsh Flitter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master of Diversion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maze of Ith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Meadowboon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Memory Lapse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Merciless Executioner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mercurial Geists", ""));
        cubeCards.add(new DraftCube.CardIdentity("Merfolk Looter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Midnight Haunting", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mind Control", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mind Stone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirrodin's Core", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mirror Match", ""));
        cubeCards.add(new DraftCube.CardIdentity("Miscalculation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mishra's Factory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mist Raven", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mistral Charger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Moan of the Unhallowed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogis's Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monastery Swiftspear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mortarpod", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mother of Runes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mulldrifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murder of Crows", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Cut", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Redcap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mwonvuli Beast Tracker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mystic Monastery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nantuko Husk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Narcolepsy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nearheath Chaplain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nekrataal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nessian Asp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nessian Game Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nest Invader", ""));
        cubeCards.add(new DraftCube.CardIdentity("Niblis of Dusk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nimbus Naiad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ninja of the Deep Hours", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nomad Outpost", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nylea's Disciple", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx Weaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Omenspeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opulent Palace", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oreskos Explorer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ornitharch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overrun", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pacifism", ""));
        cubeCards.add(new DraftCube.CardIdentity("Path to Exile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pelakka Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Penumbra Spider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Penumbra Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Perilous Myr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Persuasion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pestermite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phantom Centaur", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Gargantua", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Ghoul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Ingester", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Rager", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pianna, Nomad Captain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pierce Strider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pilgrim's Eye", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pious Evangel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pit Fight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plagued Rusalka", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plated Crusher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plated Geopede", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ponder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Porcelain Legionnaire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Possessed Skaab", ""));
        cubeCards.add(new DraftCube.CardIdentity("Preordain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prey Upon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prismatic Lens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pristine Talisman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Psionic Blast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Psychatog", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pulse Tracker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pyroclasm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pyrotechnics", ""));
        cubeCards.add(new DraftCube.CardIdentity("Qarsi High Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Qasali Pridemage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Quarry Colossus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rabid Bite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Radiant, Archangel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos Cackler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakshasa Gravecaller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rampant Growth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ranger's Guile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ravaging Blaze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ravenous Rats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ray of Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Read the Bones", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reassembling Skeleton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reckless Waif", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reclamation Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reflector Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Regrowth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Relief Captain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Remand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Remove Soul", ""));
        cubeCards.add(new DraftCube.CardIdentity("Repulse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rhox War Monk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ribbons of Night", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riftwing Cloudskate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rise // Fall", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rise from the Tides", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rite of the Raging Storm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Roar of the Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Roast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Roil Spout", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rolling Thunder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rubblebelt Maaka", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rugged Highlands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rupture Spire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sadistic Hypnotist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sakura-Tribe Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sandsteppe Citadel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sarcomancy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Alliance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Lands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Punch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savage Twister", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savannah Lions", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scoured Barrens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sea Gate Oracle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Search for Tomorrow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Blaze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Blood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Spear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seaside Citadel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seed Guardian", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seeker of the Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seismic Elemental", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sejiri Refuge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sengir Autocrat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sentinel Spider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sentinel of the Eternal Watch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seraph of Dawn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serendib Efreet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serra Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serrated Arrows", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serum Visions", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shardless Agent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shimmering Glasskite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shower of Coals", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shriekmaw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shrine of Burning Rage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shrine of Loyal Legions", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sigiled Starfish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Signal Pest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Simic Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Simic Growth Chamber", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sin Collector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skinrender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skymark Roc", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skysnare Spider", ""));
        cubeCards.add(new DraftCube.CardIdentity("Slice and Dice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soltari Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soltari Trooper", ""));
        cubeCards.add(new DraftCube.CardIdentity("Somberwald Stag", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spectral Procession", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spell Pierce", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphere of the Suns", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spined Thopter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spitemare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stab Wound", ""));
        cubeCards.add(new DraftCube.CardIdentity("Staggershock", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stalking Stones", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stasis Snare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steppe Lynx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stitched Mangler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stoke the Flames", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stonewright", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormblood Berserker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stormfront Pegasus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Su-Chi", ""));
        cubeCards.add(new DraftCube.CardIdentity("Subterranean Scout", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sulfurous Blast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sultai Emissary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sunhome Guildmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Swift Warkite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Swiftwater Cliffs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Swords to Plowshares", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvan Library", ""));
        cubeCards.add(new DraftCube.CardIdentity("Symbiotic Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tainted Field", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tainted Peak", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tainted Wood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Talrand's Invocation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tattermunge Maniac", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temporal Isolation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temur Charm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temur Sabertooth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Terramorphic Expanse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thassa's Emissary", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thermo-Alchemist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thieving Magpie", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thirst for Knowledge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thornscape Battlemage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thornweald Archer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thornwood Falls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thought Courier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thraben Inspector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thrill-Kill Assassin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tidehollow Sculler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Timely Hordemate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Topan Freeblade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tormented Hero", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tower Geist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Transguild Promenade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treasure Cruise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treetop Village", ""));
        cubeCards.add(new DraftCube.CardIdentity("Triplicate Spirits", ""));
        cubeCards.add(new DraftCube.CardIdentity("Triumph of Ferocity", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trostani's Summoner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trusty Machete", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trygon Predator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulamog's Crusher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ultimate Price", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unburial Rites", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undercity Informer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undercity Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undo", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undying Evil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unearth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Urza's Factory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Valley Dasher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampire Aristocrat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampire Lacerator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampire Nighthawk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampiric Rites", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viashino Firstblade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Victimize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Village Messenger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vines of Vastwood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vivid Crag", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vivid Creek", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vivid Grove", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vivid Marsh", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vivid Meadow", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voice of All", ""));
        cubeCards.add(new DraftCube.CardIdentity("Void Grafter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voldaren Duelist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vulturous Aven", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wakestone Gargoyle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Blossoms", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Omens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Roots", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wandering Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("War-Name Aspirant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wash Out", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weaver of Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wee Dragonauts", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whirler Rogue", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wickerbough Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wight of Precinct Six", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wind-Scarred Crag", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wing Shards", ""));
        cubeCards.add(new DraftCube.CardIdentity("Withdraw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wolfir Avenger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wrench Mind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Xiahou Dun, the One-Eyed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Young Pyromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zealous Persecution", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zulaport Cutthroat", ""));
    }
}
