/*
* Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
*
* Redistribution and use in source and binary forms, with or without modification, are
* permitted provided that the following conditions are met:
*
*    1. Redistributions of source code must retain the above copyright notice, this list of
*       conditions and the following disclaimer.
*
*    2. Redistributions in binary form must reproduce the above copyright notice, this list
*       of conditions and the following disclaimer in the documentation and/or other materials
*       provided with the distribution.
*
* THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
* WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
* FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
* CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
* SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
* ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
* ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*
* The views and conclusions contained in the software and documentation are those of the
* authors and should not be interpreted as representing official policies, either expressed
* or implied, of BetaSteward_at_googlemail.com.
*/

package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 * Cube taken from
 * http://www.mtgsalvation.com/articles/29806-close-to-the-edge-mono-blue-cube-overview
 * 
 * @author LevelX2
 */
public class MonoBlueCube extends DraftCube {

    public MonoBlueCube() {
        super("Mono Blue Cube");
        cubeCards.add(new CardIdentity("Academy Ruins",""));
        cubeCards.add(new CardIdentity("Adaptive Automaton",""));
        cubeCards.add(new CardIdentity("Aeolipile",""));
        cubeCards.add(new CardIdentity("Aeon Chronicler",""));
        cubeCards.add(new CardIdentity("Aether Spellbomb",""));
        cubeCards.add(new CardIdentity("Aether Vial",""));
        cubeCards.add(new CardIdentity("Aetherling",""));
        cubeCards.add(new CardIdentity("All Is Dust",""));
        cubeCards.add(new CardIdentity("Ambassador Laquatus",""));
        cubeCards.add(new CardIdentity("Amnesia",""));
        cubeCards.add(new CardIdentity("Ancestral Recall",""));
        cubeCards.add(new CardIdentity("Ancestral Vision",""));
        cubeCards.add(new CardIdentity("Ancient Tomb",""));
        cubeCards.add(new CardIdentity("Ankh of Mishra",""));
        cubeCards.add(new CardIdentity("Annul",""));
        cubeCards.add(new CardIdentity("Arcanis the Omnipotent",""));
        cubeCards.add(new CardIdentity("Archaeomancer",""));
        cubeCards.add(new CardIdentity("Archive Trap",""));
        cubeCards.add(new CardIdentity("Augur of Bolas",""));
        cubeCards.add(new CardIdentity("Basalt Monolith",""));
        cubeCards.add(new CardIdentity("Bident of Thassa",""));
        cubeCards.add(new CardIdentity("Black Lotus",""));
        cubeCards.add(new CardIdentity("Black Vise",""));
        cubeCards.add(new CardIdentity("Blightsteel Colossus",""));
        cubeCards.add(new CardIdentity("Blinkmoth Nexus",""));
        cubeCards.add(new CardIdentity("Blue Sun's Zenith",""));
        cubeCards.add(new CardIdentity("Bonesplitter",""));
        cubeCards.add(new CardIdentity("Boomerang",""));
        cubeCards.add(new CardIdentity("Braids, Conjurer Adept",""));
        cubeCards.add(new CardIdentity("Brain Freeze",""));
        cubeCards.add(new CardIdentity("Braingeyser",""));
        cubeCards.add(new CardIdentity("Brainstorm",""));
        cubeCards.add(new CardIdentity("Briarberry Cohort",""));
        cubeCards.add(new CardIdentity("Brittle Effigy",""));
        cubeCards.add(new CardIdentity("Broken Ambitions",""));
        cubeCards.add(new CardIdentity("Buried Ruin",""));
        cubeCards.add(new CardIdentity("Caged Sun",""));
        cubeCards.add(new CardIdentity("Call to Mind",""));
        cubeCards.add(new CardIdentity("Candelabra of Tawnos",""));
        cubeCards.add(new CardIdentity("Capsize",""));
        cubeCards.add(new CardIdentity("Careful Consideration",""));
        cubeCards.add(new CardIdentity("Cavern of Souls",""));
        cubeCards.add(new CardIdentity("Chalice of the Void",""));
        cubeCards.add(new CardIdentity("Chancellor of the Spires",""));
        cubeCards.add(new CardIdentity("Chronomaton",""));
        cubeCards.add(new CardIdentity("Claustrophobia",""));
        cubeCards.add(new CardIdentity("Cloud of Faeries",""));
        cubeCards.add(new CardIdentity("Cloudfin Raptor",""));
        cubeCards.add(new CardIdentity("Coalition Relic",""));
        cubeCards.add(new CardIdentity("Coat of Arms",""));
        cubeCards.add(new CardIdentity("Codex Shredder",""));
        cubeCards.add(new CardIdentity("Cold-Eyed Selkie",""));
        cubeCards.add(new CardIdentity("Commandeer",""));
        cubeCards.add(new CardIdentity("Complicate",""));
        cubeCards.add(new CardIdentity("Compulsive Research",""));
        cubeCards.add(new CardIdentity("Condescend",""));
        cubeCards.add(new CardIdentity("Contested War Zone",""));
        cubeCards.add(new CardIdentity("Control Magic",""));
        cubeCards.add(new CardIdentity("Conundrum Sphinx",""));
        cubeCards.add(new CardIdentity("Copper Gnomes",""));
        cubeCards.add(new CardIdentity("Coralhelm Commander",""));
        cubeCards.add(new CardIdentity("Counterspell",""));
        cubeCards.add(new CardIdentity("Crippling Chill",""));
        cubeCards.add(new CardIdentity("Cryptic Command",""));
        cubeCards.add(new CardIdentity("Cursecatcher",""));
        cubeCards.add(new CardIdentity("Cyclonic Rift",""));
        cubeCards.add(new CardIdentity("Darksteel Colossus",""));
        cubeCards.add(new CardIdentity("Daze",""));
        cubeCards.add(new CardIdentity("Deep Analysis",""));
        cubeCards.add(new CardIdentity("Delay",""));
        cubeCards.add(new CardIdentity("Delver of Secrets",""));
        cubeCards.add(new CardIdentity("Deprive",""));
        cubeCards.add(new CardIdentity("Desert",""));
        cubeCards.add(new CardIdentity("Devastation Tide",""));
        cubeCards.add(new CardIdentity("Dewdrop Spy",""));
        cubeCards.add(new CardIdentity("Dismiss",""));
        cubeCards.add(new CardIdentity("Dispel",""));
        cubeCards.add(new CardIdentity("Disrupt",""));
        cubeCards.add(new CardIdentity("Dissipate",""));
        cubeCards.add(new CardIdentity("Dissolve",""));
        cubeCards.add(new CardIdentity("Dizzy Spell",""));
        cubeCards.add(new CardIdentity("Draining Whelk",""));
        cubeCards.add(new CardIdentity("Dream Twist",""));
        cubeCards.add(new CardIdentity("Drift of Phantasms",""));
        cubeCards.add(new CardIdentity("Drowner Initiate",""));
        cubeCards.add(new CardIdentity("Dungeon Geists",""));
        cubeCards.add(new CardIdentity("Duplicant",""));
        cubeCards.add(new CardIdentity("Elite Arcanist",""));
        cubeCards.add(new CardIdentity("Elixir of Immortality",""));
        cubeCards.add(new CardIdentity("Emrakul, the Aeons Torn",""));
        cubeCards.add(new CardIdentity("Enclave Cryptologist",""));
        cubeCards.add(new CardIdentity("Enter the Infinite",""));
        cubeCards.add(new CardIdentity("Errant Ephemeron",""));
        cubeCards.add(new CardIdentity("Ertai, Wizard Adept",""));
        cubeCards.add(new CardIdentity("Evacuation",""));
        cubeCards.add(new CardIdentity("Exclude",""));
        cubeCards.add(new CardIdentity("Extraplanar Lens",""));
        cubeCards.add(new CardIdentity("Eye of the Storm",""));
        cubeCards.add(new CardIdentity("Fabricate",""));
        cubeCards.add(new CardIdentity("Fact or Fiction",""));
        cubeCards.add(new CardIdentity("Faerie Conclave",""));
        cubeCards.add(new CardIdentity("Faerie Harbinger",""));
        cubeCards.add(new CardIdentity("Flash of Insight",""));
        cubeCards.add(new CardIdentity("Flusterstorm",""));
        cubeCards.add(new CardIdentity("Foil",""));
        cubeCards.add(new CardIdentity("Forbid",""));
        cubeCards.add(new CardIdentity("Force of Will",""));
        cubeCards.add(new CardIdentity("Force Spike",""));
        cubeCards.add(new CardIdentity("Frantic Search",""));
        cubeCards.add(new CardIdentity("Frost Titan",""));
        cubeCards.add(new CardIdentity("Gainsay",""));
        cubeCards.add(new CardIdentity("Geralf's Mindcrusher",""));
        cubeCards.add(new CardIdentity("Gilded Lotus",""));
        cubeCards.add(new CardIdentity("Gitaxian Probe",""));
        cubeCards.add(new CardIdentity("Glen Elendra Archmage",""));
        cubeCards.add(new CardIdentity("Gomazoa",""));
        cubeCards.add(new CardIdentity("Grafted Wargear",""));
        cubeCards.add(new CardIdentity("Grand Architect",""));
        cubeCards.add(new CardIdentity("Grim Monolith",""));
        cubeCards.add(new CardIdentity("Grindclock",""));
        cubeCards.add(new CardIdentity("Grindstone",""));
        cubeCards.add(new CardIdentity("Gush",""));
        cubeCards.add(new CardIdentity("Hammerhead Shark",""));
        cubeCards.add(new CardIdentity("Hedron Crab",""));
        cubeCards.add(new CardIdentity("High Tide",""));
        cubeCards.add(new CardIdentity("Horizon Drake",""));
        cubeCards.add(new CardIdentity("Howling Mine",""));
        cubeCards.add(new CardIdentity("Ideas Unbound",""));
        cubeCards.add(new CardIdentity("Illusionary Servant",""));
        cubeCards.add(new CardIdentity("Illusory Angel",""));
        cubeCards.add(new CardIdentity("Impulse",""));
        cubeCards.add(new CardIdentity("Increasing Confusion",""));
        cubeCards.add(new CardIdentity("Inkfathom Infiltrator",""));
        cubeCards.add(new CardIdentity("Inkmoth Nexus",""));
        cubeCards.add(new CardIdentity("Inkwell Leviathan",""));
        cubeCards.add(new CardIdentity("Inspired Sprite",""));
        cubeCards.add(new CardIdentity("Into the Roil",""));
        cubeCards.add(new CardIdentity("Isochron Scepter",""));
        cubeCards.add(new CardIdentity("Jace Beleren",""));
        cubeCards.add(new CardIdentity("Jace, Architect of Thought",""));
        cubeCards.add(new CardIdentity("Jace, Memory Adept",""));
        cubeCards.add(new CardIdentity("Jace, the Mind Sculptor",""));
        cubeCards.add(new CardIdentity("Jace's Archivist",""));
        cubeCards.add(new CardIdentity("Jushi Apprentice",""));
        cubeCards.add(new CardIdentity("Karn Liberated",""));
        cubeCards.add(new CardIdentity("Kederekt Leviathan",""));
        cubeCards.add(new CardIdentity("Keening Stone",""));
        cubeCards.add(new CardIdentity("Knowledge Pool",""));
        cubeCards.add(new CardIdentity("Kuldotha Forgemaster",""));
        cubeCards.add(new CardIdentity("Laboratory Maniac",""));
        cubeCards.add(new CardIdentity("Legerdemain",""));
        cubeCards.add(new CardIdentity("Leyline of Anticipation",""));
        cubeCards.add(new CardIdentity("Library of Alexandria",""));
        cubeCards.add(new CardIdentity("Lighthouse Chronologist",""));
        cubeCards.add(new CardIdentity("Llawan, Cephalid Empress",""));
        cubeCards.add(new CardIdentity("Logic Knot",""));
        cubeCards.add(new CardIdentity("Lonely Sandbar",""));
        cubeCards.add(new CardIdentity("Long-Term Plans",""));
        cubeCards.add(new CardIdentity("Looter il-Kor",""));
        cubeCards.add(new CardIdentity("Lord of Atlantis",""));
        cubeCards.add(new CardIdentity("Lotus Bloom",""));
        cubeCards.add(new CardIdentity("Lullmage Mentor",""));
        cubeCards.add(new CardIdentity("Mana Crypt",""));
        cubeCards.add(new CardIdentity("Mana Drain",""));
        cubeCards.add(new CardIdentity("Mana Leak",""));
        cubeCards.add(new CardIdentity("Mana Vault",""));
        cubeCards.add(new CardIdentity("Master of the Pearl Trident",""));
        cubeCards.add(new CardIdentity("Master of Waves",""));
        cubeCards.add(new CardIdentity("Master Thief",""));
        cubeCards.add(new CardIdentity("Master Transmuter",""));
        cubeCards.add(new CardIdentity("Maze of Ith",""));
        cubeCards.add(new CardIdentity("Meditate",""));
        cubeCards.add(new CardIdentity("Meishin, the Mind Cage",""));
        cubeCards.add(new CardIdentity("Meloku the Clouded Mirror",""));
        cubeCards.add(new CardIdentity("Memory Jar",""));
        cubeCards.add(new CardIdentity("Memory Sluice",""));
        cubeCards.add(new CardIdentity("Mental Misstep",""));
        cubeCards.add(new CardIdentity("Merchant Scroll",""));
        cubeCards.add(new CardIdentity("Merfolk Looter",""));
        cubeCards.add(new CardIdentity("Merfolk Mesmerist",""));
        cubeCards.add(new CardIdentity("Merfolk Sovereign",""));
        cubeCards.add(new CardIdentity("Merfolk Spy",""));
        cubeCards.add(new CardIdentity("Merrow Reejerey",""));
        cubeCards.add(new CardIdentity("Metalworker",""));
        cubeCards.add(new CardIdentity("Mind Over Matter",""));
        cubeCards.add(new CardIdentity("Mind Sculpt",""));
        cubeCards.add(new CardIdentity("Mind Stone",""));
        cubeCards.add(new CardIdentity("Mind's Desire",""));
        cubeCards.add(new CardIdentity("Mindslaver",""));
        cubeCards.add(new CardIdentity("Minister of Impediments",""));
        cubeCards.add(new CardIdentity("Miscalculation",""));
        cubeCards.add(new CardIdentity("Misdirection",""));
        cubeCards.add(new CardIdentity("Mishra's Factory",""));
        cubeCards.add(new CardIdentity("Mishra's Helix",""));
        cubeCards.add(new CardIdentity("Mishra's Workshop",""));
        cubeCards.add(new CardIdentity("Mortarpod",""));
        cubeCards.add(new CardIdentity("Mothdust Changeling",""));
        cubeCards.add(new CardIdentity("Mox Diamond",""));
        cubeCards.add(new CardIdentity("Mox Sapphire",""));
        cubeCards.add(new CardIdentity("Muddle the Mixture",""));
        cubeCards.add(new CardIdentity("Mulldrifter",""));
        cubeCards.add(new CardIdentity("Mutavault",""));
        cubeCards.add(new CardIdentity("Myr Battlesphere",""));
        cubeCards.add(new CardIdentity("Mystical Tutor",""));
        cubeCards.add(new CardIdentity("Negate",""));
        cubeCards.add(new CardIdentity("Nevinyrral's Disk",""));
        cubeCards.add(new CardIdentity("Nightveil Specter",""));
        cubeCards.add(new CardIdentity("Nimbus Naiad",""));
        cubeCards.add(new CardIdentity("Ninja of the Deep Hours",""));
        cubeCards.add(new CardIdentity("Oblivion Stone",""));
        cubeCards.add(new CardIdentity("Omniscience",""));
        cubeCards.add(new CardIdentity("Oona, Queen of the Fae",""));
        cubeCards.add(new CardIdentity("Opportunity",""));
        cubeCards.add(new CardIdentity("Overtaker",""));
        cubeCards.add(new CardIdentity("Pact of Negation",""));
        cubeCards.add(new CardIdentity("Painter's Servant",""));
        cubeCards.add(new CardIdentity("Palinchron",""));
        cubeCards.add(new CardIdentity("Patron Wizard",""));
        cubeCards.add(new CardIdentity("Peek",""));
        cubeCards.add(new CardIdentity("Peer Through Depths",""));
        cubeCards.add(new CardIdentity("Personal Tutor",""));
        cubeCards.add(new CardIdentity("Pestermite",""));
        cubeCards.add(new CardIdentity("Phantasmal Bear",""));
        cubeCards.add(new CardIdentity("Phantasmal Dragon",""));
        cubeCards.add(new CardIdentity("Phantasmal Image",""));
        cubeCards.add(new CardIdentity("Phyrexian Ingester",""));
        cubeCards.add(new CardIdentity("Phyrexian Metamorph",""));
        cubeCards.add(new CardIdentity("Piracy Charm",""));
        cubeCards.add(new CardIdentity("Platinum Angel",""));
        cubeCards.add(new CardIdentity("Plumeveil",""));
        cubeCards.add(new CardIdentity("Ponder",""));
        cubeCards.add(new CardIdentity("Pongify",""));
        cubeCards.add(new CardIdentity("Portent",""));
        cubeCards.add(new CardIdentity("Powder Keg",""));
        cubeCards.add(new CardIdentity("Power Artifact",""));
        cubeCards.add(new CardIdentity("Precursor Golem",""));
        cubeCards.add(new CardIdentity("Preordain",""));
        cubeCards.add(new CardIdentity("Prognostic Sphinx",""));
        cubeCards.add(new CardIdentity("Propaganda",""));
        cubeCards.add(new CardIdentity("Psionic Blast",""));
        cubeCards.add(new CardIdentity("Psychic Barrier",""));
        cubeCards.add(new CardIdentity("Puresight Merrow",""));
        cubeCards.add(new CardIdentity("Quicksand",""));
        cubeCards.add(new CardIdentity("Rapid Hybridization",""));
        cubeCards.add(new CardIdentity("Ratchet Bomb",""));
        cubeCards.add(new CardIdentity("Rath's Edge",""));
        cubeCards.add(new CardIdentity("Raven Guild Master",""));
        cubeCards.add(new CardIdentity("Ray of Command",""));
        cubeCards.add(new CardIdentity("Reconstruction",""));
        cubeCards.add(new CardIdentity("Reliquary Tower",""));
        cubeCards.add(new CardIdentity("Remand",""));
        cubeCards.add(new CardIdentity("Remote Isle",""));
        cubeCards.add(new CardIdentity("Repeal",""));
        cubeCards.add(new CardIdentity("Rewind",""));
        cubeCards.add(new CardIdentity("Riftwing Cloudskate",""));
        cubeCards.add(new CardIdentity("Riptide Director",""));
        cubeCards.add(new CardIdentity("Riptide Laboratory",""));
        cubeCards.add(new CardIdentity("Rishadan Port",""));
        cubeCards.add(new CardIdentity("Runechanter's Pike",""));
        cubeCards.add(new CardIdentity("Sage of Fables",""));
        cubeCards.add(new CardIdentity("Sand Squid",""));
        cubeCards.add(new CardIdentity("Sands of Delirium",""));
        cubeCards.add(new CardIdentity("Sapphire Medallion",""));
        cubeCards.add(new CardIdentity("Sea Drake",""));
        cubeCards.add(new CardIdentity("Sea Gate Oracle",""));
        cubeCards.add(new CardIdentity("Sea Scryer",""));
        cubeCards.add(new CardIdentity("Seasinger",""));
        cubeCards.add(new CardIdentity("Sensei's Divining Top",""));
        cubeCards.add(new CardIdentity("Sensory Deprivation",""));
        cubeCards.add(new CardIdentity("Serendib Efreet",""));
        cubeCards.add(new CardIdentity("Serum Visions",""));
        cubeCards.add(new CardIdentity("Shape Anew",""));
        cubeCards.add(new CardIdentity("Shapesharer",""));
        cubeCards.add(new CardIdentity("Shelldock Isle",""));
        cubeCards.add(new CardIdentity("Show and Tell",""));
        cubeCards.add(new CardIdentity("Signal Pest",""));
        cubeCards.add(new CardIdentity("Silvergill Adept",""));
        cubeCards.add(new CardIdentity("Skullclamp",""));
        cubeCards.add(new CardIdentity("Skywatcher Adept",""));
        cubeCards.add(new CardIdentity("Sleight of Hand",""));
        cubeCards.add(new CardIdentity("Smokestack",""));
        cubeCards.add(new CardIdentity("Snapcaster Mage",""));
        cubeCards.add(new CardIdentity("Sol Ring",""));
        cubeCards.add(new CardIdentity("Sower of Temptation",""));
        cubeCards.add(new CardIdentity("Spell Pierce",""));
        cubeCards.add(new CardIdentity("Spell Snare",""));
        cubeCards.add(new CardIdentity("Spellstutter Sprite",""));
        cubeCards.add(new CardIdentity("Spiketail Drakeling",""));
        cubeCards.add(new CardIdentity("Spire Golem",""));
        cubeCards.add(new CardIdentity("Sprite Noble",""));
        cubeCards.add(new CardIdentity("Standstill",""));
        cubeCards.add(new CardIdentity("Steel Hellkite",""));
        cubeCards.add(new CardIdentity("Steel Sabotage",""));
        cubeCards.add(new CardIdentity("Stern Mentor",""));
        cubeCards.add(new CardIdentity("Stonybrook Banneret",""));
        cubeCards.add(new CardIdentity("Strata Scythe",""));
        cubeCards.add(new CardIdentity("Strip Mine",""));
        cubeCards.add(new CardIdentity("Stroke of Genius",""));
        cubeCards.add(new CardIdentity("Swan Song",""));
        cubeCards.add(new CardIdentity("Sword of Body and Mind",""));
        cubeCards.add(new CardIdentity("Sword of Fire and Ice",""));
        cubeCards.add(new CardIdentity("Sygg, River Cutthroat",""));
        cubeCards.add(new CardIdentity("Take Possession",""));
        cubeCards.add(new CardIdentity("Talrand, Sky Summoner",""));
        cubeCards.add(new CardIdentity("Tangle Wire",""));
        cubeCards.add(new CardIdentity("Teferi, Mage of Zhalfir",""));
        cubeCards.add(new CardIdentity("Telling Time",""));
        cubeCards.add(new CardIdentity("Temporal Adept",""));
        cubeCards.add(new CardIdentity("Temporal Fissure",""));
        cubeCards.add(new CardIdentity("Thada Adel, Acquisitor",""));
        cubeCards.add(new CardIdentity("Thalakos Deceiver",""));
        cubeCards.add(new CardIdentity("Thassa, God of the Sea",""));
        cubeCards.add(new CardIdentity("The Tabernacle at Pendrell Vale",""));
        cubeCards.add(new CardIdentity("Think Twice",""));
        cubeCards.add(new CardIdentity("Thistledown Liege",""));
        cubeCards.add(new CardIdentity("Thought Scour",""));
        cubeCards.add(new CardIdentity("Thran Dynamo",""));
        cubeCards.add(new CardIdentity("Thwart",""));
        cubeCards.add(new CardIdentity("Time Spiral",""));
        cubeCards.add(new CardIdentity("Time Stretch",""));
        cubeCards.add(new CardIdentity("Time Vault",""));
        cubeCards.add(new CardIdentity("Time Walk",""));
        cubeCards.add(new CardIdentity("Timetwister",""));
        cubeCards.add(new CardIdentity("Tinker",""));
        cubeCards.add(new CardIdentity("Tolaria West",""));
        cubeCards.add(new CardIdentity("Tolarian Academy",""));
        cubeCards.add(new CardIdentity("Tome Scour",""));
        cubeCards.add(new CardIdentity("Tower of the Magistrate",""));
        cubeCards.add(new CardIdentity("Treachery",""));
        cubeCards.add(new CardIdentity("True-Name Nemesis",""));
        cubeCards.add(new CardIdentity("Turnabout",""));
        cubeCards.add(new CardIdentity("Ulamog, the Infinite Gyre",""));
        cubeCards.add(new CardIdentity("Umezawa's Jitte",""));
        cubeCards.add(new CardIdentity("Undo",""));
        cubeCards.add(new CardIdentity("Upheaval",""));
        cubeCards.add(new CardIdentity("Vapor Snag",""));
        cubeCards.add(new CardIdentity("Vaporkin",""));
        cubeCards.add(new CardIdentity("Vedalken Aethermage",""));
        cubeCards.add(new CardIdentity("Vedalken Shackles",""));
        cubeCards.add(new CardIdentity("Veiled Serpent",""));
        cubeCards.add(new CardIdentity("Vendilion Clique",""));
        cubeCards.add(new CardIdentity("Venser, Shaper Savant",""));
        cubeCards.add(new CardIdentity("Vesuvan Shapeshifter",""));
        cubeCards.add(new CardIdentity("Vexing Sphinx",""));
        cubeCards.add(new CardIdentity("Vision Charm",""));
        cubeCards.add(new CardIdentity("Visions of Beyond",""));
        cubeCards.add(new CardIdentity("Vodalian Knights",""));
        cubeCards.add(new CardIdentity("Void Stalker",""));
        cubeCards.add(new CardIdentity("Voidmage Prodigy",""));
        cubeCards.add(new CardIdentity("Voltaic Key",""));
        cubeCards.add(new CardIdentity("Wake Thrasher",""));
        cubeCards.add(new CardIdentity("Wasp Lancer",""));
        cubeCards.add(new CardIdentity("Waterfront Bouncer",""));
        cubeCards.add(new CardIdentity("Welkin Tern",""));
        cubeCards.add(new CardIdentity("Wheel and Deal",""));
        cubeCards.add(new CardIdentity("Windfall",""));
        cubeCards.add(new CardIdentity("Winter Orb",""));
        cubeCards.add(new CardIdentity("Withdraw",""));
        cubeCards.add(new CardIdentity("Worn Powerstone",""));
        cubeCards.add(new CardIdentity("Wurmcoil Engine",""));
    }
}

