/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.tournament.cubes;

import mage.game.draft.DraftCube;

/**
 *
 * @author fireshoes
 */
public class TimotheeSimonotsTwistedColorPieCube extends DraftCube {

public TimotheeSimonotsTwistedColorPieCube() {
        super("Timothee Simonot's Twisted Color Pie Cube"); // http://magic.wizards.com/en/MTGO/articles/archive/magic-online/you-make-cube-voting-2016-10-17

        cubeCards.add(new DraftCube.CardIdentity("Abbot of Keral Keep", ""));
        cubeCards.add(new DraftCube.CardIdentity("Abhorrent Overlord", ""));
        cubeCards.add(new DraftCube.CardIdentity("Abundant Growth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Academy Rector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aegis of the Gods", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aether Adept", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aether Mutation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ajani's Pridemate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Akroma, Angel of Wrath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Archangel of Thune", ""));
        cubeCards.add(new DraftCube.CardIdentity("Archangel of Tithes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Argothian Enchantress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Argothian Wurm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Arid Mesa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ashcloud Phoenix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ashnod's Altar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aspect of Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Assemble the Legion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Asylum Visitor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Aura Gnarlid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avacyn, Angel of Hope", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avaricious Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Avatar of the Resolute", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ayli, Eternal Pilgrim", ""));
        cubeCards.add(new DraftCube.CardIdentity("Azorius Guildmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Badlands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Baleful Strix", ""));
        cubeCards.add(new DraftCube.CardIdentity("Barren Moor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Basilisk Collar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bayou", ""));
        cubeCards.add(new DraftCube.CardIdentity("Beast Within", ""));
        cubeCards.add(new DraftCube.CardIdentity("Beastmaster Ascension", ""));
        cubeCards.add(new DraftCube.CardIdentity("Become Immense", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bident of Thassa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bitterblossom", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blackcleave Cliffs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blasting Station", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blessed Spirits", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blind Obedience", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blinding Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blinkmoth Nexus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Artist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Blood Crypt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodghast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodsoaked Champion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodstained Mire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bloodthrone Vampire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bone Splinters", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bonesplitter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boon Satyr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Boros Garrison", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bow of Nylea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Braids, Cabal Minion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Brain Maggot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Breath of Life", ""));
        cubeCards.add(new DraftCube.CardIdentity("Breeding Pool", ""));
        cubeCards.add(new DraftCube.CardIdentity("Briarhorn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bruna, the Fading Light", ""));
        cubeCards.add(new DraftCube.CardIdentity("Bubbling Muck", ""));
        cubeCards.add(new DraftCube.CardIdentity("Burst Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cabal Coffers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cabal Interrogator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Caldera Hellion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Call of the Herd", ""));
        cubeCards.add(new DraftCube.CardIdentity("Caller of the Claw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Carrion Feeder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cathodion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Archon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Celestial Colonnade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chain Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Fire of Kaladesh", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Flamecaller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chandra, Pyromaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chaos Warp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Charcoal Diamond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Charmbreaker Devils", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chasm Skulker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Chittering Rats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Circular Logic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Civilized Scholar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Claustrophobia", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cloudfin Raptor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collective Brutality", ""));
        cubeCards.add(new DraftCube.CardIdentity("Collective Defiance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Commandeer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Conclave Naturalists", ""));
        cubeCards.add(new DraftCube.CardIdentity("Coralhelm Commander", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crawling Sensation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Creeping Tar Pit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cryptbreaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Cryptolith Rite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Crystal Shard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Chains", ""));
        cubeCards.add(new DraftCube.CardIdentity("Curse of Predation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dakra Mystic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daretti, Scrap Savant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Confidant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dark Salvation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dawnbreak Reclaimer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Daze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dead // Gone", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deadbridge Goliath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deep Analysis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Defy Death", ""));
        cubeCards.add(new DraftCube.CardIdentity("Demonic Tutor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Deranged Hermit", ""));
        cubeCards.add(new DraftCube.CardIdentity("Descent of the Dragons", ""));
        cubeCards.add(new DraftCube.CardIdentity("Despoiler of Souls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Detention Sphere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Devil's Play", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dismember", ""));
        cubeCards.add(new DraftCube.CardIdentity("Divert", ""));
        cubeCards.add(new DraftCube.CardIdentity("Docent of Perfection", ""));
        cubeCards.add(new DraftCube.CardIdentity("Doubling Season", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragon Fodder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dragonmaster Outcast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dreamstone Hedron", ""));
        cubeCards.add(new DraftCube.CardIdentity("Dryad Militant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duplicant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Duskwatch Recruiter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Edric, Spymaster of Trest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eidolon of Blossoms", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eidolon of Countless Battles", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elder Deep-Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Elephant Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Emrakul, the Promised End", ""));
        cubeCards.add(new DraftCube.CardIdentity("Enlightened Tutor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Entomber Exarch", ""));
        cubeCards.add(new DraftCube.CardIdentity("Epic Confrontation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Epochrasite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Equilibrium", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eternal Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Eternal Witness", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ethereal Armor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evangelize", ""));
        cubeCards.add(new DraftCube.CardIdentity("Evolving Wilds", ""));
        cubeCards.add(new DraftCube.CardIdentity("Executioner's Capsule", ""));
        cubeCards.add(new DraftCube.CardIdentity("Experiment One", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faceless Butcher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faerie Conclave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Faith's Fetters", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fall of the Titans", ""));
        cubeCards.add(new DraftCube.CardIdentity("False Defeat", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fauna Shaman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Feldon of the Third Path", ""));
        cubeCards.add(new DraftCube.CardIdentity("Felidar Sovereign", ""));
        cubeCards.add(new DraftCube.CardIdentity("Festering Goblin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fetid Heath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire Diamond", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fire-Lit Thicket", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fireslinger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flame Slash", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flametongue Kavu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flash of Insight", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flesh Carver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Fleshbag Marauder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flickerwisp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Flooded Strand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Force Spike", ""));
        cubeCards.add(new DraftCube.CardIdentity("Force of Will", ""));
        cubeCards.add(new DraftCube.CardIdentity("Frost Walker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gaea's Anthem", ""));
        cubeCards.add(new DraftCube.CardIdentity("Garruk Relentless", ""));
        cubeCards.add(new DraftCube.CardIdentity("Garruk Wildspeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gauntlet of Might", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gelectrode", ""));
        cubeCards.add(new DraftCube.CardIdentity("Genesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghastly Demise", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghostly Prison", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ghoultree", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gideon Jura", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gideon, Champion of Justice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gilded Lotus", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gisela, the Broken Blade", ""));
        cubeCards.add(new DraftCube.CardIdentity("Glen Elendra Archmage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Assault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Bombardment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Dark-Dwellers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Sharpshooter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblin Welder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Goblinslide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Godless Shrine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Golgari Grave-Troll", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grafted Wargear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grand Architect", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grapple with the Past", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grave Pact", ""));
        cubeCards.add(new DraftCube.CardIdentity("Greater Gargadon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Green Sun's Zenith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Griffin Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Flayer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Haruspex", ""));
        cubeCards.add(new DraftCube.CardIdentity("Grim Lavamancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Griselbrand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Gryff's Boon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Halcyon Glaze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hall of Triumph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hallowed Fountain", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hangarback Walker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Headhunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Heart of Ramos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hedron Archive", ""));
        cubeCards.add(new DraftCube.CardIdentity("Heliod, God of the Sun", ""));
        cubeCards.add(new DraftCube.CardIdentity("Herald of the Pantheon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hermit Druid", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hollow Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hopeful Eidolon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hordeling Outburst", ""));
        cubeCards.add(new DraftCube.CardIdentity("Horizon Canopy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Huntmaster of the Fells", ""));
        cubeCards.add(new DraftCube.CardIdentity("Hypnotic Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Icy Manipulator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Imp's Mischief", ""));
        cubeCards.add(new DraftCube.CardIdentity("Incendiary Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Infiltration Lens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Innocent Blood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Iona, Shield of Emeria", ""));
        cubeCards.add(new DraftCube.CardIdentity("Izzet Staticaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jace, Vryn's Prodigy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jaya Ballard, Task Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jet Medallion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jhessian Thief", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jhoira of the Ghitu", ""));
        cubeCards.add(new DraftCube.CardIdentity("Jokulhaups", ""));
        cubeCards.add(new DraftCube.CardIdentity("Journey to Nowhere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kalonian Tusker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Karlov of the Ghost Council", ""));
        cubeCards.add(new DraftCube.CardIdentity("Karmic Guide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Keen Sense", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kessig Cagebreakers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kessig Prowler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kher Keep", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kira, Great Glass-Spinner", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kitchen Finks", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kor Spiritdancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kozilek, Butcher of Truth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krenko's Command", ""));
        cubeCards.add(new DraftCube.CardIdentity("Krenko, Mob Boss", ""));
        cubeCards.add(new DraftCube.CardIdentity("Kumano, Master Yamabushi", ""));
        cubeCards.add(new DraftCube.CardIdentity("Laboratory Maniac", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leaden Myr", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leafcrown Dryad", ""));
        cubeCards.add(new DraftCube.CardIdentity("Leonin Bola", ""));
        cubeCards.add(new DraftCube.CardIdentity("Life from the Loam", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Bolt", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lightning Crafter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lignify", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana of the Veil", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, Heretical Healer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Liliana, the Last Hope", ""));
        cubeCards.add(new DraftCube.CardIdentity("Looter il-Kor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Loyal Retainers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Lumbering Falls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Luminarch Ascension", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magma Jet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Magus of the Tabernacle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Confluence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mana Tithe", ""));
        cubeCards.add(new DraftCube.CardIdentity("Managorger Hydra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mangara of Corondor", ""));
        cubeCards.add(new DraftCube.CardIdentity("March of Souls", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mark of Eviction", ""));
        cubeCards.add(new DraftCube.CardIdentity("Marsh Flats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Martyr of Frost", ""));
        cubeCards.add(new DraftCube.CardIdentity("Martyr of Sands", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mass Polymorph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Master of Waves", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mausoleum Wanderer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Maze of Ith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Memory Jar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Memory Lapse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Meren of Clan Nel Toth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mesa Enchantress", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mesmeric Fiend", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mesmeric Orb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Military Intelligence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mindslaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Miraculous Recovery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Misdirection", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mishra's Factory", ""));
        cubeCards.add(new DraftCube.CardIdentity("Misty Rainforest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogg Fanatic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mogg War Marshal", ""));
        cubeCards.add(new DraftCube.CardIdentity("Molten Birth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Molten Slagheap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Monk Idealist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mortarpod", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mosswort Bridge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Cut", ""));
        cubeCards.add(new DraftCube.CardIdentity("Murderous Redcap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mutagenic Growth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Mutavault", ""));
        cubeCards.add(new DraftCube.CardIdentity("Myr Battlesphere", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nahiri's Wrath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nahiri, the Harbinger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nantuko Husk", ""));
        cubeCards.add(new DraftCube.CardIdentity("Necromancer's Stockpile", ""));
        cubeCards.add(new DraftCube.CardIdentity("Needle Spires", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nether Traitor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nettle Sentinel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nezumi Shortfang", ""));
        cubeCards.add(new DraftCube.CardIdentity("Niblis of Frost", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nicol Bolas, Planeswalker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nightveil Specter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ninja of the Deep Hours", ""));
        cubeCards.add(new DraftCube.CardIdentity("Niv-Mizzet, the Firemind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Noose Constrictor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Norn's Annex", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nykthos, Shrine to Nyx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx Weaver", ""));
        cubeCards.add(new DraftCube.CardIdentity("Nyx-Fleece Ram", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obliterate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oblivion Ring", ""));
        cubeCards.add(new DraftCube.CardIdentity("Obzedat, Ghost Council", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opal Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opalescence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Open the Vaults", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ophiomancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Opposition", ""));
        cubeCards.add(new DraftCube.CardIdentity("Orcish Cannoneers", ""));
        cubeCards.add(new DraftCube.CardIdentity("Outpost Siege", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overgrown Tomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overrun", ""));
        cubeCards.add(new DraftCube.CardIdentity("Oversold Cemetery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Overwhelming Stampede", ""));
        cubeCards.add(new DraftCube.CardIdentity("Parallax Tide", ""));
        cubeCards.add(new DraftCube.CardIdentity("Patron Wizard", ""));
        cubeCards.add(new DraftCube.CardIdentity("Peace of Mind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phantasmal Bear", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phantasmal Image", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Revoker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Phyrexian Totem", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pia and Kiran Nalaar", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pillory of the Sleepless", ""));
        cubeCards.add(new DraftCube.CardIdentity("Plateau", ""));
        cubeCards.add(new DraftCube.CardIdentity("Platinum Emperion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Polluted Delta", ""));
        cubeCards.add(new DraftCube.CardIdentity("Polymorph", ""));
        cubeCards.add(new DraftCube.CardIdentity("Porcelain Legionnaire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Porphyry Nodes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Predatory Rampage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prey Upon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pristine Talisman", ""));
        cubeCards.add(new DraftCube.CardIdentity("Propaganda", ""));
        cubeCards.add(new DraftCube.CardIdentity("Prophetic Prism", ""));
        cubeCards.add(new DraftCube.CardIdentity("Proteus Staff", ""));
        cubeCards.add(new DraftCube.CardIdentity("Psionic Blast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Psychic Spiral", ""));
        cubeCards.add(new DraftCube.CardIdentity("Purphoros, God of the Forge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pyrite Spellbomb", ""));
        cubeCards.add(new DraftCube.CardIdentity("Pyromancer's Goggles", ""));
        cubeCards.add(new DraftCube.CardIdentity("Quicksilver Amulet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Raging Ravine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos Keyrune", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos Signet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rakdos's Return", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rancor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Raven's Crime", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ravenous Rats", ""));
        cubeCards.add(new DraftCube.CardIdentity("Razorfin Hunter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reassembling Skeleton", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reclamation Sage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Recurring Nightmare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Regrowth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Relentless Dead", ""));
        cubeCards.add(new DraftCube.CardIdentity("Remand", ""));
        cubeCards.add(new DraftCube.CardIdentity("Replenish", ""));
        cubeCards.add(new DraftCube.CardIdentity("Restoration Angel", ""));
        cubeCards.add(new DraftCube.CardIdentity("Resurrection", ""));
        cubeCards.add(new DraftCube.CardIdentity("Reveillark", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rhys the Redeemed", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riftwing Cloudskate", ""));
        cubeCards.add(new DraftCube.CardIdentity("Riptide Laboratory", ""));
        cubeCards.add(new DraftCube.CardIdentity("River of Tears", ""));
        cubeCards.add(new DraftCube.CardIdentity("Rolling Earthquake", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ruby Medallion", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sacred Foundry", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sacred Mesa", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sage of Fables", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sage's Dousing", ""));
        cubeCards.add(new DraftCube.CardIdentity("Saproling Burst", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sarkhan, the Dragonspeaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Savannah", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scalding Tarn", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scavenging Ooze", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scepter of Dominance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scourge of Nel Toth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrap Mastery", ""));
        cubeCards.add(new DraftCube.CardIdentity("Scrubland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Searing Meditation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Seeker of the Way", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serene Steward", ""));
        cubeCards.add(new DraftCube.CardIdentity("Serra Ascendant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Setessan Tactics", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sever the Bloodline", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sewer Nemesis", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shadowmage Infiltrator", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shambling Vent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shelldock Isle", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sheoldred, Whispering One", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shriekmaw", ""));
        cubeCards.add(new DraftCube.CardIdentity("Shrine of Burning Rage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sidisi, Undead Vizier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Siege-Gang Commander", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sigil of the Empty Throne", ""));
        cubeCards.add(new DraftCube.CardIdentity("Silumgar Sorcerer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skinrender", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skinshifter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skirsdag High Priest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Skullclamp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Smokestack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snakeform", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snap", ""));
        cubeCards.add(new DraftCube.CardIdentity("Snapcaster Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sneak Attack", ""));
        cubeCards.add(new DraftCube.CardIdentity("Solemn Simulacrum", ""));
        cubeCards.add(new DraftCube.CardIdentity("Solitary Confinement", ""));
        cubeCards.add(new DraftCube.CardIdentity("Song of the Dryads", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soul Warden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Soulfire Grand Master", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sparksmith", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spell Pierce", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spellstutter Sprite", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sphere of Safety", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spikeshot Elder", ""));
        cubeCards.add(new DraftCube.CardIdentity("Spiketail Drakeling", ""));
        cubeCards.add(new DraftCube.CardIdentity("Splinterfright", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sprout Swarm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Squee, Goblin Nabob", ""));
        cubeCards.add(new DraftCube.CardIdentity("Squirrel Nest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Staggershock", ""));
        cubeCards.add(new DraftCube.CardIdentity("Standstill", ""));
        cubeCards.add(new DraftCube.CardIdentity("Starfield of Nyx", ""));
        cubeCards.add(new DraftCube.CardIdentity("Starstorm", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stasis Snare", ""));
        cubeCards.add(new DraftCube.CardIdentity("Steam Vents", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sterling Grove", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stinkweed Imp", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stirring Wildwood", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stoke the Flames", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stomping Ground", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stonybrook Banneret", ""));
        cubeCards.add(new DraftCube.CardIdentity("Strangleroot Geist", ""));
        cubeCards.add(new DraftCube.CardIdentity("Strip Mine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Stronghold Assassin", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sun Droplet", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sundering Titan", ""));
        cubeCards.add(new DraftCube.CardIdentity("Survival of the Fittest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Sylvan Library", ""));
        cubeCards.add(new DraftCube.CardIdentity("Syndic of Tithes", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tahngarth, Talruum Hero", ""));
        cubeCards.add(new DraftCube.CardIdentity("Taiga", ""));
        cubeCards.add(new DraftCube.CardIdentity("Talisman of Indulgence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tangle Wire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tarmogoyf", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tasigur, the Golden Fang", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tectonic Edge", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple Garden", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Enlightenment", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Epiphany", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temple of Malady", ""));
        cubeCards.add(new DraftCube.CardIdentity("Temporal Isolation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tempt with Vengeance", ""));
        cubeCards.add(new DraftCube.CardIdentity("Terramorphic Expanse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thassa, God of the Sea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thought Courier", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thraben Inspector", ""));
        cubeCards.add(new DraftCube.CardIdentity("Thwart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tidebinder Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tombstone Stairwell", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tormenting Voice", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trading Post", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tranquil Thicket", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trash for Treasure", ""));
        cubeCards.add(new DraftCube.CardIdentity("Treetop Village", ""));
        cubeCards.add(new DraftCube.CardIdentity("Trinket Mage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Triskaidekaphobia", ""));
        cubeCards.add(new DraftCube.CardIdentity("Troll Ascetic", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tropical Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tuktuk the Explorer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Tundra", ""));
        cubeCards.add(new DraftCube.CardIdentity("Turn Aside", ""));
        cubeCards.add(new DraftCube.CardIdentity("Twilight Mire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ugin, the Spirit Dragon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulamog, the Ceaseless Hunger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulamog, the Infinite Gyre", ""));
        cubeCards.add(new DraftCube.CardIdentity("Ulvenwald Tracker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unburial Rites", ""));
        cubeCards.add(new DraftCube.CardIdentity("Undercity Informer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Underground Sea", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unexpectedly Absent", ""));
        cubeCards.add(new DraftCube.CardIdentity("Unflinching Courage", ""));
        cubeCards.add(new DraftCube.CardIdentity("Urborg, Tomb of Yawgmoth", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vampiric Tutor", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vapor Snag", ""));
        cubeCards.add(new DraftCube.CardIdentity("Varolz, the Scar-Striped", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vedalken Mastermind", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vendilion Clique", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vengevine", ""));
        cubeCards.add(new DraftCube.CardIdentity("Venser, Shaper Savant", ""));
        cubeCards.add(new DraftCube.CardIdentity("Verdant Catacombs", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vessel of Nascency", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viridian Zealot", ""));
        cubeCards.add(new DraftCube.CardIdentity("Visara the Dreadful", ""));
        cubeCards.add(new DraftCube.CardIdentity("Viscera Seer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Vithian Stinger", ""));
        cubeCards.add(new DraftCube.CardIdentity("Voidmage Prodigy", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volcanic Island", ""));
        cubeCards.add(new DraftCube.CardIdentity("Volrath's Stronghold", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wake Thrasher", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Omens", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wall of Reverence", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wandering Fumarole", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wasteland", ""));
        cubeCards.add(new DraftCube.CardIdentity("Waterfront Bouncer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Watery Grave", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weathered Wayfarer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Weaver of Lightning", ""));
        cubeCards.add(new DraftCube.CardIdentity("Well of Lost Dreams", ""));
        cubeCards.add(new DraftCube.CardIdentity("Westvale Abbey", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whip of Erebos", ""));
        cubeCards.add(new DraftCube.CardIdentity("Whirler Rogue", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wild Beastmaster", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wildfire", ""));
        cubeCards.add(new DraftCube.CardIdentity("Willbreaker", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wind Zendikon", ""));
        cubeCards.add(new DraftCube.CardIdentity("Windborn Muse", ""));
        cubeCards.add(new DraftCube.CardIdentity("Windswept Heath", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wingcrafter", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wolfbitten Captive", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wolfir Silverheart", ""));
        cubeCards.add(new DraftCube.CardIdentity("Wooded Foothills", ""));
        cubeCards.add(new DraftCube.CardIdentity("World Queller", ""));
        cubeCards.add(new DraftCube.CardIdentity("Worm Harvest", ""));
        cubeCards.add(new DraftCube.CardIdentity("Xenagos, the Reveler", ""));
        cubeCards.add(new DraftCube.CardIdentity("Yavimaya Coast", ""));
        cubeCards.add(new DraftCube.CardIdentity("Young Pyromancer", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zombie Infestation", ""));
        cubeCards.add(new DraftCube.CardIdentity("Zur's Weirding", ""));
    }
}
