/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.cards.e;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.LoyaltyAbility;
import mage.abilities.common.PlanswalkerEntersWithLoyalityCountersAbility;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.SubType;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.game.permanent.PermanentToken;
import mage.game.permanent.token.SoldierToken;
import mage.players.Player;

/**
 *
 * @author Loki
 */
public final class ElspethTirel extends CardImpl {

    public ElspethTirel(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.PLANESWALKER}, "{3}{W}{W}");
        this.addSuperType(SuperType.LEGENDARY);
        this.subtype.add(SubType.ELSPETH);

        this.addAbility(new PlanswalkerEntersWithLoyalityCountersAbility(4));

        this.addAbility(new LoyaltyAbility(new ElspethTirelFirstEffect(), 2));
        this.addAbility(new LoyaltyAbility(new CreateTokenEffect(new SoldierToken(), 3), -2));
        this.addAbility(new LoyaltyAbility(new ElspethTirelThirdEffect(), -5));
    }

    public ElspethTirel(final ElspethTirel card) {
        super(card);
    }

    @Override
    public ElspethTirel copy() {
        return new ElspethTirel(this);
    }
}

class ElspethTirelFirstEffect extends OneShotEffect {

    public ElspethTirelFirstEffect() {
        super(Outcome.GainLife);
        staticText = "You gain 1 life for each creature you control";
    }

    public ElspethTirelFirstEffect(final ElspethTirelFirstEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        int amount = game.getBattlefield().countAll(StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), game);
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            player.gainLife(amount, game, source);
        }
        return true;
    }

    @Override
    public ElspethTirelFirstEffect copy() {
        return new ElspethTirelFirstEffect(this);
    }

}

class ElspethTirelThirdEffect extends OneShotEffect {

    public ElspethTirelThirdEffect() {
        super(Outcome.DestroyPermanent);
        staticText = "Destroy all other permanents except for lands and tokens";
    }

    public ElspethTirelThirdEffect(final ElspethTirelThirdEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {
        for (Permanent perm : game.getBattlefield().getActivePermanents(source.getControllerId(), game)) {
            if (!perm.getId().equals(source.getSourceId()) && !(perm instanceof PermanentToken) && !(perm.isLand())) {
                perm.destroy(source.getSourceId(), game, false);
            }
        }
        return true;
    }

    @Override
    public ElspethTirelThirdEffect copy() {
        return new ElspethTirelThirdEffect(this);
    }

}
