/*
 *  Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 *  Redistribution and use in source and binary forms, with or without modification, are
 *  permitted provided that the following conditions are met:
 *
 *     1. Redistributions of source code must retain the above copyright notice, this list of
 *        conditions and the following disclaimer.
 *
 *     2. Redistributions in binary form must reproduce the above copyright notice, this list
 *        of conditions and the following disclaimer in the documentation and/or other materials
 *        provided with the distribution.
 *
 *  THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 *  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 *  SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 *  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 *  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 *  ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *  The views and conclusions contained in the software and documentation are those of the
 *  authors and should not be interpreted as representing official policies, either expressed
 *  or implied, of BetaSteward_at_googlemail.com.
 */
package mage.cards.u;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.abilities.effects.common.EpicEffect;
import mage.cards.Card;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetAnyTarget;

/**
 *
 * @author jeffwadsworth
 *
 */
public final class UndyingFlames extends CardImpl {

    public UndyingFlames(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.SORCERY}, "{4}{R}{R}");

        // Exile cards from the top of your library until you exile a nonland card. Undying Flames deals damage to any target equal to that card's converted mana cost.
        this.getSpellAbility().addEffect(new UndyingFlamesEffect());
        this.getSpellAbility().addTarget(new TargetAnyTarget());

        // Epic
        this.getSpellAbility().addEffect(new EpicEffect());

    }

    public UndyingFlames(final UndyingFlames card) {
        super(card);
    }

    @Override
    public UndyingFlames copy() {
        return new UndyingFlames(this);
    }
}

class UndyingFlamesEffect extends OneShotEffect {

    public UndyingFlamesEffect() {
        super(Outcome.Benefit);
        staticText = "Exile cards from the top of your library until you exile a nonland card. {this} deals damage to any target equal to that card's converted mana cost";
    }

    public UndyingFlamesEffect(final UndyingFlamesEffect effect) {
        super(effect);
    }

    @Override
    public boolean apply(Game game, Ability source) {

        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            while (controller.getLibrary().hasCards() && controller.isInGame()) {
                Card card = controller.getLibrary().getFromTop(game);
                if (card != null) {
                    controller.moveCards(card, Zone.LIBRARY, source, game);
                    if (!card.isLand()) {
                        new DamageTargetEffect(card.getConvertedManaCost()).apply(game, source);
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public UndyingFlamesEffect copy() {
        return new UndyingFlamesEffect(this);
    }
}
