package mage.sets;

import mage.cards.ExpansionSet;
import mage.constants.Rarity;
import mage.constants.SetType;

public final class Eventide extends ExpansionSet {

    private static final Eventide instance = new Eventide();

    public static Eventide getInstance() {
        return instance;
    }

    private Eventide() {
        super("Eventide", "EVE", ExpansionSet.buildDate(2008, 6, 25), SetType.EXPANSION);
        this.blockName = "Shadowmoor";
        this.parentSet = Shadowmoor.getInstance();
        this.hasBasicLands = false;
        this.hasBoosters = true;
        this.numBoosterLands = 0;
        this.numBoosterCommon = 11;
        this.numBoosterUncommon = 3;
        this.numBoosterRare = 1;
        this.ratioBoosterMythic = 0;
        cards.add(new SetCardInfo("Aerie Ouphes", 65, Rarity.COMMON, mage.cards.a.AerieOuphes.class));
        cards.add(new SetCardInfo("Altar Golem", 166, Rarity.RARE, mage.cards.a.AltarGolem.class));
        cards.add(new SetCardInfo("Antler Skulkin", 167, Rarity.COMMON, mage.cards.a.AntlerSkulkin.class));
        cards.add(new SetCardInfo("Archon of Justice", 1, Rarity.RARE, mage.cards.a.ArchonOfJustice.class));
        cards.add(new SetCardInfo("Ashling, the Extinguisher", 33, Rarity.RARE, mage.cards.a.AshlingTheExtinguisher.class));
        cards.add(new SetCardInfo("Balefire Liege", 132, Rarity.RARE, mage.cards.b.BalefireLiege.class));
        cards.add(new SetCardInfo("Ballynock Trapper", 2, Rarity.COMMON, mage.cards.b.BallynockTrapper.class));
        cards.add(new SetCardInfo("Banishing Knack", 17, Rarity.COMMON, mage.cards.b.BanishingKnack.class));
        cards.add(new SetCardInfo("Battlegate Mimic", 133, Rarity.COMMON, mage.cards.b.BattlegateMimic.class));
        cards.add(new SetCardInfo("Batwing Brume", 81, Rarity.UNCOMMON, mage.cards.b.BatwingBrume.class));
        cards.add(new SetCardInfo("Beckon Apparition", 82, Rarity.COMMON, mage.cards.b.BeckonApparition.class));
        cards.add(new SetCardInfo("Belligerent Hatchling", 134, Rarity.UNCOMMON, mage.cards.b.BelligerentHatchling.class));
        cards.add(new SetCardInfo("Bloodied Ghost", 83, Rarity.UNCOMMON, mage.cards.b.BloodiedGhost.class));
        cards.add(new SetCardInfo("Bloom Tender", 66, Rarity.RARE, mage.cards.b.BloomTender.class));
        cards.add(new SetCardInfo("Cache Raiders", 18, Rarity.UNCOMMON, mage.cards.c.CacheRaiders.class));
        cards.add(new SetCardInfo("Call the Skybreaker", 98, Rarity.RARE, mage.cards.c.CallTheSkybreaker.class));
        cards.add(new SetCardInfo("Canker Abomination", 115, Rarity.UNCOMMON, mage.cards.c.CankerAbomination.class));
        cards.add(new SetCardInfo("Cankerous Thirst", 116, Rarity.UNCOMMON, mage.cards.c.CankerousThirst.class));
        cards.add(new SetCardInfo("Cascade Bluffs", 175, Rarity.RARE, mage.cards.c.CascadeBluffs.class));
        cards.add(new SetCardInfo("Cauldron Haze", 84, Rarity.UNCOMMON, mage.cards.c.CauldronHaze.class));
        cards.add(new SetCardInfo("Cenn's Enlistment", 3, Rarity.COMMON, mage.cards.c.CennsEnlistment.class));
        cards.add(new SetCardInfo("Chaotic Backlash", 49, Rarity.UNCOMMON, mage.cards.c.ChaoticBacklash.class));
        cards.add(new SetCardInfo("Cinder Pyromancer", 50, Rarity.COMMON, mage.cards.c.CinderPyromancer.class));
        cards.add(new SetCardInfo("Clout of the Dominus", 99, Rarity.COMMON, mage.cards.c.CloutOfTheDominus.class));
        cards.add(new SetCardInfo("Cold-Eyed Selkie", 149, Rarity.RARE, mage.cards.c.ColdEyedSelkie.class));
        cards.add(new SetCardInfo("Crackleburr", 100, Rarity.RARE, mage.cards.c.Crackleburr.class));
        cards.add(new SetCardInfo("Crag Puca", 101, Rarity.UNCOMMON, mage.cards.c.CragPuca.class));
        cards.add(new SetCardInfo("Creakwood Ghoul", 34, Rarity.UNCOMMON, mage.cards.c.CreakwoodGhoul.class));
        cards.add(new SetCardInfo("Creakwood Liege", 117, Rarity.RARE, mage.cards.c.CreakwoodLiege.class));
        cards.add(new SetCardInfo("Crumbling Ashes", 35, Rarity.UNCOMMON, mage.cards.c.CrumblingAshes.class));
        cards.add(new SetCardInfo("Deathbringer Liege", 85, Rarity.RARE, mage.cards.d.DeathbringerLiege.class));
        cards.add(new SetCardInfo("Deity of Scars", 118, Rarity.RARE, mage.cards.d.DeityOfScars.class));
        cards.add(new SetCardInfo("Desecrator Hag", 119, Rarity.COMMON, mage.cards.d.DesecratorHag.class));
        cards.add(new SetCardInfo("Divinity of Pride", 86, Rarity.RARE, mage.cards.d.DivinityOfPride.class));
        cards.add(new SetCardInfo("Dominus of Fealty", 102, Rarity.RARE, mage.cards.d.DominusOfFealty.class));
        cards.add(new SetCardInfo("Doomgape", 120, Rarity.RARE, mage.cards.d.Doomgape.class));
        cards.add(new SetCardInfo("Double Cleave", 135, Rarity.COMMON, mage.cards.d.DoubleCleave.class));
        cards.add(new SetCardInfo("Drain the Well", 121, Rarity.COMMON, mage.cards.d.DrainTheWell.class));
        cards.add(new SetCardInfo("Dream Fracture", 19, Rarity.UNCOMMON, mage.cards.d.DreamFracture.class));
        cards.add(new SetCardInfo("Dream Thief", 20, Rarity.COMMON, mage.cards.d.DreamThief.class));
        cards.add(new SetCardInfo("Duergar Assailant", 136, Rarity.COMMON, mage.cards.d.DuergarAssailant.class));
        cards.add(new SetCardInfo("Duergar Cave-Guard", 51, Rarity.UNCOMMON, mage.cards.d.DuergarCaveGuard.class));
        cards.add(new SetCardInfo("Duergar Hedge-Mage", 137, Rarity.UNCOMMON, mage.cards.d.DuergarHedgeMage.class));
        cards.add(new SetCardInfo("Duergar Mine-Captain", 138, Rarity.UNCOMMON, mage.cards.d.DuergarMineCaptain.class));
        cards.add(new SetCardInfo("Duskdale Wurm", 67, Rarity.UNCOMMON, mage.cards.d.DuskdaleWurm.class));
        cards.add(new SetCardInfo("Edge of the Divinity", 87, Rarity.COMMON, mage.cards.e.EdgeOfTheDivinity.class));
        cards.add(new SetCardInfo("Endless Horizons", 4, Rarity.RARE, mage.cards.e.EndlessHorizons.class));
        cards.add(new SetCardInfo("Endure", 5, Rarity.UNCOMMON, mage.cards.e.Endure.class));
        cards.add(new SetCardInfo("Evershrike", 88, Rarity.RARE, mage.cards.e.Evershrike.class));
        cards.add(new SetCardInfo("Fable of Wolf and Owl", 150, Rarity.RARE, mage.cards.f.FableOfWolfAndOwl.class));
        cards.add(new SetCardInfo("Fang Skulkin", 168, Rarity.COMMON, mage.cards.f.FangSkulkin.class));
        cards.add(new SetCardInfo("Favor of the Overbeing", 151, Rarity.COMMON, mage.cards.f.FavorOfTheOverbeing.class));
        cards.add(new SetCardInfo("Fetid Heath", 176, Rarity.RARE, mage.cards.f.FetidHeath.class));
        cards.add(new SetCardInfo("Fiery Bombardment", 52, Rarity.RARE, mage.cards.f.FieryBombardment.class));
        cards.add(new SetCardInfo("Figure of Destiny", 139, Rarity.RARE, mage.cards.f.FigureOfDestiny.class));
        cards.add(new SetCardInfo("Fire at Will", 140, Rarity.COMMON, mage.cards.f.FireAtWill.class));
        cards.add(new SetCardInfo("Flame Jab", 53, Rarity.COMMON, mage.cards.f.FlameJab.class));
        cards.add(new SetCardInfo("Flickerwisp", 6, Rarity.UNCOMMON, mage.cards.f.Flickerwisp.class));
        cards.add(new SetCardInfo("Flooded Grove", 177, Rarity.RARE, mage.cards.f.FloodedGrove.class));
        cards.add(new SetCardInfo("Gift of the Deity", 122, Rarity.COMMON, mage.cards.g.GiftOfTheDeity.class));
        cards.add(new SetCardInfo("Gilder Bairn", 152, Rarity.UNCOMMON, mage.cards.g.GilderBairn.class));
        cards.add(new SetCardInfo("Glen Elendra Archmage", 22, Rarity.RARE, mage.cards.g.GlenElendraArchmage.class));
        cards.add(new SetCardInfo("Grazing Kelpie", 153, Rarity.COMMON, mage.cards.g.GrazingKelpie.class));
        cards.add(new SetCardInfo("Groundling Pouncer", 154, Rarity.UNCOMMON, mage.cards.g.GroundlingPouncer.class));
        cards.add(new SetCardInfo("Gwyllion Hedge-Mage", 89, Rarity.UNCOMMON, mage.cards.g.GwyllionHedgeMage.class));
        cards.add(new SetCardInfo("Hag Hedge-Mage", 123, Rarity.UNCOMMON, mage.cards.h.HagHedgeMage.class));
        cards.add(new SetCardInfo("Hallowed Burial", 7, Rarity.RARE, mage.cards.h.HallowedBurial.class));
        cards.add(new SetCardInfo("Harvest Gwyllion", 90, Rarity.COMMON, mage.cards.h.HarvestGwyllion.class));
        cards.add(new SetCardInfo("Hatchet Bully", 54, Rarity.UNCOMMON, mage.cards.h.HatchetBully.class));
        cards.add(new SetCardInfo("Hateflayer", 55, Rarity.RARE, mage.cards.h.Hateflayer.class));
        cards.add(new SetCardInfo("Hearthfire Hobgoblin", 141, Rarity.UNCOMMON, mage.cards.h.HearthfireHobgoblin.class));
        cards.add(new SetCardInfo("Heartlash Cinder", 56, Rarity.COMMON, mage.cards.h.HeartlashCinder.class));
        cards.add(new SetCardInfo("Helix Pinnacle", 68, Rarity.RARE, mage.cards.h.HelixPinnacle.class));
        cards.add(new SetCardInfo("Hobgoblin Dragoon", 142, Rarity.COMMON, mage.cards.h.HobgoblinDragoon.class));
        cards.add(new SetCardInfo("Hoof Skulkin", 169, Rarity.COMMON, mage.cards.h.HoofSkulkin.class));
        cards.add(new SetCardInfo("Hotheaded Giant", 57, Rarity.COMMON, mage.cards.h.HotheadedGiant.class));
        cards.add(new SetCardInfo("Idle Thoughts", 23, Rarity.UNCOMMON, mage.cards.i.IdleThoughts.class));
        cards.add(new SetCardInfo("Impelled Giant", 58, Rarity.UNCOMMON, mage.cards.i.ImpelledGiant.class));
        cards.add(new SetCardInfo("Indigo Faerie", 24, Rarity.UNCOMMON, mage.cards.i.IndigoFaerie.class));
        cards.add(new SetCardInfo("Inside Out", 103, Rarity.COMMON, mage.cards.i.InsideOut.class));
        cards.add(new SetCardInfo("Inundate", 25, Rarity.RARE, mage.cards.i.Inundate.class));
        cards.add(new SetCardInfo("Invert the Skies", 155, Rarity.UNCOMMON, mage.cards.i.InvertTheSkies.class));
        cards.add(new SetCardInfo("Jawbone Skulkin", 170, Rarity.COMMON, mage.cards.j.JawboneSkulkin.class));
        cards.add(new SetCardInfo("Kithkin Spellduster", 8, Rarity.COMMON, mage.cards.k.KithkinSpellduster.class));
        cards.add(new SetCardInfo("Kithkin Zealot", 9, Rarity.COMMON, mage.cards.k.KithkinZealot.class));
        cards.add(new SetCardInfo("Leering Emblem", 171, Rarity.RARE, mage.cards.l.LeeringEmblem.class));
        cards.add(new SetCardInfo("Light from Within", 10, Rarity.RARE, mage.cards.l.LightFromWithin.class));
        cards.add(new SetCardInfo("Lingering Tormentor", 36, Rarity.UNCOMMON, mage.cards.l.LingeringTormentor.class));
        cards.add(new SetCardInfo("Loyal Gyrfalcon", 11, Rarity.UNCOMMON, mage.cards.l.LoyalGyrfalcon.class));
        cards.add(new SetCardInfo("Marshdrinker Giant", 69, Rarity.UNCOMMON, mage.cards.m.MarshdrinkerGiant.class));
        cards.add(new SetCardInfo("Merrow Bonegnawer", 37, Rarity.COMMON, mage.cards.m.MerrowBonegnawer.class));
        cards.add(new SetCardInfo("Merrow Levitator", 26, Rarity.COMMON, mage.cards.m.MerrowLevitator.class));
        cards.add(new SetCardInfo("Mindwrack Liege", 104, Rarity.RARE, mage.cards.m.MindwrackLiege.class));
        cards.add(new SetCardInfo("Mirror Sheen", 105, Rarity.RARE, mage.cards.m.MirrorSheen.class));
        cards.add(new SetCardInfo("Monstrify", 70, Rarity.COMMON, mage.cards.m.Monstrify.class));
        cards.add(new SetCardInfo("Moonhold", 143, Rarity.UNCOMMON, mage.cards.m.Moonhold.class));
        cards.add(new SetCardInfo("Murkfiend Liege", 156, Rarity.RARE, mage.cards.m.MurkfiendLiege.class));
        cards.add(new SetCardInfo("Necroskitter", 38, Rarity.RARE, mage.cards.n.Necroskitter.class));
        cards.add(new SetCardInfo("Needle Specter", 39, Rarity.RARE, mage.cards.n.NeedleSpecter.class));
        cards.add(new SetCardInfo("Nettle Sentinel", 71, Rarity.COMMON, mage.cards.n.NettleSentinel.class));
        cards.add(new SetCardInfo("Nightmare Incursion", 40, Rarity.RARE, mage.cards.n.NightmareIncursion.class));
        cards.add(new SetCardInfo("Nightsky Mimic", 91, Rarity.COMMON, mage.cards.n.NightskyMimic.class));
        cards.add(new SetCardInfo("Nip Gwyllion", 92, Rarity.COMMON, mage.cards.n.NipGwyllion.class));
        cards.add(new SetCardInfo("Nobilis of War", 144, Rarity.RARE, mage.cards.n.NobilisOfWar.class));
        cards.add(new SetCardInfo("Noggle Bandit", 106, Rarity.COMMON, mage.cards.n.NoggleBandit.class));
        cards.add(new SetCardInfo("Noggle Bridgebreaker", 107, Rarity.COMMON, mage.cards.n.NoggleBridgebreaker.class));
        cards.add(new SetCardInfo("Noggle Hedge-Mage", 108, Rarity.UNCOMMON, mage.cards.n.NoggleHedgeMage.class));
        cards.add(new SetCardInfo("Noggle Ransacker", 109, Rarity.UNCOMMON, mage.cards.n.NoggleRansacker.class));
        cards.add(new SetCardInfo("Noxious Hatchling", 124, Rarity.UNCOMMON, mage.cards.n.NoxiousHatchling.class));
        cards.add(new SetCardInfo("Nucklavee", 110, Rarity.UNCOMMON, mage.cards.n.Nucklavee.class));
        cards.add(new SetCardInfo("Odious Trow", 125, Rarity.COMMON, mage.cards.o.OdiousTrow.class));
        cards.add(new SetCardInfo("Oona's Grace", 27, Rarity.COMMON, mage.cards.o.OonasGrace.class));
        cards.add(new SetCardInfo("Outrage Shaman", 59, Rarity.UNCOMMON, mage.cards.o.OutrageShaman.class));
        cards.add(new SetCardInfo("Overbeing of Myth", 157, Rarity.RARE, mage.cards.o.OverbeingOfMyth.class));
        cards.add(new SetCardInfo("Patrol Signaler", 12, Rarity.UNCOMMON, mage.cards.p.PatrolSignaler.class));
        cards.add(new SetCardInfo("Phosphorescent Feast", 72, Rarity.UNCOMMON, mage.cards.p.PhosphorescentFeast.class));
        cards.add(new SetCardInfo("Primalcrux", 73, Rarity.RARE, mage.cards.p.Primalcrux.class));
        cards.add(new SetCardInfo("Puncture Blast", 60, Rarity.COMMON, mage.cards.p.PunctureBlast.class));
        cards.add(new SetCardInfo("Pyrrhic Revival", 93, Rarity.RARE, mage.cards.p.PyrrhicRevival.class));
        cards.add(new SetCardInfo("Quillspike", 126, Rarity.UNCOMMON, mage.cards.q.Quillspike.class));
        cards.add(new SetCardInfo("Raven's Crime", 41, Rarity.COMMON, mage.cards.r.RavensCrime.class));
        cards.add(new SetCardInfo("Razorfin Abolisher", 28, Rarity.UNCOMMON, mage.cards.r.RazorfinAbolisher.class));
        cards.add(new SetCardInfo("Recumbent Bliss", 13, Rarity.COMMON, mage.cards.r.RecumbentBliss.class));
        cards.add(new SetCardInfo("Regal Force", 74, Rarity.RARE, mage.cards.r.RegalForce.class));
        cards.add(new SetCardInfo("Rekindled Flame", 61, Rarity.RARE, mage.cards.r.RekindledFlame.class));
        cards.add(new SetCardInfo("Rendclaw Trow", 127, Rarity.COMMON, mage.cards.r.RendclawTrow.class));
        cards.add(new SetCardInfo("Restless Apparition", 94, Rarity.UNCOMMON, mage.cards.r.RestlessApparition.class));
        cards.add(new SetCardInfo("Rise of the Hobgoblins", 145, Rarity.RARE, mage.cards.r.RiseOfTheHobgoblins.class));
        cards.add(new SetCardInfo("Riverfall Mimic", 111, Rarity.COMMON, mage.cards.r.RiverfallMimic.class));
        cards.add(new SetCardInfo("Rugged Prairie", 178, Rarity.RARE, mage.cards.r.RuggedPrairie.class));
        cards.add(new SetCardInfo("Sanity Grinding", 29, Rarity.RARE, mage.cards.s.SanityGrinding.class));
        cards.add(new SetCardInfo("Sapling of Colfenor", 128, Rarity.RARE, mage.cards.s.SaplingOfColfenor.class));
        cards.add(new SetCardInfo("Savage Conception", 75, Rarity.UNCOMMON, mage.cards.s.SavageConception.class));
        cards.add(new SetCardInfo("Scarecrone", 172, Rarity.RARE, mage.cards.s.Scarecrone.class));
        cards.add(new SetCardInfo("Scourge of the Nobilis", 146, Rarity.COMMON, mage.cards.s.ScourgeOfTheNobilis.class));
        cards.add(new SetCardInfo("Selkie Hedge-Mage", 158, Rarity.UNCOMMON, mage.cards.s.SelkieHedgeMage.class));
        cards.add(new SetCardInfo("Shell Skulkin", 173, Rarity.COMMON, mage.cards.s.ShellSkulkin.class));
        cards.add(new SetCardInfo("Shorecrasher Mimic", 159, Rarity.COMMON, mage.cards.s.ShorecrasherMimic.class));
        cards.add(new SetCardInfo("Shrewd Hatchling", 112, Rarity.UNCOMMON, mage.cards.s.ShrewdHatchling.class));
        cards.add(new SetCardInfo("Slippery Bogle", 160, Rarity.COMMON, mage.cards.s.SlipperyBogle.class));
        cards.add(new SetCardInfo("Smoldering Butcher", 42, Rarity.COMMON, mage.cards.s.SmolderingButcher.class));
        cards.add(new SetCardInfo("Snakeform", 161, Rarity.COMMON, mage.cards.s.Snakeform.class));
        cards.add(new SetCardInfo("Soot Imp", 43, Rarity.UNCOMMON, mage.cards.s.SootImp.class));
        cards.add(new SetCardInfo("Soul Reap", 44, Rarity.COMMON, mage.cards.s.SoulReap.class));
        cards.add(new SetCardInfo("Soul Snuffers", 45, Rarity.UNCOMMON, mage.cards.s.SoulSnuffers.class));
        cards.add(new SetCardInfo("Spirit of the Hearth", 14, Rarity.RARE, mage.cards.s.SpiritOfTheHearth.class));
        cards.add(new SetCardInfo("Spitemare", 147, Rarity.UNCOMMON, mage.cards.s.Spitemare.class));
        cards.add(new SetCardInfo("Spitting Image", 162, Rarity.RARE, mage.cards.s.SpittingImage.class));
        cards.add(new SetCardInfo("Springjack Pasture", 179, Rarity.RARE, mage.cards.s.SpringjackPasture.class));
        cards.add(new SetCardInfo("Springjack Shepherd", 15, Rarity.UNCOMMON, mage.cards.s.SpringjackShepherd.class));
        cards.add(new SetCardInfo("Stalker Hag", 129, Rarity.UNCOMMON, mage.cards.s.StalkerHag.class));
        cards.add(new SetCardInfo("Stigma Lasher", 62, Rarity.RARE, mage.cards.s.StigmaLasher.class));
        cards.add(new SetCardInfo("Stillmoon Cavalier", 95, Rarity.RARE, mage.cards.s.StillmoonCavalier.class));
        cards.add(new SetCardInfo("Stream Hopper", 113, Rarity.COMMON, mage.cards.s.StreamHopper.class));
        cards.add(new SetCardInfo("Sturdy Hatchling", 163, Rarity.UNCOMMON, mage.cards.s.SturdyHatchling.class));
        cards.add(new SetCardInfo("Suture Spirit", 16, Rarity.UNCOMMON, mage.cards.s.SutureSpirit.class));
        cards.add(new SetCardInfo("Swirling Spriggan", 76, Rarity.UNCOMMON, mage.cards.s.SwirlingSpriggan.class));
        cards.add(new SetCardInfo("Syphon Life", 46, Rarity.UNCOMMON, mage.cards.s.SyphonLife.class));
        cards.add(new SetCardInfo("Talara's Bane", 47, Rarity.COMMON, mage.cards.t.TalarasBane.class));
        cards.add(new SetCardInfo("Talara's Battalion", 77, Rarity.RARE, mage.cards.t.TalarasBattalion.class));
        cards.add(new SetCardInfo("Talonrend", 30, Rarity.UNCOMMON, mage.cards.t.Talonrend.class));
        cards.add(new SetCardInfo("Thunderblust", 63, Rarity.RARE, mage.cards.t.Thunderblust.class));
        cards.add(new SetCardInfo("Tilling Treefolk", 78, Rarity.COMMON, mage.cards.t.TillingTreefolk.class));
        cards.add(new SetCardInfo("Trapjaw Kelpie", 164, Rarity.COMMON, mage.cards.t.TrapjawKelpie.class));
        cards.add(new SetCardInfo("Twilight Mire", 180, Rarity.RARE, mage.cards.t.TwilightMire.class));
        cards.add(new SetCardInfo("Twinblade Slasher", 79, Rarity.UNCOMMON, mage.cards.t.TwinbladeSlasher.class));
        cards.add(new SetCardInfo("Umbra Stalker", 48, Rarity.RARE, mage.cards.u.UmbraStalker.class));
        cards.add(new SetCardInfo("Unmake", 96, Rarity.COMMON, mage.cards.u.Unmake.class));
        cards.add(new SetCardInfo("Unnerving Assault", 114, Rarity.UNCOMMON, mage.cards.u.UnnervingAssault.class));
        cards.add(new SetCardInfo("Unwilling Recruit", 64, Rarity.UNCOMMON, mage.cards.u.UnwillingRecruit.class));
        cards.add(new SetCardInfo("Voracious Hatchling", 97, Rarity.UNCOMMON, mage.cards.v.VoraciousHatchling.class));
        cards.add(new SetCardInfo("Wake Thrasher", 31, Rarity.RARE, mage.cards.w.WakeThrasher.class));
        cards.add(new SetCardInfo("Ward of Bones", 174, Rarity.RARE, mage.cards.w.WardOfBones.class));
        cards.add(new SetCardInfo("Waves of Aggression", 148, Rarity.RARE, mage.cards.w.WavesOfAggression.class));
        cards.add(new SetCardInfo("Wickerbough Elder", 80, Rarity.COMMON, mage.cards.w.WickerboughElder.class));
        cards.add(new SetCardInfo("Wilderness Hypnotist", 32, Rarity.COMMON, mage.cards.w.WildernessHypnotist.class));
        cards.add(new SetCardInfo("Wistful Selkie", 165, Rarity.UNCOMMON, mage.cards.w.WistfulSelkie.class));
        cards.add(new SetCardInfo("Woodlurker Mimic", 130, Rarity.COMMON, mage.cards.w.WoodlurkerMimic.class));
        cards.add(new SetCardInfo("Worm Harvest", 131, Rarity.RARE, mage.cards.w.WormHarvest.class));
    }
}
