/*
 * Copyright 2010 BetaSteward_at_googlemail.com. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *    1. Redistributions of source code must retain the above copyright notice, this list of
 *       conditions and the following disclaimer.
 *
 *    2. Redistributions in binary form must reproduce the above copyright notice, this list
 *       of conditions and the following disclaimer in the documentation and/or other materials
 *       provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY BetaSteward_at_googlemail.com ``AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL BetaSteward_at_googlemail.com OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are those of the
 * authors and should not be interpreted as representing official policies, either expressed
 * or implied, of BetaSteward_at_googlemail.com.
 */
package mage.cards.decks;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 *
 * @author BetaSteward_at_googlemail.com
 */
public class DeckCardLists implements Serializable {

    private String name;
    private String author;
    private List<DeckCardInfo> cards = new ArrayList<>();
    private List<DeckCardInfo> sideboard = new ArrayList<>();

    // Layout (if supported)
    private DeckCardLayout cardLayout = null;
    private DeckCardLayout sideboardLayout = null;

    /**
     * @return The layout of the cards
     */
    public DeckCardLayout getCardLayout() {
        return cardLayout;
    }
    public void setCardLayout(DeckCardLayout layout) {
        this.cardLayout = layout;
    }
    public DeckCardLayout getSideboardLayout() {
        return sideboardLayout;
    }
    public void setSideboardLayout(DeckCardLayout layout) {
        this.sideboardLayout = layout;
    }

    /**
     * @return the cards
     */
    public List<DeckCardInfo> getCards() {
        return cards;
    }

    /**
     * @param cards the cards to set
     */
    public void setCards(List<DeckCardInfo> cards) {
        this.cards = cards;
    }

    /**
     * @return the sideboard
     */
    public List<DeckCardInfo> getSideboard() {
        return sideboard;
    }

    /**
     * @param sideboard the sideboard to set
     */
    public void setSideboard(List<DeckCardInfo> sideboard) {
        this.sideboard = sideboard;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAuthor() {
        return author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}
