# XMage — Magic, Another Game Engine

[![Join the chat at https://gitter.im/magefree/mage](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/magefree/mage?utm_source=badge&utm_medium=badge&utm_campaign=pr-badge&utm_content=badge) [![Build Status](https://travis-ci.org/magefree/mage.svg?branch=master)](https://travis-ci.org/magefree/mage)

XMage allows you to play Magic against one or more online players or computer opponents. It includes full rules enforcement for over **17.200** unique cards (over 33.100 counting all cards from different editions). Starting with *Morningtide*, all regular sets have nearly all the cards implemented. A more detailed information which cards are implemented can be found [here](https://github.com/magefree/mage/wiki/Set-implementation-list).

There are public servers where you can play XMage against other players. You can also host your own server to play against the AI and/or your friends.

XMage community:
* [Official XMage forum](http://www.slightlymagic.net/forum/viewforum.php?f=70);
* [Official XMage support and feature request on github](https://github.com/magefree/mage/issues);
* [Reddit XMage group](https://www.reddit.com/r/XMage/);
* [Reddit XMage discord channel](https://discord.gg/Pqf42yn).

## Features

* Deck editor (load and save decks)
* Simple computer AI opponent
* Two player duel or a multiplayer free-for-all game with up to 10 players
* Supports special formats like Commander (up to 10 players), Cube, Tiny Leaders, Super Standard, Historic Standard
* There are two tournament types supported (elimination or swiss type handling), which can be played with up to 16 players:
    * Booster (also Cube) draft tournaments (4-16)
    * Sealed (also from Cube) tournaments (2-16)

## Issues / bugs

Before you create a new issue, take a look at the [List of things already fixed but not yet released](https://github.com/magefree/mage/wiki/Features-and-fixes-not-released-yet#features-and-fixes-not-released-yet) to avoid creating uneccessary new issues.
Also there is always a bug thread in the [Official XMage forum](http://www.slightlymagic.net/forum/viewforum.php?f=70) which we check regularly.

## Installation

Download and install the [latest XMage release](http://XMage.de).
You will need to have Version 7 or later of the [Java Runtime Environment](http://java.com/en/).

Look [here](http://www.slightlymagic.net/forum/viewtopic.php?f=70&t=13632) for more detailed instructions.
[Here](http://github.com/magefree/mage/wiki/Release-changes) you can find a log of the latest changes.

## Developer

If you are interested in developing XMage, here are some useful resources:

* [Developer Getting Started](http://github.com/magefree/mage/wiki/Developer-Getting-Started)
* [Developer Notes](http://github.com/magefree/mage/wiki/Developer-Notes)
* [Developer Testing Tools](http://github.com/magefree/mage/wiki/Developer-Testing-Tools)
* [Double Faced Cards](http://github.com/magefree/mage/wiki/Double-Faced-Cards)
* [Card Requests](https://www.slightlymagic.net/forum/viewtopic.php?f=70&t=20685)
* [Tournament Relevant Card Requests](http://www.slightlymagic.net/forum/viewtopic.php?f=70&t=14062)
