<div align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" alt="Bookshelf" srcset="./docs/_imgs/banner-dark.png" width="600px">
    <img alt="Bookshelf" src="./docs/_imgs/banner-light.png" width="600px">
  </picture>
</div>

<h2>
<div align="center">
    <a href="https://bookshelf.docs.gunivers.net/en/latest/quickstart.html"><img src="./docs/_imgs/download.svg?v=2" alt="Download" style="height:3rem"></a>
    &nbsp;&nbsp;
    <a href="https://bookshelf.docs.gunivers.net/"><img src="./docs/_imgs/documentation.svg?v=2" alt="Documentation" style="height:3rem"></a>
    &nbsp;&nbsp;
    <a href="https://discord.gg/E8qq6tN"><img src="./docs/_imgs/discord.svg?v=2" alt="Discord" style="height:3rem"></a>
  </div>
</h2>

<br>

# 🕵️‍♂️ What is Bookshelf?

Bookshelf (formerly known as Gunivers Libs) is a user-friendly modular library datapack, crafted to assist mapmakers in effortlessly implementing intricate systems within their maps.

Bookshelf is split into several modules. You can download a zip from the Github packages page with each module zipped with its dependencies to pick the module(s) you need.

## 🛠️ Key features

📄 **Bookshelf Dev:** an optional datapack for development time that includes utilities such as logs and variable dump.

🧮 **Mathematical functions:** sin, cos, exp, log, sqrt...

🖥️ **Bitwise functions:** and, or, xor, not, msb...

🏷️ **ID system:** easily identify entities.

🔗 **Link entities:** link positions and rotations between entities and create coherent structures!

🏃 **Move and vectors:** give customized trajectories to entities, which can bounce on blocks and more...

❤️ **Health management:** easily modify player health!

🧱 **Block management:** get and manipulate blocks (supports BlockStates and NBT)!

<br>
And much more...

# 🔥 Motivation

As developers, we recognize the importance of using libraries to save time and avoid reinventing the wheel. Unfortunately, we've noticed that mapmakers within the Minecraft community are often unfamiliar with this concept.

That's why we started this project, to introduce a variety of reusable tools and try to convince mapmakers to embrace the use of libraries.

While we strive to keep these modules as much optimized and accurate as possible, our main goal is to offer a wide range of features and provide tools that are both easy to use and install. Therefore, we will always prioritize accessibility above everything else.

# 🤝 Contribution

[👉 Please refer to the contribution docs for more information](https://bookshelf.docs.gunivers.net/en/latest/contribute/index.html)

Anyone can contribute to this repository. Please do so by posting issues when you've found something that is unexpected or sending a pull request for improvements. If you have any doubts related to the project or want to discuss something, then join our Discord server.

