import os
import sys

sys.path.append(os.path.join(os.path.dirname(__file__), "_exts/"))

# -- Project information -----------------------------------------------------

project = "Bookshelf"
copyright = "2024, Gunivers"
author = "Gunivers"


# -- General configuration ---------------------------------------------------

extensions = [
  "myst_parser",
  "sphinx_design",
  "sphinx_togglebutton",
  "sphinx_copybutton",
  "bs_treeview",
  "bs_nbt",
]

exclude_patterns = ["_build", "Thumbs.db", ".DS_Store"]
templates_path = ["_templates"]


# -- MyST options ------------------------------------------------------------

myst_heading_anchors = 6
myst_enable_extensions = [
    "amsmath",
    "colon_fence",
    "deflist",
    "dollarmath",
    "fieldlist",
    "html_admonition",
    "html_image",
    "linkify",
    "replacements",
    "smartquotes",
    "strikethrough",
    "substitution",
    "tasklist",
]


# -- Options for HTML output -------------------------------------------------

html_theme = "pydata_sphinx_theme"
html_logo = "_static/logo-bookshelf.png"
html_favicon = "_static/logo-bookshelf.png"

html_static_path = ["_static"]
html_css_files = ["bookshelf.css"]
html_js_files = ["bookshelf.js"]

html_context = {
    "github_user": "Gunivers",
    "github_repo": "Bookshelf",
    "github_version": "master",
    "doc_path": "docs",
}

json_url = "https://bookshelf.docs.gunivers.net/en/master/_static/switcher.json"
version_match = os.environ.get("READTHEDOCS_VERSION")

if not version_match or version_match.isdigit():
    version_match = "latest"

html_sidebars = {
    "CHANGELOG": [],
    "faq": [],
    "index": [],
    "quickstart": [],
    "special-thanks": [],
}

html_theme_options = {
    "navbar_start": ["navbar-logo", "version-switcher"],
    "navbar_persistent": ["search-button"],
    "navigation_with_keys": True,
    "use_edit_page_button": True,
    "header_links_before_dropdown": 4,
    "logo": {
        "text": "Bookshelf",
        "image_dark": "_static/logo-bookshelf.png",
    },
    "switcher": {
        "json_url": json_url,
        "version_match": version_match,
    },
    "icon_links": [
        # {"name": "Download", "url": "https://glib.gunivers.net/", "icon": "fa-solid fa-download"},
        {"name": "GitHub", "url": "https://github.com/Gunivers/Bookshelf", "icon": "fa-brands fa-github"},
        {"name": "Support us", "url": "https://www.helloasso.com/associations/altearn/formulaires/3/en", "icon": "fa-solid fa-heart"},
        {"name": "Discord server", "url": "https://discord.gg/E8qq6tN", "icon": "fa-brands fa-discord"},
        {"name": "Gunivers", "url": "https://gunivers.net", "icon": "_static/logo-gunivers.png", "type": "local"},
    ],
}

if version_match == "master":
    html_theme_options["announcement"] = "⚠️ You are reading a doc of an undergoing development version. Information can be out of date and/or change at any time. ⚠️"
