# 📋 FAQ

## Can I use Bookshelf in my project?

Absolutely! Bookshelf is designed to be used in any project. A mention of Bookshelf and/or Gunivers in a message of thanks is always appreciated. Let's keep the open-source world a respectful place 🤗! Additionally, feel free to share your creations with us to let us know how you use the library (and allow us to provide additional visibility to your project).

## Is it compatible with other datapacks?

Yes! Bookshelf adheres to constraints that ensure compatibility with most datapacks. All Bookshelf scores, tags, and namespaces start with `bs.` and use fake players whenever possible to avoid conflicts.

## Is it resource-heavy?

### 🧠 CPU Usage

As a library is simply a set of tools that you can call upon, it will not impact CPU performance unless actively used. The CPU impact depends on the functions you invoke and their frequency. The documentation provides warnings and performance tips for functions that may be resource-intensive.

### 💾 Memory Usage

Minecraft parses the entire datapack upon loading, so the number of files is inconsequential. Instructions are lightweight in memory, allowing for numerous functions without a significant increase in RAM usage. Furthermore, Bookshelf's modular nature enables you to select only the modules you require.

### 💽 Disk Usage

Bookshelf is compressed into a zip file, making it only a few megabytes in size. If size remains a concern, you can selectively choose the modules you need. Additionally, it's recommended to download Bookshelf from GitHub releases, which provide only essential files, rather than directly from the repository.

## Are the functions optimized?

Bookshelf prioritizes accessibility and versatility. While this may occasionally result in choices that are not the most optimized for a specific context, they align with the library's objectives. Nevertheless, optimization is continually considered, and suggestions and pull requests to enhance Bookshelf are welcomed. If you have ideas for improvement (optimization, accessibility, or otherwise), please share them with us!

## What about copyrights?

Bookshelf is licensed to allow you to use and modify it for personal use and distribute maps or datapacks that use Bookshelf without any issues, as long as you share any modification made to the original source code. For that, we chose the [MPL 2.0](https://github.com/Gunivers/Bookshelf/blob/master/LICENSE) (Mozila Public License 2.0).

```{button-link} https://discord.gg/E8qq6tN
:color: primary
:shadow:
:align: center

More questions? Join us on Discord!
```

---

<div id="gs-comments" align=center>

**💬 Did it help you?**

Feel free to leave your questions and feedbacks below!

</div>
