---
html_theme.sidebar_secondary.remove: true
sd_hide_title: true
---

<div align=center>

# Bookshelf

```{image} /_imgs/banner-light.png
:class: only-light
:width: 600px
```

```{image} /_imgs/banner-dark.png
:class: only-dark
:width: 600px
```

</div>

## 🕵️‍♂️ What is Bookshelf?

Bookshelf (formerly known as Gunivers Libs) is a user-friendly modular library datapack, crafted to assist mapmakers in effortlessly implementing intricate systems within their maps.


::::{grid} 2

:::{grid-item}

```{button-link} quickstart.html
:color: primary
:align: right
:shadow:

🚀 Quickstart!
```

:::
:::{grid-item}

```{button-link} https://www.youtube.com/watch?v=E2nKYEvjETk
:color: primary
:align: left
:outline:

🎬 Watch trailer
```

:::
::::

---

### 🌟 Featured modules

```{include} _templates/featured-modules.md
```

---

## 🔥 Motivation

As developers, we recognize the importance of using libraries to save time and avoid reinventing the wheel. Unfortunately, we've noticed that mapmakers within the Minecraft community are often unfamiliar with this concept.

That's why we started this project, to introduce a variety of reusable tools and try to convice mapmakers to embrace the use of libraries.

While we strive to keep these modules as much optimized and accurate as possible, our main goal is to offer a wide range of features and provide tools that are both easy to use and install. Therefore, we will always prioritize accessibility above everything else.

```{epigraph}
"I have seen further than others because I have stood on the shoulders of giants."

-- Isaac Newton
```

## 🤝 Contribution

If you have any doubts related to the project or want to discuss something, then join [our Discord](https://discord.gg/E8qq6tN) server.

If you want to contribute, please refer to the [contribution docs](https://bookshelf.docs.gunivers.net/en/latest/contribute/index.html) for more information.

```{toctree}
:hidden:
:maxdepth: 1

quickstart
modules
contribute/index
related
CHANGELOG
faq
special-thanks
```
