<div align="center">
  <picture>
    <source media="(prefers-color-scheme: dark)" alt="Bookshelf" srcset="docs/_imgs/banner-dark.png" width="600px">
    <img alt="Bookshelf" src="docs/_imgs/banner-light.png" width="600px">
  </picture>
</div>

<div align="center">
  <a href="https://github.com/mcbookshelf/Bookshelf/stargazers"><img src="https://img.shields.io/github/stars/mcbookshelf/Bookshelf?colorA=363a4f&colorB=b7bdf8&style=for-the-badge&logo=data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCAyNTYgMjU2Ij4KPHBhdGggZD0iTTIzNS4yNCw4NC4zOGwtMjguMDYsMjMuNjgsOC41NiwzNS4zOWExMy4zNCwxMy4zNCwwLDAsMS01LjA5LDEzLjkxLDEzLjU0LDEzLjU0LDAsMCwxLTE1LC42OUwxNjQsMTM5bC0zMS42NSwxOS4wNmExMy41MSwxMy41MSwwLDAsMS0xNS0uNjksMTMuMzIsMTMuMzIsMCwwLDEtNS4xLTEzLjkxbDguNTYtMzUuMzlMOTIuNzYsODQuMzhhMTMuMzksMTMuMzksMCwwLDEsNy42Ni0yMy41OGwzNi45NC0yLjkyLDE0LjIxLTMzLjY2YTEzLjUxLDEzLjUxLDAsMCwxLDI0Ljg2LDBsMTQuMjEsMzMuNjYsMzYuOTQsMi45MmExMy4zOSwxMy4zOSwwLDAsMSw3LjY2LDIzLjU4Wk04OC4xMSwxMTEuODlhOCw4LDAsMCwwLTExLjMyLDBMMTguMzQsMTcwLjM0YTgsOCwwLDAsMCwxMS4zMiwxMS4zMmw1OC40NS01OC40NUE4LDgsMCwwLDAsODguMTEsMTExLjg5Wm0tLjUsNjEuMTlMMzQuMzQsMjI2LjM0YTgsOCwwLDAsMCwxMS4zMiwxMS4zMmw1My4yNi01My4yN2E4LDgsMCwwLDAtMTEuMzEtMTEuMzFabTczLTEtNTQuMjksNTQuMjhhOCw4LDAsMCwwLDExLjMyLDExLjMybDU0LjI4LTU0LjI4YTgsOCwwLDAsMC0xMS4zMS0xMS4zMloiIHN0eWxlPSJmaWxsOiAjQ0FEM0Y1OyIvPgo8L3N2Zz4="></a>
  &nbsp;
  <a href="https://github.com/mcbookshelf/Bookshelf/releases/latest"><img src="https://img.shields.io/github/v/release/mcbookshelf/Bookshelf?colorA=363a4f&colorB=a6da95&style=for-the-badge&logo=github&logoColor=cad3f5"></a>
  &nbsp;
  <a href="https://discord.gg/MkXytNjmBt"><img src="https://img.shields.io/discord/1247513995376726116?style=for-the-badge&color=%237289DA&labelColor=363a4f&logo=discord&logoColor=cad3f5"></a>
</div>

<br/>
<br/>


# 🕵️‍♂️ What is Bookshelf?

Bookshelf (formerly known as Gunivers Libs) is a modular library datapack designed to simplify complex systems in Minecraft maps. Ideal for mapmakers looking for easy-to-implement tools.

<div align="center">
    <a href="https://docs.mcbookshelf.dev/en/latest/quickstart.html">
      <picture>
        <source alt="quickstart" srcset="docs/_imgs/readme/quickstart.svg" width="140px">
        <img alt="quickstart" src="docs/_imgs/readme/quickstart.svg" width="140px">
      </picture>
    </a>
    &nbsp;
    <a href="https://www.youtube.com/watch?v=E2nKYEvjETk">
      <picture>
        <source alt="watch-trailer" srcset="docs/_imgs/readme/watch-trailer.svg" width="140px">
        <img alt="watch-trailer" src="docs/_imgs/readme/watch-trailer.svg" width="140px">
      </picture>
    </a>
</div>


# 🌟 Featured Modules

<div align="center">
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="block" srcset="docs/_imgs/readme/block-dark.svg">
        <img alt="block" src="docs/_imgs/readme/block.svg">
    </picture>
  &nbsp;
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="raycast" srcset="docs/_imgs/readme/raycast-dark.svg">
        <img alt="raycast" src="docs/_imgs/readme/raycast.svg">
    </picture>
  &nbsp;
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="math" srcset="docs/_imgs/readme/math-dark.svg">
        <img alt="math" src="docs/_imgs/readme/math.svg">
    </picture>
  &nbsp;
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="generate" srcset="docs/_imgs/readme/generate-dark.svg">
        <img alt="generate" src="docs/_imgs/readme/generate.svg">
    </picture>
  &nbsp;
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="random" srcset="docs/_imgs/readme/random-dark.svg">
        <img alt="random" src="docs/_imgs/readme/random.svg">
    </picture>
  &nbsp;
    <picture>
        <source media="(prefers-color-scheme: dark)" alt="health" srcset="docs/_imgs/readme/health-dark.svg">
        <img alt="health" src="docs/_imgs/readme/health.svg">
    </picture>
</div>

<div align="center">
    <p>And much more!</p>
</div>


# 🔥 Motivation

As developers, we understand the value of libraries: they save time, streamline workflows, and eliminate the need to reinvent the wheel. However, we’ve noticed that many mapmakers in the Minecraft community are less familiar with this concept.

That’s why we started this project, to provide a variety of reusable tools and encourage mapmakers to embrace the use of libraries.

While we strive to keep our modules as optimized as possible, our top priority is accessibility. We focus on creating features that are easy to use and simple to install, ensuring they’re practical for everyone.

> “I have seen further than others because I have stood on the shoulders of giants.”
> 
> -- Isaac Newton


# 🤝 Contribution

If you have any doubts related to the project or want to discuss something, join [our Discord](https://discord.gg/MkXytNjmBt) server.

If you want to contribute, please refer to the [contribution docs](https://docs.mcbookshelf.dev/en/latest/contribute/index.html) for more information.
