## 📦 [Bookshelf - 3.0.0](https://github.com/mcbookshelf/Bookshelf/releases/tag/v3.0.0)

> **🚂 The Pipeline Update!**
>
> *This release overhauls the project structure with Beet, focusing on modularity and isolation of each module. It also introduces a new version loader that resolves conflicts between multiple versions.*
>
> **⚠️ BREAKING CHANGES**: This new version has a few breaking changes!

- <abbr title="Breaking Changes">⚠️</abbr> **[#281](https://github.com/mcbookshelf/Bookshelf/issues/281)** - Merged the `bs.biome` and `bs.weather` modules into a single `bs.environment` module.
- <abbr title="New Modules">🎉</abbr> **[#272](https://github.com/mcbookshelf/Bookshelf/issues/272)** - Added a new automatically generated `bs.load` module, eliminating the need to manually create `load` and `unload` tags for each module. Bookshelf now also uses **LanternLoad** to load its modules.
- <abbr title="Enhancements">⚡</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Simplified testing by automating batch specification and removing the need for a `__boot__` function.
- <abbr title="Enhancements">⚡</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Removed the need to create a `__help__` function and `help` tag. These are now automatically generated.
- <abbr title="Documentation">📝</abbr> **[#280](https://github.com/mcbookshelf/Bookshelf/issues/280)** - Migrated the documentation to **mcbookshelf.dev** for improved accessibility and organization.
- <abbr title="Documentation">📝</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Reworked the contribute documentation to reflect all changes and added a new **Getting Started** page.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#277](https://github.com/mcbookshelf/Bookshelf/issues/277)** - Created a GitHub organization for the Bookshelf project.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#278](https://github.com/mcbookshelf/Bookshelf/issues/278)** - Rewrote scripts and modules to use **Beet**, removing the Jupyter Notebook.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Reworked metadata to a new format.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Modules now require a `README.md` and a `pack.png`.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Updated GitHub with new issue templates and a code of conduct.
- <abbr title="GitHub & CI/CD">⚙️</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Added new workflows with automatic deployment to **Modrinth** and **Smithed**.


### `🧱 bs.block`

- <abbr title="New Features">✨</abbr> **[#279](https://github.com/mcbookshelf/Bookshelf/issues/279)** - Added a `#bs.block:play_block_sound` tag for playing block sounds.


### `🎯 bs.hitbox`

- <abbr title="Breaking Changes">⚠️</abbr> **[#297](https://github.com/mcbookshelf/Bookshelf/issues/297)** - Renamed block tag `is_composite` to `not_full_cube` for better clarity.
- <abbr title="New Features">✨</abbr> **[#285](https://github.com/mcbookshelf/Bookshelf/pull/285)** - Introduced a `#bs.hitbox:is_sized` tag for improved hitbox management.
- <abbr title="New Features">✨</abbr> **[#299](https://github.com/mcbookshelf/Bookshelf/pull/299)** - Block tag `#bs.hitbox:can_pass_through` was moved from the move module and is now properly documented.

### `📰 bs.sidebar`

- <abbr title="Bug fix">🐛</abbr> **[#301](https://github.com/mcbookshelf/Bookshelf/pull/301)** Fixed the issue where `bs.sidebar:create` was not functioning correctly.

### `👀 bs.view`

- <abbr title="New Features">✨</abbr> **[#299](https://github.com/mcbookshelf/Bookshelf/pull/299)** - Block tag `#bs.view:can_see_through` is now properly documented.
