---
html_theme.sidebar_secondary.remove: true
sd_hide_title: true
---

<div align=center>

# Bookshelf

```{image} /_imgs/banner-light.png
:class: only-light
:width: 600px
```

```{image} /_imgs/banner-dark.png
:class: only-dark
:width: 600px
```

</div>

## 🕵️‍♂️ What is Bookshelf?

Bookshelf (formerly known as Gunivers Libs) is a modular library datapack designed to simplify complex systems in Minecraft maps. Ideal for mapmakers looking for easy-to-implement tools.


::::{grid} 2

:::{grid-item}

```{button-link} quickstart.html
:color: primary
:align: right
:shadow:

🚀 Quickstart!
```

:::
:::{grid-item}

```{button-link} https://www.youtube.com/watch?v=E2nKYEvjETk
:color: primary
:align: left
:outline:

🎬 Watch trailer
```

:::
::::

---

### 🌟 Featured Modules

```{include} _templates/featured-modules.md
```

---

## 🔥 Motivation

As developers, we understand the value of libraries: they save time, streamline workflows, and eliminate the need to reinvent the wheel. However, we’ve noticed that many mapmakers in the Minecraft community are less familiar with this concept.

That’s why we started this project, to provide a variety of reusable tools and encourage mapmakers to embrace the use of libraries.

While we strive to keep our modules as optimized as possible, our top priority is accessibility. We focus on creating features that are easy to use and simple to install, ensuring they’re practical for everyone.

```{epigraph}
"I have seen further than others because I have stood on the shoulders of giants."

-- Isaac Newton
```

## 🤝 Contribution

If you have any doubts related to the project or want to discuss something, join [our Discord](https://discord.gg/MkXytNjmBt) server.

If you want to contribute, please refer to the [contribution docs](https://docs.mcbookshelf.dev/en/latest/contribute/index.html) for more information.

```{toctree}
:hidden:
:maxdepth: 1

quickstart
modules
contribute/index
related
CHANGELOG
faq
special-thanks
```
