package travelerelectro

import (
	"github.com/genshinsim/gcsim/pkg/core"
)

func (c *char) collectAmulets(f int, collector core.Character) bool {
	// if there are no amulets to collect, return
	if c.abundanceAmulets <= 0 {
		return false
	}

	// Assume all available amulets are collected simultaneously

	mER := make([]float64, core.EndStatType)

	mER[core.ER] = 0.20

	// handle a4 - Increases the Energy Recharge effect granted by Lightning Blade's Abundance Amulet by 10% of the
	//	 Traveler's Energy Recharge.
	//   This effect only takes into account the Traveler's original Energy Recharge.
	//   Picking up an Amulet to increase the Traveler's ER will not impact the amount of ER shared by
	//   Resounding Roar for other Amulet pickups.
	//   TODO how do we pull unbuffed energy recharge %? Store on init?
	mER[core.ER] += c.Stats[core.ER] * .1

	// apply flat energy
	buffEnergy := skillRegen[c.Talents.Skill] * float64(c.abundanceAmulets)

	// c4 - When a character obtains Abundance Amulets generated by Lightning Blade, if this character's Energy
	//   is less than 35%, the Energy restored by the Abundance Amulets is increased by 100%.
	buffEnergy = c.c4(buffEnergy)

	collector.AddEnergy("abundance-amulet", buffEnergy)

	// handle a1 - When another nearby character in the party obtains an Abundance Amulet created by Lightning Blade,
	//   Lightning Blade's CD is decreased by 1.5s.
	if collector.CharIndex() != c.Index {
		c.ReduceActionCooldown(core.ActionSkill, 90*c.abundanceAmulets)
	}

	// apply ER mod
	modDuration := 360 // 6s
	collector.AddMod(core.CharStatMod{
		Key:    "abundance-amulet",
		Expiry: f + modDuration,
		Amount: func() ([]float64, bool) {
			return mER, true
		},
	})

	// Reset amulets
	c.abundanceAmulets = 0

	return true
}
