package curves

import (
	"github.com/genshinsim/gcsim/pkg/core"
)

var CharBaseMap = map[core.CharKey]CharBase{
	core.TravelerMale: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      911.791015625,
		BaseAtk:     17.808000564575195,
		BaseDef:     57.224998474121094,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       681.154541015625,
				Atk:      13.303799629211426,
				Def:      42.75,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1165.1328125,
				Atk:      22.756500244140625,
				Def:      73.125,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1810.4371337890625,
				Atk:      35.36009979248047,
				Def:      113.625,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2294.415283203125,
				Atk:      44.812801361083984,
				Def:      144,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2778.3935546875,
				Atk:      54.265499114990234,
				Def:      174.375,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3262.371826171875,
				Atk:      63.71820068359375,
				Def:      204.75,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Albedo: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1029.5855712890625,
		BaseAtk:     19.551000595092773,
		BaseDef:     68.2061996459961,
		Specialized: core.GeoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       882.7765502929688,
				Atk:      16.76198959350586,
				Def:      58.481998443603516,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1510.0125732421875,
				Atk:      28.671825408935547,
				Def:      100.03500366210938,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       2346.3271484375,
				Atk:      44.551605224609375,
				Def:      155.43899536132812,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       2973.563232421875,
				Atk:      56.46144104003906,
				Def:      196.99200439453125,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       3600.799072265625,
				Atk:      68.37127685546875,
				Def:      238.5449981689453,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       4228.03515625,
				Atk:      80.28111267089844,
				Def:      280.0979919433594,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Aloy: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      848.4547729492188,
		BaseAtk:     18.210359573364258,
		BaseDef:     52.65039825439453,
		Specialized: core.CryoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       727.4732666015625,
				Atk:      15.612595558166504,
				Def:      45.14400100708008,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1244.3621826171875,
				Atk:      26.70575714111328,
				Def:      77.22000122070312,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       1933.54736328125,
				Atk:      41.496639251708984,
				Def:      119.98799896240234,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       2450.436279296875,
				Atk:      52.58979797363281,
				Def:      152.06399536132812,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       2967.3251953125,
				Atk:      63.682960510253906,
				Def:      184.13999938964844,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       3484.214111328125,
				Atk:      74.776123046875,
				Def:      216.21600341796875,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Amber: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      793.2581787109375,
		BaseAtk:     18.698400497436523,
		BaseDef:     50.358001708984375,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       592.6044921875,
				Atk:      13.968990325927734,
				Def:      37.619998931884766,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1013.66552734375,
				Atk:      23.894325256347656,
				Def:      64.3499984741211,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1575.080322265625,
				Atk:      37.12810516357422,
				Def:      99.98999786376953,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       1996.141357421875,
				Atk:      47.05344009399414,
				Def:      126.72000122070312,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2417.202392578125,
				Atk:      56.97877502441406,
				Def:      153.4499969482422,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2838.263427734375,
				Atk:      66.90411376953125,
				Def:      180.17999267578125,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Itto: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1000.9860229492188,
		BaseAtk:     17.68899917602539,
		BaseDef:     74.66783905029297,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       858.2550048828125,
				Atk:      15.165610313415527,
				Def:      64.02239990234375,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1468.0677490234375,
				Atk:      25.94117546081543,
				Def:      109.51200103759766,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       2281.1513671875,
				Atk:      40.30859375,
				Def:      170.164794921875,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       2890.964111328125,
				Atk:      51.08415985107422,
				Def:      215.65440368652344,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       3500.77685546875,
				Atk:      61.85972595214844,
				Def:      261.1440124511719,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       4110.58984375,
				Atk:      72.63529205322266,
				Def:      306.63360595703125,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Barbara: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      820.6118774414062,
		BaseAtk:     13.355999946594238,
		BaseDef:     56.080501556396484,
		Specialized: core.HPP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       613.0391235351562,
				Atk:      9.977849960327148,
				Def:      41.89500045776367,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1048.6195068359375,
				Atk:      17.06737518310547,
				Def:      71.6624984741211,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1629.3934326171875,
				Atk:      26.52007484436035,
				Def:      111.35250091552734,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2064.973876953125,
				Atk:      33.60960006713867,
				Def:      141.1199951171875,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2500.55419921875,
				Atk:      40.69912338256836,
				Def:      170.8874969482422,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2936.134765625,
				Atk:      47.78865051269531,
				Def:      200.65499877929688,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Beidou: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      1094.149169921875,
		BaseAtk:     18.876480102539062,
		BaseDef:     54.36375045776367,
		Specialized: core.ElectroP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       817.385498046875,
				Atk:      14.102027893066406,
				Def:      40.61249923706055,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1398.1593017578125,
				Atk:      24.121889114379883,
				Def:      69.46875,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       2172.524658203125,
				Atk:      37.48170471191406,
				Def:      107.9437484741211,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2753.29833984375,
				Atk:      47.50156784057617,
				Def:      136.8000030517578,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       3334.072265625,
				Atk:      57.52143096923828,
				Def:      165.65625,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3914.84619140625,
				Atk:      67.54129028320312,
				Def:      194.5124969482422,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Bennett: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      1039.4417724609375,
		BaseAtk:     16.02720069885254,
		BaseDef:     64.66425323486328,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       776.5161743164062,
				Atk:      11.973420143127441,
				Def:      48.307498931884766,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1328.2513427734375,
				Atk:      20.480850219726562,
				Def:      82.6312484741211,
				Special:  0.06669999659061432,
			},
			{
				MaxLevel: 60,
				HP:       2063.8984375,
				Atk:      31.82408905029297,
				Def:      128.39625549316406,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 70,
				HP:       2615.633544921875,
				Atk:      40.331520080566406,
				Def:      162.72000122070312,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 80,
				HP:       3167.36865234375,
				Atk:      48.838951110839844,
				Def:      197.0437469482422,
				Special:  0.20000000298023224,
			},
			{
				MaxLevel: 90,
				HP:       3719.10400390625,
				Atk:      57.346378326416016,
				Def:      231.36749267578125,
				Special:  0.26669999957084656,
			},
		},
	},
	core.Chongyun: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      920.908935546875,
		BaseAtk:     18.698400497436523,
		BaseDef:     54.36375045776367,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       687.9661254882812,
				Atk:      13.968990325927734,
				Def:      40.61249923706055,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1176.7841796875,
				Atk:      23.894325256347656,
				Def:      69.46875,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1828.54150390625,
				Atk:      37.12810516357422,
				Def:      107.9437484741211,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2317.359619140625,
				Atk:      47.05344009399414,
				Def:      136.8000030517578,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2806.177490234375,
				Atk:      56.97877502441406,
				Def:      165.65625,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3294.99560546875,
				Atk:      66.90411376953125,
				Def:      194.5124969482422,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Diluc: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1010.5192260742188,
		BaseAtk:     26.06800079345703,
		BaseDef:     61.0265998840332,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       866.4288330078125,
				Atk:      22.349319458007812,
				Def:      52.32600021362305,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1482.04931640625,
				Atk:      38.22909927368164,
				Def:      89.50499725341797,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       2302.876708984375,
				Atk:      59.40214157104492,
				Def:      139.07699584960938,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       2918.4970703125,
				Atk:      75.28192138671875,
				Def:      176.25599670410156,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       3534.11767578125,
				Atk:      91.16169738769531,
				Def:      213.43499755859375,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       4149.73828125,
				Atk:      107.0414810180664,
				Def:      250.61399841308594,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Diona: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      802.3760986328125,
		BaseAtk:     17.808000564575195,
		BaseDef:     50.358001708984375,
		Specialized: core.CryoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       599.416015625,
				Atk:      13.303799629211426,
				Def:      37.619998931884766,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1025.31689453125,
				Atk:      22.756500244140625,
				Def:      64.3499984741211,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1593.1846923828125,
				Atk:      35.36009979248047,
				Def:      99.98999786376953,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2019.08544921875,
				Atk:      44.812801361083984,
				Def:      126.72000122070312,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2444.986328125,
				Atk:      54.265499114990234,
				Def:      153.4499969482422,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2870.88720703125,
				Atk:      63.71820068359375,
				Def:      180.17999267578125,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Eula: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1029.5855712890625,
		BaseAtk:     26.62660026550293,
		BaseDef:     58.45391082763672,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       882.7765502929688,
				Atk:      22.82823371887207,
				Def:      50.12009811401367,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1510.0125732421875,
				Atk:      39.04829406738281,
				Def:      85.73175048828125,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       2346.3271484375,
				Atk:      60.67504119873047,
				Def:      133.2139434814453,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       2973.563232421875,
				Atk:      76.89510345458984,
				Def:      168.8256072998047,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       3600.799072265625,
				Atk:      93.11516571044922,
				Def:      204.437255859375,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       4228.03515625,
				Atk:      109.3352279663086,
				Def:      240.0489044189453,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Fischl: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      770.46337890625,
		BaseAtk:     20.47920036315918,
		BaseDef:     49.78575134277344,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       575.5756225585938,
				Atk:      15.299369812011719,
				Def:      37.192501068115234,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       984.5372314453125,
				Atk:      26.16997528076172,
				Def:      63.618751525878906,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1529.8193359375,
				Atk:      40.66411590576172,
				Def:      98.85375213623047,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       1938.781005859375,
				Atk:      51.53472137451172,
				Def:      125.27999877929688,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2347.74267578125,
				Atk:      62.40532684326172,
				Def:      151.7062530517578,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2756.7041015625,
				Atk:      73.27593231201172,
				Def:      178.13250732421875,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Ganyu: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      762.656005859375,
		BaseAtk:     26.06800079345703,
		BaseDef:     49.06060028076172,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       653.9085693359375,
				Atk:      22.349319458007812,
				Def:      42.066001892089844,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1118.52783203125,
				Atk:      38.22909927368164,
				Def:      71.95500183105469,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       1738.0201416015625,
				Atk:      59.40214157104492,
				Def:      111.80699920654297,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       2202.639404296875,
				Atk:      75.28192138671875,
				Def:      141.6959991455078,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       2667.258544921875,
				Atk:      91.16169738769531,
				Def:      171.5850067138672,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       3131.8779296875,
				Atk:      107.0414810180664,
				Def:      201.4739990234375,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Gorou: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      802.3760986328125,
		BaseAtk:     15.31488037109375,
		BaseDef:     54.36375045776367,
		Specialized: core.GeoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       599.416015625,
				Atk:      11.441267967224121,
				Def:      40.61249923706055,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1025.31689453125,
				Atk:      19.570589065551758,
				Def:      69.46875,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1593.1846923828125,
				Atk:      30.409685134887695,
				Def:      107.9437484741211,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2019.0855712890625,
				Atk:      38.53900909423828,
				Def:      136.8000030517578,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2444.986328125,
				Atk:      46.668331146240234,
				Def:      165.65625,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2870.88720703125,
				Atk:      54.79765319824219,
				Def:      194.5124969482422,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Hutao: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1210.7164306640625,
		BaseAtk:     8.285900115966797,
		BaseDef:     68.2061996459961,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       1038.079833984375,
				Atk:      7.103890895843506,
				Def:      58.481998443603516,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1775.662841796875,
				Atk:      12.151392936706543,
				Def:      100.03500366210938,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       2759.10693359375,
				Atk:      18.881393432617188,
				Def:      155.43899536132812,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       3496.68994140625,
				Atk:      23.928895950317383,
				Def:      196.99200439453125,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       4234.27294921875,
				Atk:      28.976398468017578,
				Def:      238.5449981689453,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       4971.85595703125,
				Atk:      34.02389907836914,
				Def:      280.0979919433594,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Jean: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1143.9840087890625,
		BaseAtk:     18.6200008392334,
		BaseDef:     59.83000183105469,
		Specialized: core.Heal,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       980.8628540039062,
				Atk:      15.963800430297852,
				Def:      51.29999923706055,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1677.791748046875,
				Atk:      27.306499481201172,
				Def:      87.75,
				Special:  0.055399999022483826,
			},
			{
				MaxLevel: 60,
				HP:       2607.0302734375,
				Atk:      42.43009948730469,
				Def:      136.35000610351562,
				Special:  0.11079999804496765,
			},
			{
				MaxLevel: 70,
				HP:       3303.958984375,
				Atk:      53.77280044555664,
				Def:      172.8000030517578,
				Special:  0.11079999804496765,
			},
			{
				MaxLevel: 80,
				HP:       4000.887939453125,
				Atk:      65.1155014038086,
				Def:      209.25,
				Special:  0.16619999706745148,
			},
			{
				MaxLevel: 90,
				HP:       4697.81689453125,
				Atk:      76.45819854736328,
				Def:      245.6999969482422,
				Special:  0.2214999943971634,
			},
		},
	},
	core.Kazuha: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1039.1187744140625,
		BaseAtk:     23.08880043029785,
		BaseDef:     62.82149887084961,
		Specialized: core.EM,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       890.950439453125,
				Atk:      19.79511260986328,
				Def:      53.8650016784668,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1523.994140625,
				Atk:      33.86006164550781,
				Def:      92.13749694824219,
				Special:  28.799999237060547,
			},
			{
				MaxLevel: 60,
				HP:       2368.052490234375,
				Atk:      52.61332321166992,
				Def:      143.16749572753906,
				Special:  57.599998474121094,
			},
			{
				MaxLevel: 70,
				HP:       3001.09619140625,
				Atk:      66.67826843261719,
				Def:      181.44000244140625,
				Special:  57.599998474121094,
			},
			{
				MaxLevel: 80,
				HP:       3634.139892578125,
				Atk:      80.74321746826172,
				Def:      219.71249389648438,
				Special:  86.4000015258789,
			},
			{
				MaxLevel: 90,
				HP:       4267.18359375,
				Atk:      94.80816650390625,
				Def:      257.9849853515625,
				Special:  115.19999694824219,
			},
		},
	},
	core.Kaeya: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      975.6163940429688,
		BaseAtk:     18.698400497436523,
		BaseDef:     66.38099670410156,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       728.8353881835938,
				Atk:      13.968990325927734,
				Def:      49.59000015258789,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1246.692138671875,
				Atk:      23.894325256347656,
				Def:      84.82499694824219,
				Special:  0.06669999659061432,
			},
			{
				MaxLevel: 60,
				HP:       1937.167724609375,
				Atk:      37.12810516357422,
				Def:      131.80499267578125,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 70,
				HP:       2455.0244140625,
				Atk:      47.05344009399414,
				Def:      167.0399932861328,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 80,
				HP:       2972.881103515625,
				Atk:      56.97877502441406,
				Def:      202.27499389648438,
				Special:  0.20000000298023224,
			},
			{
				MaxLevel: 90,
				HP:       3490.73779296875,
				Atk:      66.90411376953125,
				Def:      237.50999450683594,
				Special:  0.26669999957084656,
			},
		},
	},
	core.Ayaka: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1000.9860229492188,
		BaseAtk:     26.62660026550293,
		BaseDef:     61.0265998840332,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       858.2550048828125,
				Atk:      22.82823371887207,
				Def:      52.32600021362305,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1468.0677490234375,
				Atk:      39.04829406738281,
				Def:      89.50499725341797,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       2281.1513671875,
				Atk:      60.67504119873047,
				Def:      139.07699584960938,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       2890.964111328125,
				Atk:      76.89510345458984,
				Def:      176.25599670410156,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       3500.77685546875,
				Atk:      93.11516571044922,
				Def:      213.43499755859375,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       4110.58984375,
				Atk:      109.3352279663086,
				Def:      250.61399841308594,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Ayato: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1067.7183837890625,
		BaseAtk:     23.274999618530273,
		BaseDef:     59.83000183105469,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       915.4719848632812,
				Atk:      19.954750061035156,
				Def:      51.29999923706055,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1565.93896484375,
				Atk:      34.13312530517578,
				Def:      87.75,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       2433.228271484375,
				Atk:      53.03762435913086,
				Def:      136.35000610351562,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       3083.695068359375,
				Atk:      67.21600341796875,
				Def:      172.8000030517578,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       3734.162109375,
				Atk:      81.39437866210938,
				Def:      209.25,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       4384.62890625,
				Atk:      95.57274627685547,
				Def:      245.6999969482422,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Keqing: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1020.0524291992188,
		BaseAtk:     25.136999130249023,
		BaseDef:     62.223201751708984,
		Specialized: core.CD,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       874.6027221679688,
				Atk:      21.551130294799805,
				Def:      53.35200119018555,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1496.0308837890625,
				Atk:      36.863773345947266,
				Def:      91.26000213623047,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 60,
				HP:       2324.601806640625,
				Atk:      57.280635833740234,
				Def:      141.8040008544922,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 70,
				HP:       2946.030029296875,
				Atk:      72.59327697753906,
				Def:      179.71200561523438,
				Special:  0.19200000166893005,
			},
			{
				MaxLevel: 80,
				HP:       3567.45849609375,
				Atk:      87.90592193603516,
				Def:      217.6199951171875,
				Special:  0.2879999876022339,
			},
			{
				MaxLevel: 90,
				HP:       4188.88671875,
				Atk:      103.21856689453125,
				Def:      255.5279998779297,
				Special:  0.3840000033378601,
			},
		},
	},
	core.Klee: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      800.788818359375,
		BaseAtk:     24.20599937438965,
		BaseDef:     47.86399841308594,
		Specialized: core.PyroP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       686.60400390625,
				Atk:      20.752939224243164,
				Def:      41.040000915527344,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1174.4542236328125,
				Atk:      35.498451232910156,
				Def:      70.19999694824219,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       1824.921142578125,
				Atk:      55.15913009643555,
				Def:      109.08000183105469,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       2312.771240234375,
				Atk:      69.9046401977539,
				Def:      138.24000549316406,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       2800.62158203125,
				Atk:      84.650146484375,
				Def:      167.39999389648438,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       3288.4716796875,
				Atk:      99.39566040039062,
				Def:      196.55999755859375,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Sara: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      802.3760986328125,
		BaseAtk:     16.383359909057617,
		BaseDef:     52.64699935913086,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       599.416015625,
				Atk:      12.239496231079102,
				Def:      39.33000183105469,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1025.31689453125,
				Atk:      20.93597984313965,
				Def:      67.2750015258789,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1593.1846923828125,
				Atk:      32.53129196166992,
				Def:      104.53500366210938,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2019.0855712890625,
				Atk:      41.22777557373047,
				Def:      132.47999572753906,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2444.986328125,
				Atk:      49.924259185791016,
				Def:      160.4250030517578,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2870.88720703125,
				Atk:      58.62074279785156,
				Def:      188.3699951171875,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Lisa: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      802.3760986328125,
		BaseAtk:     19.410720825195312,
		BaseDef:     48.069000244140625,
		Specialized: core.EM,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       599.416015625,
				Atk:      14.501141548156738,
				Def:      35.90999984741211,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1025.31689453125,
				Atk:      24.804584503173828,
				Def:      61.42499923706055,
				Special:  24,
			},
			{
				MaxLevel: 60,
				HP:       1593.1846923828125,
				Atk:      38.54250717163086,
				Def:      95.44499969482422,
				Special:  48,
			},
			{
				MaxLevel: 70,
				HP:       2019.0855712890625,
				Atk:      48.845951080322266,
				Def:      120.95999908447266,
				Special:  48,
			},
			{
				MaxLevel: 80,
				HP:       2444.986328125,
				Atk:      59.14939498901367,
				Def:      146.47500610351562,
				Special:  72,
			},
			{
				MaxLevel: 90,
				HP:       2870.88720703125,
				Atk:      69.45283508300781,
				Def:      171.99000549316406,
				Special:  96,
			},
		},
	},
	core.TravelerFemale: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      911.791015625,
		BaseAtk:     17.808000564575195,
		BaseDef:     57.224998474121094,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       681.154541015625,
				Atk:      13.303799629211426,
				Def:      42.75,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1165.1328125,
				Atk:      22.756500244140625,
				Def:      73.125,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1810.4371337890625,
				Atk:      35.36009979248047,
				Def:      113.625,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2294.415283203125,
				Atk:      44.812801361083984,
				Def:      144,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2778.3935546875,
				Atk:      54.265499114990234,
				Def:      174.375,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3262.371826171875,
				Atk:      63.71820068359375,
				Def:      204.75,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Mona: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      810.322021484375,
		BaseAtk:     22.3439998626709,
		BaseDef:     50.855499267578125,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       694.77783203125,
				Atk:      19.15656089782715,
				Def:      43.60499954223633,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1188.435791015625,
				Atk:      32.767799377441406,
				Def:      74.5875015258789,
				Special:  0.07999999821186066,
			},
			{
				MaxLevel: 60,
				HP:       1846.6463623046875,
				Atk:      50.91611862182617,
				Def:      115.89749908447266,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 70,
				HP:       2340.30419921875,
				Atk:      64.52735900878906,
				Def:      146.8800048828125,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 80,
				HP:       2833.962158203125,
				Atk:      78.13860321044922,
				Def:      177.8625030517578,
				Special:  0.23999999463558197,
			},
			{
				MaxLevel: 90,
				HP:       3327.6201171875,
				Atk:      91.74983978271484,
				Def:      208.84500122070312,
				Special:  0.3199999928474426,
			},
		},
	},
	core.Ningguang: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      820.6118774414062,
		BaseAtk:     17.808000564575195,
		BaseDef:     48.069000244140625,
		Specialized: core.GeoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       613.0391235351562,
				Atk:      13.303799629211426,
				Def:      35.90999984741211,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1048.6195068359375,
				Atk:      22.756500244140625,
				Def:      61.42499923706055,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1629.3934326171875,
				Atk:      35.36009979248047,
				Def:      95.44499969482422,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2064.973876953125,
				Atk:      44.812801361083984,
				Def:      120.95999908447266,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2500.55419921875,
				Atk:      54.265499114990234,
				Def:      146.47500610351562,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2936.134765625,
				Atk:      63.71820068359375,
				Def:      171.99000549316406,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Noelle: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      1012.0880126953125,
		BaseAtk:     16.02720069885254,
		BaseDef:     66.9532470703125,
		Specialized: core.DEFP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       756.08154296875,
				Atk:      11.973420143127441,
				Def:      50.01750183105469,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1293.29736328125,
				Atk:      20.480850219726562,
				Def:      85.5562515258789,
				Special:  0.07500000298023224,
			},
			{
				MaxLevel: 60,
				HP:       2009.585205078125,
				Atk:      31.82408905029297,
				Def:      132.94125366210938,
				Special:  0.15000000596046448,
			},
			{
				MaxLevel: 70,
				HP:       2546.801025390625,
				Atk:      40.331520080566406,
				Def:      168.47999572753906,
				Special:  0.15000000596046448,
			},
			{
				MaxLevel: 80,
				HP:       3084.016845703125,
				Atk:      48.838951110839844,
				Def:      204.0187530517578,
				Special:  0.22499999403953552,
			},
			{
				MaxLevel: 90,
				HP:       3621.232666015625,
				Atk:      57.346378326416016,
				Def:      239.5574951171875,
				Special:  0.30000001192092896,
			},
		},
	},
	core.Qiqi: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      962.8532104492188,
		BaseAtk:     22.3439998626709,
		BaseDef:     71.7959976196289,
		Specialized: core.Heal,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       825.5595703125,
				Atk:      19.15656089782715,
				Def:      61.560001373291016,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1412.141357421875,
				Atk:      32.767799377441406,
				Def:      105.30000305175781,
				Special:  0.055399999022483826,
			},
			{
				MaxLevel: 60,
				HP:       2194.25048828125,
				Atk:      50.91611862182617,
				Def:      163.6199951171875,
				Special:  0.11079999804496765,
			},
			{
				MaxLevel: 70,
				HP:       2780.832275390625,
				Atk:      64.52735900878906,
				Def:      207.36000061035156,
				Special:  0.11079999804496765,
			},
			{
				MaxLevel: 80,
				HP:       3367.4140625,
				Atk:      78.13860321044922,
				Def:      251.10000610351562,
				Special:  0.16619999706745148,
			},
			{
				MaxLevel: 90,
				HP:       3953.995849609375,
				Atk:      91.74983978271484,
				Def:      294.8399963378906,
				Special:  0.2214999943971634,
			},
		},
	},
	core.Raiden: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1004.7992553710938,
		BaseAtk:     26.254199981689453,
		BaseDef:     61.445411682128906,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       861.5245361328125,
				Atk:      22.50895881652832,
				Def:      52.68510055541992,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1473.660400390625,
				Atk:      38.502166748046875,
				Def:      90.11924743652344,
				Special:  0.07999999821186066,
			},
			{
				MaxLevel: 60,
				HP:       2289.841552734375,
				Atk:      59.82644271850586,
				Def:      140.0314483642578,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 70,
				HP:       2901.977294921875,
				Atk:      75.81964874267578,
				Def:      177.46560668945312,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 80,
				HP:       3514.11328125,
				Atk:      91.81285858154297,
				Def:      214.89974975585938,
				Special:  0.23999999463558197,
			},
			{
				MaxLevel: 90,
				HP:       4126.2490234375,
				Atk:      107.80606079101562,
				Def:      252.33389282226562,
				Special:  0.3199999928474426,
			},
		},
	},
	core.Razor: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      1002.9700927734375,
		BaseAtk:     19.58880043029785,
		BaseDef:     62.9474983215332,
		Specialized: core.PhyP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       749.27001953125,
				Atk:      14.634180068969727,
				Def:      47.025001525878906,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1281.6461181640625,
				Atk:      25.032150268554688,
				Def:      80.4375,
				Special:  0.07500000298023224,
			},
			{
				MaxLevel: 60,
				HP:       1991.4808349609375,
				Atk:      38.89611053466797,
				Def:      124.98750305175781,
				Special:  0.15000000596046448,
			},
			{
				MaxLevel: 70,
				HP:       2523.85693359375,
				Atk:      49.2940788269043,
				Def:      158.39999389648438,
				Special:  0.15000000596046448,
			},
			{
				MaxLevel: 80,
				HP:       3056.23291015625,
				Atk:      59.69205093383789,
				Def:      191.8125,
				Special:  0.22499999403953552,
			},
			{
				MaxLevel: 90,
				HP:       3588.609130859375,
				Atk:      70.09001922607422,
				Def:      225.22500610351562,
				Special:  0.30000001192092896,
			},
		},
	},
	core.Rosaria: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      1030.3238525390625,
		BaseAtk:     20.12303924560547,
		BaseDef:     59.513999938964844,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       769.7046508789062,
				Atk:      15.033293724060059,
				Def:      44.459999084472656,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1316.60009765625,
				Atk:      25.714845657348633,
				Def:      76.05000305175781,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       2045.7939453125,
				Atk:      39.956912994384766,
				Def:      118.16999816894531,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2592.689453125,
				Atk:      50.638465881347656,
				Def:      149.75999450683594,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       3139.584716796875,
				Atk:      61.32001495361328,
				Def:      181.35000610351562,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3686.480224609375,
				Atk:      72.0015640258789,
				Def:      212.94000244140625,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Kokomi: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1048.6519775390625,
		BaseAtk:     18.247600555419922,
		BaseDef:     51.1546516418457,
		Specialized: core.HydroP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       899.124267578125,
				Atk:      15.644523620605469,
				Def:      43.86149978637695,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1537.9757080078125,
				Atk:      26.7603702545166,
				Def:      75.02625274658203,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       2389.777587890625,
				Atk:      41.58149719238281,
				Def:      116.5792465209961,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       3028.629150390625,
				Atk:      52.69734573364258,
				Def:      147.74400329589844,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       3667.48046875,
				Atk:      63.81319046020508,
				Def:      178.90875244140625,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       4306.33203125,
				Atk:      74.92903900146484,
				Def:      210.07350158691406,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Sayu: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      993.8521728515625,
		BaseAtk:     20.47920036315918,
		BaseDef:     62.43247604370117,
		Specialized: core.EM,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       742.45849609375,
				Atk:      15.299369812011719,
				Def:      46.64025115966797,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1269.9947509765625,
				Atk:      26.16997528076172,
				Def:      79.77937316894531,
				Special:  24,
			},
			{
				MaxLevel: 60,
				HP:       1973.37646484375,
				Atk:      40.66411590576172,
				Def:      123.96487426757812,
				Special:  48,
			},
			{
				MaxLevel: 70,
				HP:       2500.912841796875,
				Atk:      51.53472137451172,
				Def:      157.10400390625,
				Special:  48,
			},
			{
				MaxLevel: 80,
				HP:       3028.448974609375,
				Atk:      62.40532684326172,
				Def:      190.2431182861328,
				Special:  72,
			},
			{
				MaxLevel: 90,
				HP:       3555.9853515625,
				Atk:      73.27593231201172,
				Def:      223.3822479248047,
				Special:  96,
			},
		},
	},
	core.Shenhe: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1011.4725341796875,
		BaseAtk:     23.64739990234375,
		BaseDef:     64.61640167236328,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       867.2462158203125,
				Atk:      20.27402687072754,
				Def:      55.40399932861328,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1483.447509765625,
				Atk:      34.679256439208984,
				Def:      94.7699966430664,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       2305.049072265625,
				Atk:      53.886226654052734,
				Def:      147.25799560546875,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       2921.25048828125,
				Atk:      68.29145812988281,
				Def:      186.62399291992188,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       3537.45166015625,
				Atk:      82.69668579101562,
				Def:      225.99000549316406,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       4153.65283203125,
				Atk:      97.10191345214844,
				Def:      265.3559875488281,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Sucrose: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      775.0223388671875,
		BaseAtk:     14.246399879455566,
		BaseDef:     58.941749572753906,
		Specialized: core.AnemoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       578.9813842773438,
				Atk:      10.64303970336914,
				Def:      44.032501220703125,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       990.3628540039062,
				Atk:      18.2052001953125,
				Def:      75.3187484741211,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1538.87158203125,
				Atk:      28.2880802154541,
				Def:      117.03375244140625,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       1950.2530517578125,
				Atk:      35.85023880004883,
				Def:      148.32000732421875,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2361.634521484375,
				Atk:      43.41239929199219,
				Def:      179.6062469482422,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2773.01611328125,
				Atk:      50.97455978393555,
				Def:      210.8925018310547,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Tartaglia: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1020.0524291992188,
		BaseAtk:     23.461200714111328,
		BaseDef:     63.4197998046875,
		Specialized: core.HydroP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       874.6027221679688,
				Atk:      20.11438751220703,
				Def:      54.37799835205078,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1496.0308837890625,
				Atk:      34.40618896484375,
				Def:      93.01499938964844,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       2324.601806640625,
				Atk:      53.4619255065918,
				Def:      144.531005859375,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       2946.030029296875,
				Atk:      67.75373077392578,
				Def:      183.16799926757812,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       3567.45849609375,
				Atk:      82.0455322265625,
				Def:      221.80499267578125,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       4188.88671875,
				Atk:      96.33733367919922,
				Def:      260.4419860839844,
				Special:  0.2879999876022339,
			},
		},
	},
	core.Thoma: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      866.2014770507812,
		BaseAtk:     16.917600631713867,
		BaseDef:     62.9474983215332,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       647.0968017578125,
				Atk:      12.638609886169434,
				Def:      47.025001525878906,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1106.876220703125,
				Atk:      21.618675231933594,
				Def:      80.4375,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1719.915283203125,
				Atk:      33.59209442138672,
				Def:      124.98750305175781,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2179.694580078125,
				Atk:      42.57215881347656,
				Def:      158.39999389648438,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2639.473876953125,
				Atk:      51.552223205566406,
				Def:      191.8125,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3099.253173828125,
				Atk:      60.532291412353516,
				Def:      225.22500610351562,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Venti: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      819.855224609375,
		BaseAtk:     20.48200035095215,
		BaseDef:     52.052101135253906,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       702.9517211914062,
				Atk:      17.5601806640625,
				Def:      44.63100051879883,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1202.4173583984375,
				Atk:      30.03714942932129,
				Def:      76.34249877929688,
				Special:  0.07999999821186066,
			},
			{
				MaxLevel: 60,
				HP:       1868.37158203125,
				Atk:      46.67311096191406,
				Def:      118.62449645996094,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 70,
				HP:       2367.83740234375,
				Atk:      59.150081634521484,
				Def:      150.33599853515625,
				Special:  0.1599999964237213,
			},
			{
				MaxLevel: 80,
				HP:       2867.302978515625,
				Atk:      71.6270523071289,
				Def:      182.04750061035156,
				Special:  0.23999999463558197,
			},
			{
				MaxLevel: 90,
				HP:       3366.768798828125,
				Atk:      84.10401916503906,
				Def:      213.75900268554688,
				Special:  0.3199999928474426,
			},
		},
	},
	core.Xiangling: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      911.791015625,
		BaseAtk:     18.876480102539062,
		BaseDef:     56.080501556396484,
		Specialized: core.EM,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       681.154541015625,
				Atk:      14.102027893066406,
				Def:      41.89500045776367,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1165.1328125,
				Atk:      24.121889114379883,
				Def:      71.6624984741211,
				Special:  24,
			},
			{
				MaxLevel: 60,
				HP:       1810.4371337890625,
				Atk:      37.48170471191406,
				Def:      111.35250091552734,
				Special:  48,
			},
			{
				MaxLevel: 70,
				HP:       2294.415283203125,
				Atk:      47.50156784057617,
				Def:      141.1199951171875,
				Special:  48,
			},
			{
				MaxLevel: 80,
				HP:       2778.3935546875,
				Atk:      57.52143096923828,
				Def:      170.8874969482422,
				Special:  72,
			},
			{
				MaxLevel: 90,
				HP:       3262.371826171875,
				Atk:      67.54129028320312,
				Def:      200.65499877929688,
				Special:  96,
			},
		},
	},
	core.Xiao: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      991.4528198242188,
		BaseAtk:     27.185199737548828,
		BaseDef:     62.223201751708984,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       850.0811157226562,
				Atk:      23.307147979736328,
				Def:      53.35200119018555,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1454.086181640625,
				Atk:      39.867488861083984,
				Def:      91.26000213623047,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       2259.42626953125,
				Atk:      61.94794464111328,
				Def:      141.8040008544922,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       2863.43115234375,
				Atk:      78.50828552246094,
				Def:      179.71200561523438,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       3467.436279296875,
				Atk:      95.0686264038086,
				Def:      217.6199951171875,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       4071.441162109375,
				Atk:      111.62897491455078,
				Def:      255.5279998779297,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Xingqiu: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      857.0835571289062,
		BaseAtk:     16.917600631713867,
		BaseDef:     63.51974868774414,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       640.2852783203125,
				Atk:      12.638609886169434,
				Def:      47.45249938964844,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1095.224853515625,
				Atk:      21.618675231933594,
				Def:      81.16874694824219,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1701.8109130859375,
				Atk:      33.59209442138672,
				Def:      126.12374877929688,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2156.75048828125,
				Atk:      42.57215881347656,
				Def:      159.83999633789062,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2611.68994140625,
				Atk:      51.552223205566406,
				Def:      193.55624389648438,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3066.629638671875,
				Atk:      60.532291412353516,
				Def:      227.2725067138672,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Xinyan: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      939.1447143554688,
		BaseAtk:     20.835359573364258,
		BaseDef:     66.9532470703125,
		Specialized: core.ATKP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       701.5891723632812,
				Atk:      15.565445899963379,
				Def:      50.01750183105469,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1200.0867919921875,
				Atk:      26.625104904174805,
				Def:      85.5562515258789,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1864.750244140625,
				Atk:      41.37131881713867,
				Def:      132.94125366210938,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       2363.247802734375,
				Atk:      52.43097686767578,
				Def:      168.47999572753906,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2861.745361328125,
				Atk:      63.49063491821289,
				Def:      204.0187530517578,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       3360.242919921875,
				Atk:      74.55029296875,
				Def:      239.5574951171875,
				Special:  0.23999999463558197,
			},
		},
	},
	core.YaeMiko: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      807.4620361328125,
		BaseAtk:     26.440399169921875,
		BaseDef:     44.274200439453125,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       692.32568359375,
				Atk:      22.668596267700195,
				Def:      37.96200180053711,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1184.2413330078125,
				Atk:      38.775230407714844,
				Def:      64.93499755859375,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       1840.1287841796875,
				Atk:      60.2507438659668,
				Def:      100.89900207519531,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       2332.04443359375,
				Atk:      76.35737609863281,
				Def:      127.87200164794922,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       2823.9599609375,
				Atk:      92.4640121459961,
				Def:      154.84500122070312,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       3315.875732421875,
				Atk:      108.57064056396484,
				Def:      181.8179931640625,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Yanfei: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      784.1402587890625,
		BaseAtk:     20.12303924560547,
		BaseDef:     49.2135009765625,
		Specialized: core.PyroP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       585.7929077148438,
				Atk:      15.033293724060059,
				Def:      36.76499938964844,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1002.0142211914062,
				Atk:      25.714845657348633,
				Def:      62.88750076293945,
				Special:  0.05999999865889549,
			},
			{
				MaxLevel: 60,
				HP:       1556.9759521484375,
				Atk:      39.956912994384766,
				Def:      97.71749877929688,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 70,
				HP:       1973.197265625,
				Atk:      50.638465881347656,
				Def:      123.83999633789062,
				Special:  0.11999999731779099,
			},
			{
				MaxLevel: 80,
				HP:       2389.41845703125,
				Atk:      61.32001495361328,
				Def:      149.96249389648438,
				Special:  0.18000000715255737,
			},
			{
				MaxLevel: 90,
				HP:       2805.639892578125,
				Atk:      72.0015640258789,
				Def:      176.0850067138672,
				Special:  0.23999999463558197,
			},
		},
	},
	core.Yelan: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1124.9176025390625,
		BaseAtk:     18.992399215698242,
		BaseDef:     42.658790588378906,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       964.51513671875,
				Atk:      16.2830753326416,
				Def:      36.576900482177734,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1649.8284912109375,
				Atk:      27.852630615234375,
				Def:      62.56575012207031,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       2563.57958984375,
				Atk:      43.27870178222656,
				Def:      97.2175521850586,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       3248.89306640625,
				Atk:      54.8482551574707,
				Def:      123.2063980102539,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       3934.20654296875,
				Atk:      66.41780853271484,
				Def:      149.19525146484375,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       4619.52001953125,
				Atk:      77.98736572265625,
				Def:      175.18409729003906,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Yoimiya: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      791.255615234375,
		BaseAtk:     25.136999130249023,
		BaseDef:     47.86399841308594,
		Specialized: core.CR,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       678.4301147460938,
				Atk:      21.551130294799805,
				Def:      41.040000915527344,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1160.4725341796875,
				Atk:      36.863773345947266,
				Def:      70.19999694824219,
				Special:  0.04800000041723251,
			},
			{
				MaxLevel: 60,
				HP:       1803.1959228515625,
				Atk:      57.280635833740234,
				Def:      109.08000183105469,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 70,
				HP:       2285.23828125,
				Atk:      72.59327697753906,
				Def:      138.24000549316406,
				Special:  0.09600000083446503,
			},
			{
				MaxLevel: 80,
				HP:       2767.28076171875,
				Atk:      87.90592193603516,
				Def:      167.39999389648438,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 90,
				HP:       3249.3232421875,
				Atk:      103.21856689453125,
				Def:      196.55999755859375,
				Special:  0.19200000166893005,
			},
		},
	},
	core.Yunjin: {
		HPCurve:     GROW_CURVE_HP_S4,
		AtkCurve:    GROW_CURVE_ATTACK_S4,
		DefCurve:    GROW_CURVE_HP_S4,
		BaseHP:      893.55517578125,
		BaseAtk:     16.02720069885254,
		BaseDef:     61.574100494384766,
		Specialized: core.ER,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       667.531494140625,
				Atk:      11.973420143127441,
				Def:      45.999000549316406,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1141.8302001953125,
				Atk:      20.480850219726562,
				Def:      78.68250274658203,
				Special:  0.06669999659061432,
			},
			{
				MaxLevel: 60,
				HP:       1774.2283935546875,
				Atk:      31.82408905029297,
				Def:      122.260498046875,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 70,
				HP:       2248.527099609375,
				Atk:      40.331520080566406,
				Def:      154.94400024414062,
				Special:  0.13330000638961792,
			},
			{
				MaxLevel: 80,
				HP:       2722.82568359375,
				Atk:      48.838951110839844,
				Def:      187.62750244140625,
				Special:  0.20000000298023224,
			},
			{
				MaxLevel: 90,
				HP:       3197.12451171875,
				Atk:      57.346378326416016,
				Def:      220.31100463867188,
				Special:  0.26669999957084656,
			},
		},
	},
	core.Zhongli: {
		HPCurve:     GROW_CURVE_HP_S5,
		AtkCurve:    GROW_CURVE_ATTACK_S5,
		DefCurve:    GROW_CURVE_HP_S5,
		BaseHP:      1143.9840087890625,
		BaseAtk:     19.551000595092773,
		BaseDef:     57.436798095703125,
		Specialized: core.GeoP,
		PromotionBonus: []PromoData{
			{
				MaxLevel: 20,
				HP:       0,
				Atk:      0,
				Def:      0,
				Special:  0,
			},
			{
				MaxLevel: 40,
				HP:       980.86279296875,
				Atk:      16.761999130249023,
				Def:      49.24800109863281,
				Special:  0,
			},
			{
				MaxLevel: 50,
				HP:       1677.791748046875,
				Atk:      28.67180061340332,
				Def:      84.23999786376953,
				Special:  0.07199999690055847,
			},
			{
				MaxLevel: 60,
				HP:       2607.0302734375,
				Atk:      44.55160140991211,
				Def:      130.89599609375,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 70,
				HP:       3303.958984375,
				Atk:      56.46139907836914,
				Def:      165.88800048828125,
				Special:  0.14399999380111694,
			},
			{
				MaxLevel: 80,
				HP:       4000.887939453125,
				Atk:      68.37129974365234,
				Def:      200.8800048828125,
				Special:  0.2160000056028366,
			},
			{
				MaxLevel: 90,
				HP:       4697.81689453125,
				Atk:      80.28109741210938,
				Def:      235.8719940185547,
				Special:  0.2879999876022339,
			},
		},
	},
}
