/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import javax.lang.model.element.TypeElement;

@BugPattern(name="OverridesJavaxInjectableMethod", summary="This method is not annotated with @Inject, but it overrides a  method that is  annotated with @javax.inject.Inject.", explanation="According to the JSR-330 spec, a method that overrides a method annotated with javax.inject.Inject will not be injected unless it iself is annotated with  @Inject", category=BugPattern.Category.GUICE, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class GuiceOverridesJavaxInjectableMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final String OVERRIDE_ANNOTATION = "java.lang.Override";
    private static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    private static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    private static final Matcher<MethodTree> INJECTABLE_METHOD_MATCHER = Matchers.anyOf(Matchers.hasAnnotation("com.google.inject.Inject"), Matchers.hasAnnotation("javax.inject.Inject"));
    private static final Matcher<MethodTree> OVERRIDE_METHOD_MATCHER = Matchers.hasAnnotation("java.lang.Override");

    @Override
    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        if (INJECTABLE_METHOD_MATCHER.matches(methodTree, state) || !OVERRIDE_METHOD_MATCHER.matches(methodTree, state)) {
            return Description.NO_MATCH;
        }
        boolean foundJavaxInject = false;
        Symbol.MethodSymbol method = ASTHelpers.getSymbol(methodTree);
        Symbol.MethodSymbol superMethod = null;
        boolean checkSuperClass = true;
        while (checkSuperClass) {
            superMethod = this.findSuperMethod(method, state);
            if (GuiceOverridesJavaxInjectableMethod.isAnnotatedWith(superMethod, GUICE_INJECT_ANNOTATION)) {
                return Description.NO_MATCH;
            }
            foundJavaxInject = GuiceOverridesJavaxInjectableMethod.isAnnotatedWith(superMethod, JAVAX_INJECT_ANNOTATION);
            checkSuperClass = GuiceOverridesJavaxInjectableMethod.isAnnotatedWith(superMethod, OVERRIDE_ANNOTATION);
            method = superMethod;
        }
        if (foundJavaxInject) {
            return this.describeMatch(methodTree, SuggestedFix.builder().addImport(JAVAX_INJECT_ANNOTATION).prefixWith(methodTree, "@Inject\n").build());
        }
        return Description.NO_MATCH;
    }

    private Symbol.MethodSymbol findSuperMethod(Symbol.MethodSymbol method, VisitorState state) {
        Symbol.TypeSymbol superClass = method.enclClass().getSuperclass().tsym;
        for (Symbol s : superClass.members().getSymbols()) {
            if (!s.name.contentEquals(method.name) || !method.overrides(s, superClass, state.getTypes(), true)) continue;
            return (Symbol.MethodSymbol)s;
        }
        return null;
    }

    private static boolean isAnnotatedWith(Symbol.MethodSymbol method, String annotation) {
        for (Attribute.Compound c : method.getAnnotationMirrors()) {
            if (!((TypeElement)c.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotation)) continue;
            return true;
        }
        return false;
    }
}

