/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.tree.JCTree;
import edu.umd.cs.findbugs.formatStringChecker.ExtraFormatArgumentsException;
import edu.umd.cs.findbugs.formatStringChecker.Formatter;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import javax.lang.model.type.TypeKind;

@BugPattern(name="MalformedFormatString", summary="Printf-like format string does not match its arguments", explanation="Format strings for printf family of functions contain format specifiers (placeholders) which must match amount and type of arguments that follow them. If there are more arguments then specifiers, redundant ones are silently ignored. If there are less, or their types don't match, runtime exception is thrown.", category=BugPattern.Category.JDK, maturity=BugPattern.MaturityLevel.EXPERIMENTAL, severity=BugPattern.SeverityLevel.ERROR)
public class MalformedFormatString
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final String EXTRA_ARGUMENTS_MESSAGE = "Too many arguments for printf-like format string: expected %d, got %d";
    private static final Matcher<ExpressionTree> isPrintfLike = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("format(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("printf(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintWriter").withSignature("format(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintWriter").withSignature("printf(java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Formatter").withSignature("format(java.lang.String,java.lang.Object...)"), Matchers.staticMethod().onClass("java.lang.String").withSignature("format(java.lang.String,java.lang.Object...)"));
    private static final Matcher<ExpressionTree> isPrintfLikeWithLocale = Matchers.anyOf(MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("format(java.util.Locale,java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintStream").withSignature("printf(java.util.Locale,java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintWriter").withSignature("printf(java.util.Locale,java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.io.PrintWriter").withSignature("format(java.util.Locale,java.lang.String,java.lang.Object...)"), MethodMatchers.instanceMethod().onDescendantOf("java.util.Formatter").withSignature("format(java.util.Locale,java.lang.String,java.lang.Object...)"), Matchers.staticMethod().onClass("java.lang.String").withSignature("format(java.util.Locale,java.lang.String,java.lang.Object...)"));
    private static final ImmutableMap<TypeKind, String> BOXED_TYPE_NAMES;

    private static String getFormatterType(Type type) {
        String boxedTypeName = (String)BOXED_TYPE_NAMES.get((Object)type.getKind());
        String typeName = boxedTypeName != null ? boxedTypeName : type.toString();
        return "L" + typeName.replace('.', '/') + ";";
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        int formatIndex;
        if (isPrintfLike.matches(tree, state)) {
            formatIndex = 0;
        } else if (isPrintfLikeWithLocale.matches(tree, state)) {
            formatIndex = 1;
        } else {
            return Description.NO_MATCH;
        }
        List<? extends ExpressionTree> allArgs = tree.getArguments();
        ExpressionTree formatExpression = allArgs.get(formatIndex);
        List<? extends ExpressionTree> formatArgs = allArgs.subList(formatIndex + 1, allArgs.size());
        if (formatArgs.size() == 1 && ((JCTree.JCExpression)formatArgs.get((int)0)).type.getKind() == TypeKind.ARRAY) {
            return Description.NO_MATCH;
        }
        String formatString = null;
        if (formatExpression.getKind() == Tree.Kind.STRING_LITERAL) {
            formatString = ((JCTree.JCLiteral)formatExpression).getValue().toString();
        } else {
            Symbol sym = ASTHelpers.getSymbol(formatExpression);
            if (sym instanceof Symbol.VarSymbol) {
                formatString = (String)((Symbol.VarSymbol)sym).getConstValue();
            }
        }
        if (formatString == null) {
            return Description.NO_MATCH;
        }
        ArrayList<String> argTypes = new ArrayList<String>();
        for (ExpressionTree expressionTree : formatArgs) {
            Type type = state.getTypes().erasure(((JCTree.JCExpression)expressionTree).type);
            argTypes.add(MalformedFormatString.getFormatterType(type));
        }
        try {
            Formatter.check((String)formatString, (String[])argTypes.toArray(new String[0]));
        }
        catch (ExtraFormatArgumentsException e) {
            int n = state.getEndPosition((JCTree.JCExpression)allArgs.get(formatIndex + e.used));
            int end = state.getEndPosition((JCTree.JCMethodInvocation)tree);
            if (end < 0) {
                return this.describeMatch(tree);
            }
            Fix fix = SuggestedFix.replace(n, end - 1, "");
            String message = String.format(EXTRA_ARGUMENTS_MESSAGE, e.used, e.provided);
            return this.buildDescription(tree).setMessage(message).addFix(fix).build();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Description.NO_MATCH;
    }

    static {
        EnumMap<TypeKind, String> boxedTypeNames = new EnumMap<TypeKind, String>(TypeKind.class);
        boxedTypeNames.put(TypeKind.BYTE, Byte.class.getName());
        boxedTypeNames.put(TypeKind.SHORT, Short.class.getName());
        boxedTypeNames.put(TypeKind.INT, Integer.class.getName());
        boxedTypeNames.put(TypeKind.LONG, Long.class.getName());
        boxedTypeNames.put(TypeKind.FLOAT, Float.class.getName());
        boxedTypeNames.put(TypeKind.DOUBLE, Double.class.getName());
        boxedTypeNames.put(TypeKind.BOOLEAN, Boolean.class.getName());
        boxedTypeNames.put(TypeKind.CHAR, Character.class.getName());
        boxedTypeNames.put(TypeKind.NULL, Object.class.getName());
        boxedTypeNames.put(TypeKind.ERROR, Object.class.getName());
        BOXED_TYPE_NAMES = Maps.immutableEnumMap(boxedTypeNames);
    }
}

