/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractReturnValueIgnored;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

@BugPattern(name="ReturnValueIgnored", altNames={"ResultOfMethodCallIgnored", "CheckReturnValue"}, summary="Return value of this method must be used", explanation="Certain library methods do nothing useful if their return value is ignored. For example, String.trim() has no side effects, and you must store the return value of String.intern() to access the interned string.  This check encodes a list of methods in the JDK whose return value must be used and issues an error if they are not.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.MATURE)
public class ReturnValueIgnored
extends AbstractReturnValueIgnored {
    private static final Set<String> typesToCheck = new HashSet<String>(Arrays.asList("java.lang.String", "java.math.BigInteger", "java.math.BigDecimal", "java.nio.file.Path"));

    @Override
    public Matcher<? super MethodInvocationTree> specializedMatcher() {
        return Matchers.allOf(ReturnValueIgnored.methodReceiverHasType(typesToCheck), ReturnValueIgnored.methodReturnsSameTypeAsReceiver());
    }

    private static Matcher<ExpressionTree> methodReturnsSameTypeAsReceiver() {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                return state.getTypes().isSameType(ASTHelpers.getReceiverType(expressionTree), ASTHelpers.getReturnType(expressionTree));
            }
        };
    }

    private static Matcher<ExpressionTree> methodReceiverHasType(final Set<String> typeSet) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree expressionTree, VisitorState state) {
                Type receiverType = ASTHelpers.getReceiverType(expressionTree);
                return typeSet.contains(receiverType.toString());
            }
        };
    }
}

