/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AutoValue_StaticImports_StaticImportInfo;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ImportTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import javax.annotation.Nullable;

final class StaticImports {
    StaticImports() {
    }

    @Nullable
    public static StaticImportInfo tryCreate(ImportTree tree, VisitorState state) {
        if (!tree.isStatic()) {
            return null;
        }
        if (!(tree.getQualifiedIdentifier() instanceof JCTree.JCFieldAccess)) {
            return null;
        }
        JCTree.JCFieldAccess access = (JCTree.JCFieldAccess)tree.getQualifiedIdentifier();
        String importedName = access.toString();
        Type result = state.getTypeFromString(importedName);
        if (result == null) {
            return StaticImports.tryAsStaticMember(access, state);
        }
        String canonicalName = state.getTypes().erasure(result).toString();
        if (canonicalName == null) {
            return null;
        }
        return StaticImportInfo.create(importedName, canonicalName, (Optional<Symbol>)Optional.absent());
    }

    private static StaticImportInfo tryAsStaticMember(JCTree.JCFieldAccess access, VisitorState state) {
        if (access.getIdentifier().contentEquals("*")) {
            return null;
        }
        String importedTypeName = access.getExpression().toString();
        Type importedType = state.getTypeFromString(importedTypeName);
        if (importedType == null) {
            return null;
        }
        Type canonicalType = state.getTypes().erasure(importedType);
        if (canonicalType == null) {
            return null;
        }
        Symbol sym = ASTHelpers.getSymbol(access.getExpression());
        if (!(sym instanceof Symbol.TypeSymbol)) {
            return null;
        }
        Symbol.TypeSymbol baseType = (Symbol.TypeSymbol)sym;
        Symbol.PackageSymbol pkgSym = ((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit()).packge;
        Symbol member = StaticImports.lookup(baseType, baseType, access.getIdentifier(), state.getTypes(), pkgSym);
        if (member == null) {
            return null;
        }
        Type canonicalOwner = state.getTypes().erasure(member.owner.type);
        if (canonicalOwner == null) {
            return null;
        }
        return StaticImportInfo.create(importedTypeName, canonicalOwner.toString(), (Optional<Symbol>)Optional.of((Object)member));
    }

    private static Symbol lookup(Symbol.TypeSymbol typeSym, Symbol.TypeSymbol start, Name identifier, Types types, Symbol.PackageSymbol pkg) {
        if (typeSym == null) {
            return null;
        }
        Symbol result = StaticImports.lookup(types.supertype((Type)typeSym.type).tsym, start, identifier, types, pkg);
        if (result != null) {
            return result;
        }
        for (Type i : types.interfaces(typeSym.type)) {
            result = StaticImports.lookup(i.tsym, start, identifier, types, pkg);
            if (result == null) continue;
            return result;
        }
        block6: for (Symbol member : typeSym.members().getSymbolsByName(identifier)) {
            if (!member.isStatic()) continue;
            switch ((int)(member.flags() & 7L)) {
                case 1: {
                    break;
                }
                case 2: {
                    continue block6;
                }
                case 0: 
                case 4: {
                    if (member.packge() == pkg) break;
                    continue block6;
                }
            }
            if (!member.isMemberOf(start, types)) continue;
            return member;
        }
        return null;
    }

    public static abstract class StaticImportInfo {
        abstract String importedName();

        abstract String canonicalName();

        abstract Optional<Symbol> member();

        public boolean isCanonical() {
            return this.canonicalName().equals(this.importedName());
        }

        public String importStatement() {
            if (this.member().isPresent()) {
                Symbol member = (Symbol)this.member().get();
                return String.format("import static %s.%s;", this.canonicalName(), member.getSimpleName());
            }
            return String.format("import %s;", this.canonicalName());
        }

        private static StaticImportInfo create(String importedName, String canonicalName, Optional<Symbol> member) {
            return new AutoValue_StaticImports_StaticImportInfo(importedName, canonicalName, member);
        }
    }
}

