/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.collectionincompatibletype;

import com.google.common.base.MoreObjects;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.collectionincompatibletype.AbstractCollectionIncompatibleTypeMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.MethodArgMatcher;
import com.google.errorprone.bugpatterns.collectionincompatibletype.TypeArgOfMethodArgMatcher;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import java.util.Arrays;
import javax.annotation.Nullable;

@BugPattern(name="CollectionIncompatibleType", summary="Incompatible type as argument to Object-accepting Java collections method", category=BugPattern.Category.JDK, maturity=BugPattern.MaturityLevel.EXPERIMENTAL, severity=BugPattern.SeverityLevel.WARNING)
public class CollectionIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private final FixType fixType;
    private static final Iterable<MethodArgMatcher> DIRECT_MATCHERS = Arrays.asList(new MethodArgMatcher("java.util.Collection", "contains(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Collection", "remove(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Deque", "removeFirstOccurrence(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Deque", "removeLastOccurrence(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Dictionary", "get(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Dictionary", "remove(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.List", "indexOf(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.List", "lastIndexOf(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Map", "containsKey(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Map", "containsValue(java.lang.Object)", 1, 0), new MethodArgMatcher("java.util.Map", "get(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Map", "remove(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Stack", "search(java.lang.Object)", 0, 0), new MethodArgMatcher("java.util.Vector", "indexOf(java.lang.Object,int)", 0, 0), new MethodArgMatcher("java.util.Vector", "lastIndexOf(java.lang.Object,int)", 0, 0), new MethodArgMatcher("java.util.Vector", "removeElement(java.lang.Object)", 0, 0));
    private static final Iterable<TypeArgOfMethodArgMatcher> TYPE_ARG_MATCHERS = Arrays.asList(new TypeArgOfMethodArgMatcher("java.util.Collection", "containsAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0), new TypeArgOfMethodArgMatcher("java.util.Collection", "removeAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0), new TypeArgOfMethodArgMatcher("java.util.Collection", "retainAll(java.util.Collection<?>)", 0, 0, "java.util.Collection", 0));

    public CollectionIncompatibleType() {
        this(FixType.NONE);
    }

    public CollectionIncompatibleType(FixType fixType) {
        this.fixType = fixType;
    }

    @Override
    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        String targetType;
        AbstractCollectionIncompatibleTypeMatcher.MatchResult directResult = CollectionIncompatibleType.firstNonNullMatchResult(DIRECT_MATCHERS, tree, state);
        AbstractCollectionIncompatibleTypeMatcher.MatchResult typeArgResult = null;
        if (directResult == null) {
            typeArgResult = CollectionIncompatibleType.firstNonNullMatchResult(TYPE_ARG_MATCHERS, tree, state);
        }
        if (directResult == null && typeArgResult == null) {
            return Description.NO_MATCH;
        }
        Verify.verify((boolean)(directResult == null ^ typeArgResult == null));
        AbstractCollectionIncompatibleTypeMatcher.MatchResult result = (AbstractCollectionIncompatibleTypeMatcher.MatchResult)MoreObjects.firstNonNull((Object)directResult, (Object)typeArgResult);
        Types types = state.getTypes();
        if (types.isCastable(result.sourceType(), types.erasure(ASTHelpers.getUpperBound(result.targetType(), types)))) {
            return Description.NO_MATCH;
        }
        String sourceTreeType = CollectionIncompatibleType.getSimpleName(ASTHelpers.getType(result.sourceTree()));
        String sourceType = CollectionIncompatibleType.getSimpleName(result.sourceType());
        if (sourceType.equals(targetType = CollectionIncompatibleType.getSimpleName(result.targetType()))) {
            sourceType = result.sourceType().toString();
            targetType = result.targetType().toString();
        }
        Description.Builder description = this.buildDescription(tree);
        if (typeArgResult != null) {
            description.setMessage(String.format("Argument '%s' should not be passed to this method; its type %s has a type argument %s that is not compatible with its collection's type argument %s", result.sourceTree(), sourceTreeType, sourceType, targetType));
        } else {
            description.setMessage(String.format("Argument '%s' should not be passed to this method; its type %s is not compatible with its collection's type argument %s", result.sourceTree(), sourceType, targetType));
        }
        switch (this.fixType) {
            case PRINT_TYPES_AS_COMMENT: {
                description.addFix(SuggestedFix.prefixWith(tree, String.format("/* expected: %s, actual: %s */", ASTHelpers.getUpperBound(result.targetType(), types), result.sourceType())));
                break;
            }
            case CAST: {
                Fix fix;
                if (typeArgResult != null) {
                    TypeArgOfMethodArgMatcher matcher = (TypeArgOfMethodArgMatcher)typeArgResult.matcher();
                    String fullyQualifiedType = matcher.getMethodArgTypeName();
                    String simpleType = (String)Iterables.getLast((Iterable)Splitter.on((char)'.').split((CharSequence)fullyQualifiedType));
                    fix = SuggestedFix.builder().prefixWith(result.sourceTree(), String.format("(%s<?>) ", simpleType)).addImport(fullyQualifiedType).build();
                } else {
                    fix = SuggestedFix.prefixWith(result.sourceTree(), "(Object) ");
                }
                description.addFix(fix);
                break;
            }
        }
        return description.build();
    }

    @Nullable
    private static AbstractCollectionIncompatibleTypeMatcher.MatchResult firstNonNullMatchResult(Iterable<? extends AbstractCollectionIncompatibleTypeMatcher> matchers, MethodInvocationTree tree, VisitorState state) {
        for (AbstractCollectionIncompatibleTypeMatcher abstractCollectionIncompatibleTypeMatcher : matchers) {
            AbstractCollectionIncompatibleTypeMatcher.MatchResult result = abstractCollectionIncompatibleTypeMatcher.matches(tree, state);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static String getSimpleName(Type type) {
        StringBuilder sb = new StringBuilder(type.tsym.getSimpleName());
        List<Type> typeArgs = type.getTypeArguments();
        if (!typeArgs.isEmpty()) {
            sb.append('<');
            Type typeArg = (Type)typeArgs.get(0);
            sb.append(CollectionIncompatibleType.getSimpleName(typeArg));
            for (int i = 1; i < typeArgs.size(); ++i) {
                sb.append(", ");
                sb.append(CollectionIncompatibleType.getSimpleName(typeArg));
            }
            sb.append('>');
        }
        return sb.toString();
    }

    public static enum FixType {
        NONE,
        CAST,
        PRINT_TYPES_AS_COMMENT;

    }
}

