/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.threadsafety;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.bugpatterns.threadsafety.GuardedByUtils;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;

@BugPattern(name="GuardedByValidator", summary="Invalid @GuardedBy expression", explanation="@GuardedBy(lock) documents that a field or method should be accessed only with a specific lock held. The lock argument identifies the lock that should be held when accessing the annotated field or method. The possible values for lock are: * @GuardedBy(\"this\"), meaning the intrinsic lock on the containing object (the object of which the method or field is a member);* @GuardedBy(\"fieldName\"), meaning the lock associated with the object referenced by the named field, either an intrinsic lock (for fields that do not refer to a Lock) or an explicit Lock (for fields that refer to a Lock);* @GuardedBy(\"ClassName.fieldName\"), like @GuardedBy(\"fieldName\"), but referencing a lock object held in a static field of another class;* @GuardedBy(\"methodName()\"), meaning the lock object that is returned by calling the named method;* @GuardedBy(\"ClassName.class\"), meaning the class literal object for the named class.", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.ERROR, maturity=BugPattern.MaturityLevel.EXPERIMENTAL)
public class GuardedByValidator
extends BugChecker
implements BugChecker.VariableTreeMatcher,
BugChecker.MethodTreeMatcher {
    private static final String MESSAGE_FORMAT = "Invalid @GuardedBy expression: %s";

    @Override
    public Description matchMethod(MethodTree tree, VisitorState state) {
        return GuardedByValidator.validate(this, tree, state);
    }

    @Override
    public Description matchVariable(VariableTree tree, VisitorState state) {
        return GuardedByValidator.validate(this, tree, state);
    }

    static Description validate(BugChecker checker, Tree tree, VisitorState state) {
        GuardedByUtils.GuardedByValidationResult result = GuardedByUtils.isGuardedByValid(tree, state);
        if (result.isValid().booleanValue()) {
            return Description.NO_MATCH;
        }
        return BugChecker.buildDescriptionFromChecker(tree, checker).setMessage(String.format(MESSAGE_FORMAT, result.message())).build();
    }
}

