/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.refaster;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.refaster.AutoValue_ULambda;
import com.google.errorprone.refaster.Choice;
import com.google.errorprone.refaster.CouldNotResolveImportException;
import com.google.errorprone.refaster.Inliner;
import com.google.errorprone.refaster.UExpression;
import com.google.errorprone.refaster.UTree;
import com.google.errorprone.refaster.UVariableDecl;
import com.google.errorprone.refaster.Unifier;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TreeVisitor;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.List;

abstract class ULambda
extends UExpression
implements LambdaExpressionTree {
    ULambda() {
    }

    public static ULambda create(Iterable<UVariableDecl> parameters, UTree<?> body) {
        return new AutoValue_ULambda((ImmutableList<UVariableDecl>)ImmutableList.copyOf(parameters), body);
    }

    @Override
    public Tree.Kind getKind() {
        return Tree.Kind.LAMBDA_EXPRESSION;
    }

    @Override
    public <R, D> R accept(TreeVisitor<R, D> visitor, D data) {
        return visitor.visitLambdaExpression(this, data);
    }

    @Override
    public Choice<Unifier> visitLambdaExpression(LambdaExpressionTree node, Unifier unifier) {
        return Unifier.unifyList(unifier, this.getParameters(), node.getParameters()).thenChoose(Unifier.unifications(this.getBody(), node.getBody()));
    }

    @Override
    public JCTree.JCLambda inline(Inliner inliner) throws CouldNotResolveImportException {
        return inliner.maker().Lambda(List.convert(JCTree.JCVariableDecl.class, inliner.inlineList(this.getParameters())), (JCTree)this.getBody().inline(inliner));
    }

    public abstract ImmutableList<UVariableDecl> getParameters();

    @Override
    public abstract UTree<?> getBody();

    @Override
    public LambdaExpressionTree.BodyKind getBodyKind() {
        return this.getBody().getKind() == Tree.Kind.BLOCK ? LambdaExpressionTree.BodyKind.STATEMENT : LambdaExpressionTree.BodyKind.EXPRESSION;
    }
}

