"""add is_external to PackageExtractRun

Revision ID: 079e1d92f9d4
Revises: 650a13fd0a08
Create Date: 2019-10-08 12:33:51.979019+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "079e1d92f9d4"
down_revision = "650a13fd0a08"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("has_symbol", sa.Column("external_software_environment_id", sa.Integer(), nullable=False))
    op.create_foreign_key(
        None,
        "has_symbol",
        "external_software_environment",
        ["external_software_environment_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.add_column("package_extract_run", sa.Column("external_software_environment_id", sa.Integer(), nullable=False))
    op.create_foreign_key(
        None,
        "package_extract_run",
        "external_software_environment",
        ["external_software_environment_id"],
        ["id"],
        ondelete="CASCADE",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "package_extract_run", type_="foreignkey")
    op.drop_column("package_extract_run", "external_software_environment_id")
    op.drop_constraint(None, "has_symbol", type_="foreignkey")
    op.drop_column("has_symbol", "external_software_environment_id")
    # ### end Alembic commands ###
