"""Delete to refactor Schema for Python Software Stack

Revision ID: 1a8150ac45e0
Revises: 342d45db2dc2
Create Date: 2020-10-09 15:42:56.711181+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "1a8150ac45e0"
down_revision = "342d45db2dc2"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("external_python_requirements_lock")
    op.drop_table("has_unresolved")
    op.drop_table("advised")
    op.drop_table("python_requirements_lock")
    op.drop_table("adviser_run")
    op.drop_table("python_requirements")
    op.drop_table("pi_conv1d")
    op.drop_table("pi_pybench")
    op.drop_table("provenance_checker_run")
    op.drop_table("pi_conv2d")
    op.drop_table("pi_matmul")
    op.drop_table("inspection_run")
    op.drop_table("python_software_stack")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "pi_matmul",
        sa.Column("origin", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("version", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("overall_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("exit_code", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_utime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_stime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_maxrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_ixrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_idrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_isrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_minflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_majflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nswap", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_inblock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_oublock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgsnd", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgrcv", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nsignals", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nvcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nivcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("inspection_run_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("device", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("matrix_size", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("dtype", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("reps", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("elapsed", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("rate", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("component", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(["inspection_run_id"], ["inspection_run.id"], name="pi_matmul_inspection_run_id_fkey"),
        sa.PrimaryKeyConstraint("id", name="pi_matmul_pkey"),
    )
    op.create_table(
        "pi_conv2d",
        sa.Column("origin", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("version", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("overall_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("exit_code", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_utime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_stime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_maxrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_ixrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_idrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_isrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_minflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_majflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nswap", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_inblock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_oublock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgsnd", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgrcv", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nsignals", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nvcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nivcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("inspection_run_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("device", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("dtype", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("reps", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("data_format", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("batch", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("input_height", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("input_width", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("input_channels", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("filter_height", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("filter_width", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("output_channels", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("strides", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("padding", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("elapsed", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("rate", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("component", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(["inspection_run_id"], ["inspection_run.id"], name="pi_conv2d_inspection_run_id_fkey"),
        sa.PrimaryKeyConstraint("id", name="pi_conv2d_pkey"),
    )
    op.create_table(
        "provenance_checker_run",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("provenance_checker_document_id", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("datetime", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("provenance_checker_version", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("provenance_checker_name", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("origin", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("debug", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("provenance_checker_error", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("duration", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("user_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["user_software_stack_id"],
            ["python_software_stack.id"],
            name="provenance_checker_run_user_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", "user_software_stack_id", name="provenance_checker_run_pkey"),
    )
    op.create_table(
        "pi_pybench",
        sa.Column("component", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("origin", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("version", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("overall_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("exit_code", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_utime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_stime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_maxrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_ixrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_idrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_isrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_minflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_majflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nswap", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_inblock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_oublock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgsnd", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgrcv", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nsignals", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nvcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nivcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("inspection_run_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("rounds", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column(
            "built_in_function_calls_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "built_in_method_lookup_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "compare_floats_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "compare_floats_integers_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "compare_integers_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "compare_interned_strings_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "compare_longs_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "compare_strings_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "compare_unicode_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "concat_strings_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "concat_unicode_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "create_instances_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "create_new_instances_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "create_strings_with_concat_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "create_unicode_with_concat_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "dict_creation_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "dict_with_float_keys_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "dict_with_integer_keys_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "dict_with_string_keys_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("for_loops_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column(
            "if_then_else_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "list_slicing_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "nested_for_loops_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "normal_class_attribute_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "normal_instance_attribute_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "python_function_calls_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "python_method_calls_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("recursion_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column(
            "second_import_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "second_package_import_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "second_submodule_import_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_complex_arithmetic_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_dict_manipulation_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_float_arithmetic_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_int_float_arithmetic_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_integer_arithmetic_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_list_manipulation_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "simple_long_arithmetic_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "small_lists_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "small_tuples_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "special_class_attribute_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "special_instance_attribute_average",
            postgresql.DOUBLE_PRECISION(precision=53),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "string_mappings_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "string_predicates_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "string_slicing_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column("try_except_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column(
            "try_raise_except_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "tuple_slicing_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "unicode_mappings_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "unicode_predicates_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "unicode_properties_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column(
            "unicode_slicing_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False
        ),
        sa.Column("totals_average", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(["inspection_run_id"], ["inspection_run.id"], name="pi_pybench_inspection_run_id_fkey"),
        sa.PrimaryKeyConstraint("id", name="pi_pybench_pkey"),
    )
    op.create_table(
        "pi_conv1d",
        sa.Column("origin", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("version", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("overall_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("exit_code", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_utime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_stime", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("ru_maxrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_ixrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_idrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_isrss", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_minflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_majflt", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nswap", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_inblock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_oublock", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgsnd", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_msgrcv", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nsignals", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nvcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("ru_nivcsw", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("inspection_run_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("device", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("dtype", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("reps", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("data_format", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.Column("batch", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("input_width", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("input_channels", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("filter_width", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("output_channels", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("strides", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("padding", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("elapsed", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("rate", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=False),
        sa.Column("component", sa.VARCHAR(length=256), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(["inspection_run_id"], ["inspection_run.id"], name="pi_conv1d_inspection_run_id_fkey"),
        sa.PrimaryKeyConstraint("id", name="pi_conv1d_pkey"),
    )
    op.create_table(
        "python_requirements",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("python_package_requirement_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("python_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["python_package_requirement_id"],
            ["python_package_requirement.id"],
            name="python_requirements_python_package_requirement_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["python_software_stack_id"],
            ["python_software_stack.id"],
            name="python_requirements_python_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint(
            "id", "python_package_requirement_id", "python_software_stack_id", name="python_requirements_pkey"
        ),
    )
    op.create_table(
        "adviser_run",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text("nextval('adviser_run_id_seq'::regclass)"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column("adviser_document_id", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("datetime", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("adviser_version", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("adviser_name", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("count", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("limit", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("origin", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("debug", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("limit_latest_versions", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("adviser_error", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column(
            "recommendation_type",
            postgresql.ENUM("LATEST", "PERFORMANCE", "SECURITY", "STABLE", "TESTING", name="recommendation_type"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column(
            "requirements_format",
            postgresql.ENUM("PIPENV", name="requirements_format"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("duration", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("advised_configuration_changes", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("additional_stack_info", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("user_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("external_build_software_environment_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("external_hardware_information_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("external_run_software_environment_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("is_s2i", sa.BOOLEAN(), autoincrement=False, nullable=True),
        sa.Column("need_re_run", sa.BOOLEAN(), autoincrement=False, nullable=True),
        sa.Column("re_run_adviser_id", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column(
            "source_type",
            postgresql.ENUM("CLI", "KEBECHET", "S2I", "GITHUB_APP", "JUPYTER_NOTEBOOK", name="source_type"),
            autoincrement=False,
            nullable=True,
        ),
        sa.ForeignKeyConstraint(
            ["external_build_software_environment_id"],
            ["external_software_environment.id"],
            name="adviser_run_external_build_software_environment_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["external_hardware_information_id"],
            ["external_hardware_information.id"],
            name="adviser_run_external_hardware_information_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["external_run_software_environment_id"],
            ["external_software_environment.id"],
            name="adviser_run_external_run_software_environment_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["user_software_stack_id"],
            ["python_software_stack.id"],
            name="adviser_run_user_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="adviser_run_pkey"),
        postgresql_ignore_search_path=False,
    )
    op.create_table(
        "python_requirements_lock",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("python_package_version_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("python_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["python_package_version_id"],
            ["python_package_version.id"],
            name="python_requirements_lock_python_package_version_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["python_software_stack_id"],
            ["python_software_stack.id"],
            name="python_requirements_lock_python_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint(
            "id", "python_package_version_id", "python_software_stack_id", name="python_requirements_lock_pkey"
        ),
    )
    op.create_table(
        "python_software_stack",
        sa.Column(
            "id",
            sa.INTEGER(),
            server_default=sa.text("nextval('python_software_stack_id_seq'::regclass)"),
            autoincrement=True,
            nullable=False,
        ),
        sa.Column(
            "software_stack_type",
            postgresql.ENUM("USER", "INSPECTION", "ADVISED", name="software_stack_type", create_type=True),
            autoincrement=False,
            nullable=True,
        ),
        sa.Column("performance_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("overall_score", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.PrimaryKeyConstraint("id", name="python_software_stack_pkey"),
        postgresql_ignore_search_path=False,
    )
    op.create_table(
        "inspection_run",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("inspection_document_id", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("datetime", postgresql.TIMESTAMP(), autoincrement=False, nullable=True),
        sa.Column("amun_version", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("build_requests_cpu", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column(
            "build_requests_memory", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True
        ),
        sa.Column("run_requests_cpu", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column("run_requests_memory", postgresql.DOUBLE_PRECISION(precision=53), autoincrement=False, nullable=True),
        sa.Column(
            "inspection_sync_state",
            postgresql.ENUM("PENDING", "SYNCED", name="inspection_sync_state"),
            autoincrement=False,
            nullable=False,
        ),
        sa.Column("build_hardware_information_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("run_hardware_information_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("build_software_environment_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("run_software_environment_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("dependency_monkey_run_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("inspection_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column(
            "inspection_result_number", sa.INTEGER(), server_default=sa.text("0"), autoincrement=False, nullable=False
        ),
        sa.ForeignKeyConstraint(
            ["build_hardware_information_id"],
            ["hardware_information.id"],
            name="inspection_run_build_hardware_information_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["build_software_environment_id"],
            ["software_environment.id"],
            name="inspection_run_build_software_environment_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["dependency_monkey_run_id"],
            ["dependency_monkey_run.id"],
            name="inspection_run_dependency_monkey_run_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["inspection_software_stack_id"],
            ["python_software_stack.id"],
            name="inspection_run_inspection_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["run_hardware_information_id"],
            ["hardware_information.id"],
            name="inspection_run_run_hardware_information_id_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["run_software_environment_id"],
            ["software_environment.id"],
            name="inspection_run_run_software_environment_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="inspection_run_pkey"),
    )
    op.create_table(
        "advised",
        sa.Column("adviser_run_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("python_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["adviser_run_id"], ["adviser_run.id"], name="advised_adviser_run_id_fkey", ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["python_software_stack_id"],
            ["python_software_stack.id"],
            name="advised_python_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
    )
    op.create_table(
        "has_unresolved",
        sa.Column("adviser_run_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("python_package_version_entity_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["adviser_run_id"], ["adviser_run.id"], name="has_unresolved_adviser_run_id_fkey", ondelete="CASCADE"
        ),
        sa.ForeignKeyConstraint(
            ["python_package_version_entity_id"],
            ["python_package_version_entity.id"],
            name="has_unresolved_python_package_version_entity_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("adviser_run_id", "python_package_version_entity_id", name="has_unresolved_pkey"),
    )
    op.create_table(
        "external_python_requirements_lock",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("python_package_version_entity_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.Column("python_software_stack_id", sa.INTEGER(), autoincrement=False, nullable=False),
        sa.ForeignKeyConstraint(
            ["python_package_version_entity_id"],
            ["python_package_version_entity.id"],
            name="external_python_requirements__python_package_version_entit_fkey",
            ondelete="CASCADE",
        ),
        sa.ForeignKeyConstraint(
            ["python_software_stack_id"],
            ["python_software_stack.id"],
            name="external_python_requirements_lock_python_software_stack_id_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint(
            "id",
            "python_package_version_entity_id",
            "python_software_stack_id",
            name="external_python_requirements_lock_pkey",
        ),
    )
    # ### end Alembic commands ###
