"""Separate the project_url column from the python_package_metadata_project_url table into two columns label and url

Revision ID: 2b787ddad4a4
Revises: 930b47e27b6c
Create Date: 2022-01-31 16:26:38.049747+00:00

"""
from alembic import op
from sqlalchemy import MetaData

import sqlalchemy as sa
from thoth.storages.graph.models import PythonPackageMetadataProjectUrl

# revision identifiers, used by Alembic.
revision = "2b787ddad4a4"
down_revision = "930b47e27b6c"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column("python_package_metadata_project_url", sa.Column("url", sa.Text(), nullable=True))
    op.add_column("python_package_metadata_project_url", sa.Column("label", sa.Text(), nullable=True))

    python_package_metadata_project_url_table = sa.Table(
        "python_package_metadata_project_url",
        MetaData(),
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("project_url", sa.Text(), nullable=False),
        sa.Column("url", sa.Text(), nullable=True),
        sa.Column("label", sa.Text(), nullable=True),
    )

    connection = op.get_bind()

    results = connection.execute(
        sa.select(
            [python_package_metadata_project_url_table.c.id, python_package_metadata_project_url_table.c.project_url]
        )
    ).fetchall()

    for result in results:
        id_ = result[0]
        label_url = result[1].split(",")
        if len(label_url) == 2:
            label, url = label_url[0].strip(), label_url[1].strip()
            connection.execute(
                python_package_metadata_project_url_table.update()
                .where(python_package_metadata_project_url_table.c.id == id_)
                .values({"label": label, "url": url})
            )

    op.drop_column("python_package_metadata_project_url", "project_url")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    connection = op.get_bind()
    op.add_column(
        "python_package_metadata_project_url", sa.Column("project_url", sa.TEXT(), autoincrement=False, nullable=True)
    )
    result = connection.execute("SELECT id, label, url FROM python_package_metadata_project_url").fetchall()
    op.drop_column("python_package_metadata_project_url", "label")
    op.drop_column("python_package_metadata_project_url", "url")
    concat_label_url = []
    for r in result:
        id_row = r[0]
        values_row = r[1]
        concat_label_url.append(
            {"id": id_row, "project_url": values_row[1] if values_row[0] is None else values_row.join(",")}
        )
    op.batch_alter_table().bulk_insert(PythonPackageMetadataProjectUrl.__table__, concat_label_url)
    # ### end Alembic commands ###
