"""Adjust CVE model to consume vulnerabilities from pypa/advisory-db

Revision ID: 50081eea5da2
Revises: db6290ac490d
Create Date: 2021-06-02 08:15:43.474297+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "50081eea5da2"
down_revision = "db6290ac490d"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("DELETE FROM CVE")
    op.add_column("cve", sa.Column("details", sa.Text(), nullable=False))
    op.drop_column("cve", "version_range")
    op.drop_column("cve", "cve_name")
    op.drop_column("cve", "advisory")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.execute("DELETE FROM CVE")
    op.add_column("cve", sa.Column("advisory", sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column("cve", sa.Column("cve_name", sa.TEXT(), autoincrement=False, nullable=True))
    op.add_column("cve", sa.Column("version_range", sa.TEXT(), autoincrement=False, nullable=True))
    op.drop_column("cve", "details")
    # ### end Alembic commands ###
