"""Remove buildlog analyzers

Revision ID: 91620576525b
Revises: e7ebfc165a96
Create Date: 2021-01-13 09:52:23.293119+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "91620576525b"
down_revision = "e7ebfc165a96"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("build_log_analyzer_run")
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "build_log_analyzer_run",
        sa.Column("id", sa.INTEGER(), autoincrement=True, nullable=False),
        sa.Column("build_log_analyzer_name", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("build_log_analyzer_version", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("build_log_analysis_document_id", sa.TEXT(), autoincrement=False, nullable=False),
        sa.Column("datetime", postgresql.TIMESTAMP(), autoincrement=False, nullable=False),
        sa.Column("debug", sa.BOOLEAN(), autoincrement=False, nullable=False),
        sa.Column("build_log_analyzer_error_reason", sa.TEXT(), autoincrement=False, nullable=True),
        sa.Column("duration", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.Column("input_python_package_version_entity_id", sa.INTEGER(), autoincrement=False, nullable=True),
        sa.ForeignKeyConstraint(
            ["input_python_package_version_entity_id"],
            ["python_package_version_entity.id"],
            name="build_log_analyzer_run_input_python_package_version_entity_fkey",
            ondelete="CASCADE",
        ),
        sa.PrimaryKeyConstraint("id", name="build_log_analyzer_run_pkey"),
    )
    # ### end Alembic commands ###
