"""Add ImportPackage, FoundImportPackage classes and get_python_package_version_import_packages_all function

Revision ID: aba59a2fec95
Revises: 5c1e7425ce60
Create Date: 2021-08-13 13:26:04.445039+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "aba59a2fec95"
down_revision = "5c1e7425ce60"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "import_package",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("import_package_name", sa.Text(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_index("import_package_import_package_name_idx", "import_package", ["import_package_name"], unique=False)
    op.create_table(
        "found_import_package",
        sa.Column("python_package_version_id", sa.Integer(), nullable=False),
        sa.Column("import_package_id", sa.Integer(), nullable=False),
        sa.ForeignKeyConstraint(["import_package_id"], ["import_package.id"], ondelete="CASCADE"),
        sa.ForeignKeyConstraint(["python_package_version_id"], ["python_package_version.id"], ondelete="CASCADE"),
        sa.PrimaryKeyConstraint("python_package_version_id", "import_package_id"),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_table("found_import_package")
    op.drop_index("import_package_import_package_name_idx", table_name="import_package")
    op.drop_table("import_package")
    # ### end Alembic commands ###
