"""Added source type to adviser run table

Revision ID: d77154f3c15f
Revises: 7c261487d4d4
Create Date: 2020-06-30 00:59:47.273996+00:00

"""
from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import postgresql

# revision identifiers, used by Alembic.
revision = "d77154f3c15f"
down_revision = "7c261487d4d4"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    source_type = postgresql.ENUM("CLI", "KEBECHET", "S2I", "GITHUB_APP", "JUPYTER_NOTEBOOK", name="source_type")
    source_type.create(op.get_bind())
    op.add_column(
        "adviser_run",
        sa.Column(
            "source_type",
            sa.Enum("CLI", "KEBECHET", "S2I", "GITHUB_APP", "JUPYTER_NOTEBOOK", name="source_type"),
            nullable=True,
        ),
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_column("adviser_run", "source_type")
    source_type = postgresql.ENUM("CLI", "KEBECHET", "S2I", "GITHUB_APP", "JUPYTER_NOTEBOOK", name="source_type")
    source_type.drop(op.get_bind())
    # ### end Alembic commands ###
