"""Added PythonPackageMetadata table

Revision ID: e05d6d95ea95
Revises: 74f68dabbb46
Create Date: 2019-10-15 16:59:27.902479+00:00

"""
from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision = "e05d6d95ea95"
down_revision = "74f68dabbb46"
branch_labels = None
depends_on = None


def upgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table(
        "python_package_metadata",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("author", sa.String(length=256), nullable=True),
        sa.Column("author_email", sa.String(length=256), nullable=True),
        sa.Column("classifier", sa.String(length=256), nullable=True),
        sa.Column("download_url", sa.String(length=256), nullable=True),
        sa.Column("home_page", sa.String(length=256), nullable=True),
        sa.Column("keywords", sa.String(length=256), nullable=True),
        sa.Column("license", sa.String(length=256), nullable=True),
        sa.Column("maintainer", sa.String(length=256), nullable=True),
        sa.Column("maintainer_email", sa.String(length=256), nullable=True),
        sa.Column("metadata_version", sa.String(length=256), nullable=True),
        sa.Column("name", sa.String(length=256), nullable=True),
        sa.Column("platform", sa.String(length=256), nullable=True),
        sa.Column("requires_dist", sa.String(length=256), nullable=True),
        sa.Column("summary", sa.String(length=256), nullable=True),
        sa.Column("version", sa.String(length=256), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.add_column("python_package_version", sa.Column("python_package_metadata_id", sa.Integer(), nullable=True))
    op.create_foreign_key(
        None,
        "python_package_version",
        "python_package_metadata",
        ["python_package_metadata_id"],
        ["id"],
        ondelete="CASCADE",
    )
    # ### end Alembic commands ###


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "python_package_version", type_="foreignkey")
    op.drop_column("python_package_version", "python_package_metadata_id")
    op.drop_table("python_package_metadata")
    # ### end Alembic commands ###
