# Copyright (C) 2009-2013 Zentyal S.L.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU RemoteGeneral Public License, version 2, as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU RemoteGeneral Public License for more details.
#
# You should have received a copy of the GNU RemoteGeneral Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

use strict;
use warnings;

package EBox::EBackup::Composite::RemoteGeneral;

use base 'EBox::Model::Composite';

use EBox::Global;
use EBox::Gettext;

# Group: Protected methods

# Method: _description
#
# Overrides:
#
#       <EBox::Model::Composite::_description>
#
sub _description
{
    my $description =
    {
        layout          => 'top-bottom',
        name            => __PACKAGE__->nameFromClass,
        printableName   => __('Configuration and Status'),
        compositeDomain => 'EBackup',
    };

    return $description;
}

# Method: pageTitle
#
# Overrides:
#
#       <EBox::Model::Composite::pageTitle>
#
sub pageTitle
{
    return undef;
}

1;
