use strict;
use warnings;

use Test::More qw(no_plan);
use Test::Exception;

use lib '../..';
use EBox::TestStubs qw(fakeModule);

EBox::TestStubs::activateTestStubs();
fakeModule(name => 'testMod');
backupDirTest();
createBackupDirTest();
setAsChangedTest();
noTemplateFileTest();

sub backupDirTest
{
  my $mod = EBox::Global->modInstance('testMod');

  my @cases = (
               ['/' => '/testMod.bak'],
               ['/var/lib/zentyal/backups' => '/var/lib/zentyal/backups/testMod.bak'],
               ['/var/lib/zentyal/backups/' => '/var/lib/zentyal/backups/testMod.bak'],
               # with repetition:
               ['/var/lib/zentyal/backups/testMod.bak' => '/var/lib/zentyal/backups/testMod.bak'],
               ['/var/lib/zentyal/backups/testMod.bak/' => '/var/lib/zentyal/backups/testMod.bak'],
               ['/var/lib/zentyal/backups/testMod.bak/testMod.bak' => '/var/lib/zentyal/backups/testMod.bak'],
              );

  foreach my $case_r (@cases) {
    my ($dir, $expectedBackupDir) = @{ $case_r };

    is $mod->backupDir($dir), $expectedBackupDir, "Checking backupDir($dir) eq $expectedBackupDir";
  }
}

sub createBackupDirTest
{
  my $dir = '/tmp/ebox.module.backupdir.test';
  system "rm -rf $dir";
  mkdir $dir;

  my $mod = EBox::Global->modInstance('testMod');

  my @cases = (
               ["$dir" => "$dir/testMod.bak"],
               ["$dir" => "$dir/testMod.bak"], # check that can be called two times in a row
               ["$dir/testMod.bak" => "$dir/testMod.bak"],
               ["$dir/testMod.bak/" => "$dir/testMod.bak"],
               ["$dir/testMod.bak/testMod.bak" => "$dir/testMod.bak"],
  );

  foreach my $case_r (@cases) {
    my ($dir, $expectedBackupDir) = @{ $case_r };

    lives_and( sub { is $mod->_createBackupDir($dir), $expectedBackupDir } , "Testing _createBackupDir($dir)" );
    my $dirExists =  (-d $expectedBackupDir);
    ok $dirExists, "Checking that the backup directory  $dir is in place";
  }
}

sub setAsChangedTest
{
  EBox::TestStubs::setModule('global' => 'EBox::Global');

  my $global = EBox::Global->getInstance();
  (! $global->modIsChanged('testMod')) or die "Module must not be changed";

  lives_and (
             sub {
               my $mod = $global->modInstance('testMod');
               $mod->setAsChanged();

               ok $global->modIsChanged('testMod');
             },
             'Module was marked as changed'
  );
}

sub noTemplateFileTest
{
    EBox::TestStubs::setEBoxConfigKeys(tmp => '/tmp', stubs => '/tmp');

    my $mod = EBox::Global->modInstance('testMod');
    dies_ok {
        $mod->writeConfFile(
                            '/tmp/whatever',
                            'inexistentTemplate.mas',
                            []

                           );
    } 'Checking that writeConfFile dies when supplied with a inexistent template file';
}

1;
