package io.quarkus.arc.processor;

import static io.quarkus.arc.processor.Basics.index;

import io.quarkus.arc.processor.BeanProcessor.PrivateMembersCollector;
import io.quarkus.arc.processor.types.Foo;
import io.quarkus.arc.processor.types.FooQualifier;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import org.jboss.jandex.Index;
import org.junit.Test;

public class BeanGeneratorTest {

    @Test
    public void testGenerator() throws IOException {

        Index index = index(Foo.class, FooQualifier.class, AbstractList.class, AbstractCollection.class, Collection.class,
                List.class, Iterable.class);
        BeanDeployment deployment = new BeanDeployment(index, null, null);
        deployment.init();

        BeanGenerator generator = new BeanGenerator(new AnnotationLiteralProcessor(true, TruePredicate.INSTANCE),
                TruePredicate.INSTANCE, new PrivateMembersCollector());

        deployment.getBeans().forEach(bean -> generator.generate(bean, ReflectionRegistration.NOOP));
        // TODO test generated bytecode
    }

    @Test
    public void testGeneratorForNormalScopedProducer() throws IOException {

        Index index = index(Producer.class, Collection.class, List.class, Iterable.class);
        BeanDeployment deployment = new BeanDeployment(index, null, null);
        deployment.init();

        BeanGenerator generator = new BeanGenerator(new AnnotationLiteralProcessor(true, TruePredicate.INSTANCE),
                TruePredicate.INSTANCE, new PrivateMembersCollector());

        deployment.getBeans().forEach(bean -> generator.generate(bean, ReflectionRegistration.NOOP));
        // TODO test generated bytecode
    }

    @Dependent
    static class Producer {

        @ApplicationScoped
        @Produces
        List<String> list;

    }

}
