## 目录说明

* UnitTest ： 单元测试用例
* PrefTest ： 性能测试用例

## 使用说明

* 把对应目录下的所有目录拷贝到Assets下，比如你要执行单元测试用例，把UnitTest下两个目录都拷贝到Assets下，然后运行main.unity；
* luajit版本比lua53版本性能要好很多，打开HOTFIX_ENABLE或者THREAD_SAFT宏，性能会略降，因为会对所有C#调用lua的地方都会加上锁，所以你要和其它方案对比的话，用luajit版本测试并确认HOTFIX_ENABLE或者THREAD_SAFT没打开；

## 性能用例的说明

* 用例和网上流行的不太一样，原因是：
  * Unity API本身的开销会影响到测试结果。举个例子：方案A的Lua调用C#函数开销是1ms，方案B是2ms，那么结论应该是A方案性能是B方案两倍，但如果被调用C#函数本身耗时100ms，那结论就是两个方案性能差不多，甚至有时会因为误差得出B方案性能更好的结论；
  * 如果测试中包含重载函数，对比也是不恰当的，因为每个方案的生成代码对于重载判断的顺序不一定一样，不一样的时候，对比也意义不大；
  * 测试Lua调用C#部分用例选择了Vector3，这其实是错误的，市面上大多方案的Vector3是完全在Lua测重新实现，完全没有达到测试“Lua调用C#”的目的；
* xLua本质上做C#和lua之间的适配，所以所有用例的设计原则都是被调用方无开销，比如函数都是直接return

## 几个值类型的方法的性能说明

* 前面也提到，其它方案的Vector3（相类似的还有Vector2，Vector4，Quaternion，Color等）由于直接在lua测实现，而xLua默认仍然是调用C#的实现，测试这些类型的方法的话，xLua性能相比会低很多
  * 你可以选择在lua实现这些方法，配合xlua.genaccessor，性能可以达到同一个数量级。
  * xLua一直坚持使用C#原生实现，一年多的项目应用中，也没有反馈因此而造成的性能问题，应该性能是够用的，如果真的出现不够用的情况，选择在lua实现这块逻辑也是不恰当的，应该直接在C#实现比较合适些。

