﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

using System.Runtime.InteropServices;

internal partial class Interop
{
    internal partial class Mshtml
    {
        [ComImport]
        [Guid("3050F25E-98B5-11CF-BB82-00AA00BDCE0B")]
        [InterfaceType(ComInterfaceType.InterfaceIsDual)]
        public interface IHTMLStyle
        {
            void SetFontFamily(string p);
            string GetFontFamily();
            void SetFontStyle(string p);
            string GetFontStyle();
            void SetFontObject(string p);
            string GetFontObject();
            void SetFontWeight(string p);
            string GetFontWeight();
            void SetFontSize(object p);
            object GetFontSize();
            void SetFont(string p);
            string GetFont();
            void SetColor(object p);
            object GetColor();
            void SetBackground(string p);
            string GetBackground();
            void SetBackgroundColor(object p);
            object GetBackgroundColor();
            void SetBackgroundImage(string p);
            string GetBackgroundImage();
            void SetBackgroundRepeat(string p);
            string GetBackgroundRepeat();
            void SetBackgroundAttachment(string p);
            string GetBackgroundAttachment();
            void SetBackgroundPosition(string p);
            string GetBackgroundPosition();
            void SetBackgroundPositionX(object p);
            object GetBackgroundPositionX();
            void SetBackgroundPositionY(object p);
            object GetBackgroundPositionY();
            void SetWordSpacing(object p);
            object GetWordSpacing();
            void SetLetterSpacing(object p);
            object GetLetterSpacing();
            void SetTextDecoration(string p);
            string GetTextDecoration();
            void SetTextDecorationNone(bool p);
            bool GetTextDecorationNone();
            void SetTextDecorationUnderline(bool p);
            bool GetTextDecorationUnderline();
            void SetTextDecorationOverline(bool p);
            bool GetTextDecorationOverline();
            void SetTextDecorationLineThrough(bool p);
            bool GetTextDecorationLineThrough();
            void SetTextDecorationBlink(bool p);
            bool GetTextDecorationBlink();
            void SetVerticalAlign(object p);
            object GetVerticalAlign();
            void SetTextTransform(string p);
            string GetTextTransform();
            void SetTextAlign(string p);
            string GetTextAlign();
            void SetTextIndent(object p);
            object GetTextIndent();
            void SetLineHeight(object p);
            object GetLineHeight();
            void SetMarginTop(object p);
            object GetMarginTop();
            void SetMarginRight(object p);
            object GetMarginRight();
            void SetMarginBottom(object p);
            object GetMarginBottom();
            void SetMarginLeft(object p);
            object GetMarginLeft();
            void SetMargin(string p);
            string GetMargin();
            void SetPaddingTop(object p);
            object GetPaddingTop();
            void SetPaddingRight(object p);
            object GetPaddingRight();
            void SetPaddingBottom(object p);
            object GetPaddingBottom();
            void SetPaddingLeft(object p);
            object GetPaddingLeft();
            void SetPadding(string p);
            string GetPadding();
            void SetBorder(string p);
            string GetBorder();
            void SetBorderTop(string p);
            string GetBorderTop();
            void SetBorderRight(string p);
            string GetBorderRight();
            void SetBorderBottom(string p);
            string GetBorderBottom();
            void SetBorderLeft(string p);
            string GetBorderLeft();
            void SetBorderColor(string p);
            string GetBorderColor();
            void SetBorderTopColor(object p);
            object GetBorderTopColor();
            void SetBorderRightColor(object p);
            object GetBorderRightColor();
            void SetBorderBottomColor(object p);
            object GetBorderBottomColor();
            void SetBorderLeftColor(object p);
            object GetBorderLeftColor();
            void SetBorderWidth(string p);
            string GetBorderWidth();
            void SetBorderTopWidth(object p);
            object GetBorderTopWidth();
            void SetBorderRightWidth(object p);
            object GetBorderRightWidth();
            void SetBorderBottomWidth(object p);
            object GetBorderBottomWidth();
            void SetBorderLeftWidth(object p);
            object GetBorderLeftWidth();
            void SetBorderStyle(string p);
            string GetBorderStyle();
            void SetBorderTopStyle(string p);
            string GetBorderTopStyle();
            void SetBorderRightStyle(string p);
            string GetBorderRightStyle();
            void SetBorderBottomStyle(string p);
            string GetBorderBottomStyle();
            void SetBorderLeftStyle(string p);
            string GetBorderLeftStyle();
            void SetWidth(object p);
            object GetWidth();
            void SetHeight(object p);
            object GetHeight();
            void SetStyleFloat(string p);
            string GetStyleFloat();
            void SetClear(string p);
            string GetClear();
            void SetDisplay(string p);
            string GetDisplay();
            void SetVisibility(string p);
            string GetVisibility();
            void SetListStyleType(string p);
            string GetListStyleType();
            void SetListStylePosition(string p);
            string GetListStylePosition();
            void SetListStyleImage(string p);
            string GetListStyleImage();
            void SetListStyle(string p);
            string GetListStyle();
            void SetWhiteSpace(string p);
            string GetWhiteSpace();
            void SetTop(object p);
            object GetTop();
            void SetLeft(object p);
            object GetLeft();
            string GetPosition();
            void SetZIndex(object p);
            object GetZIndex();
            void SetOverflow(string p);
            string GetOverflow();
            void SetPageBreakBefore(string p);
            string GetPageBreakBefore();
            void SetPageBreakAfter(string p);
            string GetPageBreakAfter();
            void SetCssText(string p);
            string GetCssText();
            void SetPixelTop(int p);
            int GetPixelTop();
            void SetPixelLeft(int p);
            int GetPixelLeft();
            void SetPixelWidth(int p);
            int GetPixelWidth();
            void SetPixelHeight(int p);
            int GetPixelHeight();
            void SetPosTop(float p);
            float GetPosTop();
            void SetPosLeft(float p);
            float GetPosLeft();
            void SetPosWidth(float p);
            float GetPosWidth();
            void SetPosHeight(float p);
            float GetPosHeight();
            void SetCursor(string p);
            string GetCursor();
            void SetClip(string p);
            string GetClip();
            void SetFilter(string p);
            string GetFilter();
            void SetAttribute(string strAttributeName, object AttributeValue, int lFlags);
            object GetAttribute(string strAttributeName, int lFlags);
            bool RemoveAttribute(string strAttributeName, int lFlags);
        }
    }
}
