﻿// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.

namespace System.Windows.Forms
{
    /// <summary>
    ///  Specifies the border style for a button control.
    /// </summary>
    public enum ButtonBorderStyle
    {
        /// <summary>
        ///  No border.
        /// </summary>
        None,

        /// <summary>
        ///  A dotted-line border.
        /// </summary>
        Dotted,

        /// <summary>
        ///  A dashed border.
        /// </summary>
        Dashed,

        /// <summary>
        ///  A solid border.
        /// </summary>
        Solid,

        /// <summary>
        ///  A sunken border.
        /// </summary>
        Inset,

        /// <summary>
        ///  A raised border.
        /// </summary>
        Outset,
    }
}
