# Tideland Go REST Server Library

## Description

The *Tideland Go REST Server Library* helps developing RESTful server
systems. It provides a convenient mapping of URL to handlers and methods
specific to the called HTTP method. Additionally there are helpers for
marshalling and unmarshalling.

The library earlier has been known as `web` package of the
[Tideland Go Library](https://github.com/tideland/golib).

I hope you like it. ;)

[![GitHub release](https://img.shields.io/github/release/tideland/gorest.svg)](https://github.com/tideland/gorest)
[![GitHub license](https://img.shields.io/badge/license-New%20BSD-blue.svg)](https://raw.githubusercontent.com/tideland/gorest/master/LICENSE)
[![GoDoc](https://godoc.org/github.com/tideland/gorest?status.svg)](https://godoc.org/github.com/tideland/gorest)
[![Sourcegraph](https://sourcegraph.com/github.com/tideland/gorest/-/badge.svg)](https://sourcegraph.com/github.com/tideland/gorest?badge)
[![Go Report Card](https://goreportcard.com/badge/github.com/tideland/gorest)](https://goreportcard.com/report/github.com/tideland/gorest)

## Version

Version 2.15.2

## Packages

### REST

RESTful web request handling.

### Request

Convenient client requests to RESTful web services.

### Handlers

Some general purpose handlers for the library.

### JSON Web Token

JWT package for secure authentication and information exchange like claims.

### REST Audit

Helpers for the unit tests of the Go REST Server Library.

## Contributors

- Frank Mueller (https://github.com/themue / https://github.com/tideland)

## License

*Tideland Go REST Server Library* is distributed under the terms of the BSD 3-Clause license.
