% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheets_id.R
\name{as_id.googlesheets4_spreadsheet}
\alias{as_id.googlesheets4_spreadsheet}
\title{Extract the file id from Sheet metadata}
\usage{
\method{as_id}{googlesheets4_spreadsheet}(x, ...)
}
\arguments{
\item{x}{An instance of \code{googlesheets4_spreadsheet}, which is returned by,
e.g., \code{\link[=gs4_get]{gs4_get()}}.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\value{
A character vector bearing the S3 class \code{drive_id}.
}
\description{
This method implements \code{\link[googledrive:as_id]{googledrive::as_id()}} for the class used here to hold
metadata for a Sheet. It just calls \code{\link[=as_sheets_id]{as_sheets_id()}}, but it's handy in case
you forget that exists and hope that \code{as_id()} will "just work".
}
\examples{
if (gs4_has_token()) {
  ss <- gs4_get(gs4_example("mini-gap"))
  class(ss)
  googledrive::as_id(ss)
}
}
